package org.hsqldb;

class PointerNode extends BaseMemoryNode
{
  int iData = -1;
  private Table tTable;
  private Node nPrimary;

  PointerNode(CachedRow paramCachedRow, int paramInt)
  {
    this.tTable = paramCachedRow.getTable();
    this.iData = paramCachedRow.iPos;
    this.nPrimary = (paramCachedRow.nPrimaryNode == null ? this : paramCachedRow.nPrimaryNode);
  }

  void delete()
  {
    super.delete();
    this.nPrimary = null;
    this.tTable = null;
  }

  int getKey()
  {
    return this.iData;
  }

  Row getRow()
    throws HsqlException
  {
    if (this.iData == -1)
      return null;
    CachedRow localCachedRow = this.tTable.getRow(this.iData, this.nPrimary);
    return localCachedRow;
  }

  Object[] getData()
    throws HsqlException
  {
    return getRow().getData();
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.PointerNode
 * JD-Core Version:    0.6.0
 */