package org.hsqldb;

import java.sql.SQLException;
import org.hsqldb.jdbc.Util;
import org.hsqldb.persist.HsqlProperties;

public class HsqlServerFactory
{
  public static HsqlSocketRequestHandler createHsqlServer(String paramString, boolean paramBoolean1, boolean paramBoolean2)
    throws SQLException
  {
    HsqlProperties localHsqlProperties = new HsqlProperties();
    localHsqlProperties.setProperty("server.database.0", paramString);
    localHsqlProperties.setProperty("server.trace", paramBoolean1);
    localHsqlProperties.setProperty("server.silent", paramBoolean2);
    Server localServer = new Server();
    try
    {
      localServer.setProperties(localHsqlProperties);
    }
    catch (Exception localException)
    {
      throw new SQLException("Failed to set server properties: " + localException);
    }
    if (!localServer.openDatabases())
    {
      Throwable localThrowable = localServer.getServerError();
      if ((localThrowable instanceof HsqlException))
        throw Util.sqlException((HsqlException)localThrowable);
      throw new SQLException(Trace.getMessage(40));
    }
    localServer.setState(1);
    return localServer;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.HsqlServerFactory
 * JD-Core Version:    0.6.0
 */