package org.hsqldb;

import java.io.IOException;
import java.io.OutputStream;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.InOutUtil;
import org.hsqldb.rowio.RowOutputBinary;

public class HTTPClientConnection extends HSQLClientConnection
{
  static final String ENCODING = "8859_1";

  public HTTPClientConnection(String paramString1, int paramInt, String paramString2, String paramString3, boolean paramBoolean, String paramString4, String paramString5)
    throws HsqlException
  {
    super(paramString1, paramInt, paramString2, paramString3, paramBoolean, paramString4, paramString5);
  }

  protected void initConnection(String paramString, int paramInt, boolean paramBoolean)
    throws HsqlException
  {
  }

  public synchronized Result execute(Result paramResult)
    throws HsqlException
  {
    super.openConnection(this.host, this.port, this.isTLS);
    Result localResult = super.execute(paramResult);
    super.closeConnection();
    return localResult;
  }

  protected void write(Result paramResult)
    throws IOException, HsqlException
  {
    this.rowOut.reset();
    paramResult.write(this.rowOut);
    this.dataOutput.write("POST ".getBytes("8859_1"));
    this.dataOutput.write(this.path.getBytes("8859_1"));
    this.dataOutput.write(" HTTP/1.0\r\n".getBytes("8859_1"));
    this.dataOutput.write("Content-Type: application/octet-stream\r\n".getBytes("8859_1"));
    this.dataOutput.write(("Content-Length: " + this.rowOut.size() + "\r\n").getBytes("8859_1"));
    this.dataOutput.write("\r\n".getBytes("8859_1"));
    this.dataOutput.write(this.rowOut.getOutputStream().getBuffer(), 0, this.rowOut.getOutputStream().size());
    this.dataOutput.flush();
  }

  protected Result read()
    throws IOException, HsqlException
  {
    this.rowOut.reset();
    while (true)
    {
      int i = InOutUtil.readLine(this.dataInput, this.rowOut);
      if (i <= 2)
        break;
    }
    Result localResult = Result.read(this.rowIn, this.dataInput);
    return localResult;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.HTTPClientConnection
 * JD-Core Version:    0.6.0
 */