package org.hsqldb;

import java.util.Locale;
import org.hsqldb.resources.BundleHandler;
import org.hsqldb.store.ValuePool;

final class DITableInfo
{
  int bestRowTemporary = 0;
  int bestRowTransaction = 1;
  int bestRowSession = 2;
  int bestRowUnknown = 0;
  int bestRowNotPseudo = 1;
  static final short tableIndexOther = 3;
  private static final int HALF_MAX_INT = 1073741823;
  private int hnd_column_remarks = -1;
  private int hnd_table_remarks = -1;
  private Table table;
  private static final DITypeInfo ti = new DITypeInfo();

  DITableInfo()
  {
    setLocale(Locale.getDefault());
  }

  void setLocale(Locale paramLocale)
  {
    synchronized (BundleHandler.class)
    {
      Locale localLocale = BundleHandler.getLocale();
      BundleHandler.setLocale(paramLocale);
      this.hnd_column_remarks = BundleHandler.getBundleHandle("column-remarks", null);
      this.hnd_table_remarks = BundleHandler.getBundleHandle("table-remarks", null);
      BundleHandler.setLocale(localLocale);
    }
  }

  Integer getBRIPseudo()
  {
    return ValuePool.getInt(this.bestRowNotPseudo);
  }

  Integer getBRIScope()
  {
    return this.table.isWritable() ? ValuePool.getInt(this.bestRowTemporary) : ValuePool.getInt(this.bestRowSession);
  }

  Integer getColBufLen(int paramInt)
  {
    Column localColumn = this.table.getColumn(paramInt);
    int j = localColumn.getDIType();
    int i;
    switch (j)
    {
    case -1:
    case 1:
    case 12:
    case 2005:
      i = localColumn.getSize();
      if (i == 0)
        break;
      if (i > 1073741823)
        i = 0;
      else
        i = 2 * i;
      break;
    case -4:
    case -3:
    case -2:
    case 2004:
      i = localColumn.getSize();
      break;
    case -5:
    case 6:
    case 7:
    case 8:
    case 91:
    case 92:
      i = 8;
      break;
    case 93:
      i = 12;
      break;
    case -6:
    case 4:
    case 5:
      i = 4;
      break;
    case 16:
      i = 1;
      break;
    default:
      i = 0;
    }
    return i > 0 ? ValuePool.getInt(i) : null;
  }

  Integer getColCharOctLen(int paramInt)
  {
    Column localColumn = this.table.getColumn(paramInt);
    int j = localColumn.getDIType();
    int i;
    switch (j)
    {
    case -1:
    case 1:
    case 12:
    case 2005:
      i = localColumn.getSize();
      if (i == 0)
        break;
      if (i > 1073741823)
        i = 0;
      else
        i = 2 * i;
      break;
    default:
      i = 0;
    }
    return i == 0 ? null : ValuePool.getInt(i);
  }

  Integer getColDataType(int paramInt)
  {
    return ValuePool.getInt(this.table.getColumn(paramInt).getDIType());
  }

  String getColDataTypeName(int paramInt)
  {
    Column localColumn = this.table.getColumn(paramInt);
    ti.setTypeCode(localColumn.getDIType());
    ti.setTypeSub(localColumn.getDITypeSub());
    return ti.getTypeName();
  }

  Integer getColDataTypeSub(int paramInt)
  {
    return ValuePool.getInt(this.table.getColumn(paramInt).getDITypeSub());
  }

  String getColDefault(int paramInt)
  {
    return this.table.getColumn(paramInt).getDefaultDDL();
  }

  Boolean getColIsIdentity(int paramInt)
  {
    return ValuePool.getBoolean(this.table.getColumn(paramInt).isIdentity());
  }

  String getColIsNullable(int paramInt)
  {
    Column localColumn = this.table.getColumn(paramInt);
    return (localColumn.isNullable()) && (!localColumn.isIdentity()) ? "YES" : "NO";
  }

  String getColName(int paramInt)
  {
    return this.table.getColumn(paramInt).columnName.name;
  }

  Integer getColNullability(int paramInt)
  {
    Column localColumn = this.table.getColumn(paramInt);
    return (localColumn.isNullable()) && (!localColumn.isIdentity()) ? ValuePool.getInt(1) : ValuePool.getInt(0);
  }

  Integer getColPrecRadix(int paramInt)
  {
    ti.setTypeCode(this.table.getColumn(paramInt).getDIType());
    return ti.getNumPrecRadix();
  }

  String getColRemarks(int paramInt)
  {
    if (this.table.getTableType() != 0)
      return null;
    String str = getName() + "_" + getColName(paramInt);
    return BundleHandler.getString(this.hnd_column_remarks, str);
  }

  Integer getColScale(int paramInt)
  {
    Column localColumn = this.table.getColumn(paramInt);
    int i = localColumn.getDIType();
    return Types.acceptsScaleCreateParam(i) ? ValuePool.getInt(localColumn.getScale()) : null;
  }

  String getColScopeCat(int paramInt)
  {
    return null;
  }

  String getColScopeSchem(int paramInt)
  {
    return null;
  }

  String getColScopeTable(int paramInt)
  {
    return null;
  }

  Integer getColSize(int paramInt)
  {
    Column localColumn = this.table.getColumn(paramInt);
    int i = localColumn.getDIType();
    if (!Types.acceptsPrecisionCreateParam(i))
      return null;
    int j = localColumn.getSize();
    if (j > 0)
      return ValuePool.getInt(j);
    ti.setTypeCode(i);
    return ti.getPrecision();
  }

  Integer getColSqlDataType(int paramInt)
  {
    ti.setTypeCode(this.table.getColumn(paramInt).getDIType());
    return ti.getSqlDataType();
  }

  Integer getColSqlDateTimeSub(int paramInt)
  {
    ti.setTypeCode(this.table.getColumn(paramInt).getDIType());
    return ti.getSqlDateTimeSub();
  }

  String getDataSource()
  {
    return this.table.getDataSource();
  }

  String getHsqlType()
  {
    switch (this.table.getTableType())
    {
    case 0:
    case 2:
    case 3:
      return "MEMORY";
    case 4:
      return "CACHED";
    case 5:
    case 6:
      return "TEXT";
    case 1:
    case 7:
    }
    return null;
  }

  Integer getIndexCardinality(int paramInt)
  {
    return null;
  }

  String getIndexColDirection(int paramInt1, int paramInt2)
  {
    return "A";
  }

  int[] getIndexColumns(int paramInt)
  {
    return this.table.getIndex(paramInt).getColumns();
  }

  String getIndexName(int paramInt)
  {
    return this.table.getIndex(paramInt).getName().name;
  }

  Integer getIndexRowCardinality(int paramInt)
  {
    return null;
  }

  Integer getIndexType(int paramInt)
  {
    return ValuePool.getInt(3);
  }

  int getIndexVisibleColumns(int paramInt)
  {
    return this.table.getIndex(paramInt).getVisibleColumns();
  }

  String getName()
  {
    return this.table.getName().name;
  }

  Long getNextIdentity()
  {
    if (this.table.identityColumn < 0)
      return null;
    return ValuePool.getLong(this.table.identitySequence.peek());
  }

  String getRemark()
  {
    return this.table.getTableType() == 0 ? BundleHandler.getString(this.hnd_table_remarks, getName()) : null;
  }

  String getStandardType()
  {
    switch (this.table.getTableType())
    {
    case 7:
      return "VIEW";
    case 2:
    case 5:
      return "GLOBAL TEMPORARY";
    case 0:
      return "SYSTEM TABLE";
    case 1:
    case 3:
    case 4:
    case 6:
    }
    return "TABLE";
  }

  Table getTable()
  {
    return this.table;
  }

  Boolean isDataSourceDescending()
  {
    return ValuePool.getBoolean(this.table.isDescDataSource());
  }

  Boolean isIndexNonUnique(int paramInt)
  {
    return ValuePool.getBoolean(!this.table.getIndex(paramInt).isUnique());
  }

  Boolean isReadOnly()
  {
    return ValuePool.getBoolean(this.table.isDataReadOnly());
  }

  void setTable(Table paramTable)
  {
    this.table = paramTable;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.DITableInfo
 * JD-Core Version:    0.6.0
 */