package org.hsqldb;

import java.io.IOException;
import org.hsqldb.rowio.RowOutputInterface;

abstract class BaseMemoryNode extends Node
{
  protected Node nLeft;
  protected Node nRight;
  protected Node nParent;

  void delete()
  {
    this.iBalance = -2;
    this.nLeft = (this.nRight = this.nParent = null);
  }

  Node getLeft()
    throws HsqlException
  {
    return this.nLeft;
  }

  void setLeft(Node paramNode)
    throws HsqlException
  {
    this.nLeft = paramNode;
  }

  boolean isLeft(Node paramNode)
    throws HsqlException
  {
    return this.nLeft == paramNode;
  }

  boolean isRight(Node paramNode)
    throws HsqlException
  {
    return this.nRight == paramNode;
  }

  Node getRight()
    throws HsqlException
  {
    return this.nRight;
  }

  void setRight(Node paramNode)
    throws HsqlException
  {
    this.nRight = paramNode;
  }

  Node getParent()
    throws HsqlException
  {
    return this.nParent;
  }

  boolean isRoot()
  {
    return this.nParent == null;
  }

  void setParent(Node paramNode)
    throws HsqlException
  {
    this.nParent = paramNode;
  }

  void setBalance(int paramInt)
    throws HsqlException
  {
    this.iBalance = paramInt;
  }

  boolean isFromLeft()
    throws HsqlException
  {
    if (isRoot())
      return true;
    Node localNode = getParent();
    return equals(localNode.getLeft());
  }

  boolean equals(Node paramNode)
  {
    return paramNode == this;
  }

  void write(RowOutputInterface paramRowOutputInterface)
    throws IOException
  {
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.BaseMemoryNode
 * JD-Core Version:    0.6.0
 */