/*     */ package org.apache.xml.resolver.apps;
/*     */ 
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintStream;
/*     */ import java.util.Date;
/*     */ import java.util.Vector;
/*     */ import org.apache.xml.resolver.Catalog;
/*     */ import org.apache.xml.resolver.CatalogManager;
/*     */ import org.apache.xml.resolver.helpers.Debug;
/*     */ import org.apache.xml.resolver.tools.ResolvingXMLFilter;
/*     */ import org.apache.xml.resolver.tools.ResolvingXMLReader;
/*     */ import org.xml.sax.SAXException;
/*     */ import org.xml.sax.helpers.XMLFilterImpl;
/*     */ 
/*     */ public class xread
/*     */ {
/*  80 */   private static Debug debug = CatalogManager.getStaticManager().debug;
/*     */ 
/*     */   public static void main(String[] args)
/*     */     throws FileNotFoundException, IOException
/*     */   {
/*  86 */     String xmlfile = null;
/*  87 */     int debuglevel = 0;
/*  88 */     int maxErrs = 10;
/*  89 */     boolean nsAware = true;
/*  90 */     boolean validating = true;
/*  91 */     boolean useSchema = false;
/*  92 */     boolean showWarnings = debuglevel > 2;
/*  93 */     boolean showErrors = true;
/*  94 */     Vector catalogFiles = new Vector();
/*     */ 
/*  96 */     for (int i = 0; i < args.length; i++) {
/*  97 */       if (args[i].equals("-c")) {
/*  98 */         i++;
/*  99 */         catalogFiles.add(args[i]);
/*     */       }
/* 103 */       else if (args[i].equals("-w")) {
/* 104 */         validating = false;
/*     */       }
/* 108 */       else if (args[i].equals("-v")) {
/* 109 */         validating = true;
/*     */       }
/* 113 */       else if (args[i].equals("-s")) {
/* 114 */         useSchema = true;
/*     */       }
/* 118 */       else if (args[i].equals("-n")) {
/* 119 */         nsAware = false;
/*     */       }
/* 123 */       else if (args[i].equals("-N")) {
/* 124 */         nsAware = true;
/*     */       }
/* 128 */       else if (args[i].equals("-d")) {
/* 129 */         i++;
/* 130 */         String debugstr = args[i];
/*     */         try {
/* 132 */           debuglevel = Integer.parseInt(debugstr);
/* 133 */           if (debuglevel >= 0) {
/* 134 */             debug.setDebug(debuglevel);
/* 135 */             showWarnings = debuglevel > 2;
/*     */           }
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/*     */         }
/*     */ 
/*     */       }
/* 143 */       else if (args[i].equals("-E")) {
/* 144 */         i++;
/* 145 */         String errstr = args[i];
/*     */         try {
/* 147 */           int errs = Integer.parseInt(errstr);
/* 148 */           if (errs >= 0)
/* 149 */             maxErrs = errs;
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 157 */         xmlfile = args[i];
/*     */       }
/*     */     }
/* 160 */     if (xmlfile == null) {
/* 161 */       System.out.println("Usage: org.apache.xml.resolver.apps.xread [opts] xmlfile");
/* 162 */       System.exit(1);
/*     */     }
/*     */ 
/* 165 */     ResolvingXMLReader reader = new ResolvingXMLReader();
/*     */     try
/*     */     {
/* 168 */       reader.setFeature("http://xml.org/sax/features/namespaces", nsAware);
/* 169 */       reader.setFeature("http://xml.org/sax/features/validation", validating);
/* 170 */       if (useSchema) {
/* 171 */         reader.setFeature("http://apache.org/xml/features/validation/schema", true);
/*     */       }
/*     */     }
/*     */     catch (SAXException e)
/*     */     {
/*     */     }
/* 177 */     Catalog catalog = reader.getCatalog();
/*     */ 
/* 179 */     for (int count = 0; count < catalogFiles.size(); count++) {
/* 180 */       String file = (String)catalogFiles.elementAt(count);
/* 181 */       catalog.parseCatalog(file);
/*     */     }
/*     */ 
/* 184 */     XParseError xpe = new XParseError(showErrors, showWarnings);
/* 185 */     xpe.setMaxMessages(maxErrs);
/* 186 */     reader.setErrorHandler(xpe);
/*     */ 
/* 188 */     String parseType = validating ? "validating" : "well-formed";
/* 189 */     String nsType = nsAware ? "namespace-aware" : "namespace-ignorant";
/* 190 */     if (maxErrs > 0) {
/* 191 */       System.out.println("Attempting " + parseType + ", " + nsType + " parse");
/*     */     }
/*     */ 
/* 198 */     Date startTime = new Date();
/*     */     try
/*     */     {
/* 201 */       reader.parse(xmlfile);
/*     */     } catch (SAXException sx) {
/* 203 */       System.out.println("SAX Exception: " + sx);
/*     */     } catch (Exception e) {
/* 205 */       e.printStackTrace();
/*     */     }
/*     */ 
/* 208 */     Date endTime = new Date();
/*     */ 
/* 210 */     long millisec = endTime.getTime() - startTime.getTime();
/* 211 */     long secs = 0L;
/* 212 */     long mins = 0L;
/* 213 */     long hours = 0L;
/*     */ 
/* 215 */     if (millisec > 1000L) {
/* 216 */       secs = millisec / 1000L;
/* 217 */       millisec %= 1000L;
/*     */     }
/*     */ 
/* 220 */     if (secs > 60L) {
/* 221 */       mins = secs / 60L;
/* 222 */       secs %= 60L;
/*     */     }
/*     */ 
/* 225 */     if (mins > 60L) {
/* 226 */       hours = mins / 60L;
/* 227 */       mins %= 60L;
/*     */     }
/*     */ 
/* 230 */     if (maxErrs > 0) {
/* 231 */       System.out.print("Parse ");
/* 232 */       if (xpe.getFatalCount() > 0) {
/* 233 */         System.out.print("failed ");
/*     */       } else {
/* 235 */         System.out.print("succeeded ");
/* 236 */         System.out.print("(");
/* 237 */         if (hours > 0L) {
/* 238 */           System.out.print(hours + ":");
/*     */         }
/* 240 */         if ((hours > 0L) || (mins > 0L)) {
/* 241 */           System.out.print(mins + ":");
/*     */         }
/* 243 */         System.out.print(secs + "." + millisec);
/* 244 */         System.out.print(") ");
/*     */       }
/* 246 */       System.out.print("with ");
/*     */ 
/* 248 */       int errCount = xpe.getErrorCount();
/* 249 */       int warnCount = xpe.getWarningCount();
/*     */ 
/* 251 */       if (errCount > 0) {
/* 252 */         System.out.print(errCount + " error");
/* 253 */         System.out.print(errCount > 1 ? "s" : "");
/* 254 */         System.out.print(" and ");
/*     */       } else {
/* 256 */         System.out.print("no errors and ");
/*     */       }
/*     */ 
/* 259 */       if (warnCount > 0) {
/* 260 */         System.out.print(warnCount + " warning");
/* 261 */         System.out.print(warnCount > 1 ? "s" : "");
/* 262 */         System.out.print(".");
/*     */       } else {
/* 264 */         System.out.print("no warnings.");
/*     */       }
/*     */ 
/* 267 */       System.out.println("");
/*     */     }
/*     */ 
/* 270 */     if (xpe.getErrorCount() > 0)
/* 271 */       System.exit(1);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.xml.resolver.apps.xread
 * JD-Core Version:    0.6.0
 */