/*     */ package org.apache.xml.resolver.apps;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import org.apache.xml.resolver.helpers.FileURL;
/*     */ import org.xml.sax.ErrorHandler;
/*     */ import org.xml.sax.SAXException;
/*     */ import org.xml.sax.SAXParseException;
/*     */ 
/*     */ public class XParseError
/*     */   implements ErrorHandler
/*     */ {
/*  44 */   private boolean showErrors = true;
/*     */ 
/*  47 */   private boolean showWarnings = false;
/*     */ 
/*  50 */   private int maxMessages = 10;
/*     */ 
/*  53 */   private int fatalCount = 0;
/*     */ 
/*  56 */   private int errorCount = 0;
/*     */ 
/*  59 */   private int warningCount = 0;
/*     */ 
/*  62 */   private String baseURI = "";
/*     */ 
/*     */   public XParseError(boolean errors, boolean warnings)
/*     */   {
/*  66 */     this.showErrors = errors;
/*  67 */     this.showWarnings = warnings;
/*     */     try
/*     */     {
/*  70 */       URL url = FileURL.makeURL("basename");
/*  71 */       this.baseURI = url.toString();
/*     */     }
/*     */     catch (MalformedURLException mue)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getErrorCount() {
/*  79 */     return this.errorCount;
/*     */   }
/*     */ 
/*     */   public int getFatalCount()
/*     */   {
/*  84 */     return this.fatalCount;
/*     */   }
/*     */ 
/*     */   public int getWarningCount()
/*     */   {
/*  89 */     return this.warningCount;
/*     */   }
/*     */ 
/*     */   public int getMaxMessages()
/*     */   {
/*  94 */     return this.maxMessages;
/*     */   }
/*     */ 
/*     */   public void setMaxMessages(int max)
/*     */   {
/*  99 */     this.maxMessages = max;
/*     */   }
/*     */ 
/*     */   public void error(SAXParseException exception)
/*     */   {
/* 104 */     this.errorCount += 1;
/* 105 */     if ((this.showErrors) && (this.errorCount + this.warningCount < this.maxMessages))
/* 106 */       message("Error", exception);
/*     */   }
/*     */ 
/*     */   public void fatalError(SAXParseException exception)
/*     */   {
/* 112 */     this.errorCount += 1;
/* 113 */     this.fatalCount += 1;
/* 114 */     if ((this.showErrors) && (this.errorCount + this.warningCount < this.maxMessages))
/* 115 */       message("Fatal error", exception);
/*     */   }
/*     */ 
/*     */   public void warning(SAXParseException exception)
/*     */   {
/* 121 */     this.warningCount += 1;
/* 122 */     if ((this.showWarnings) && (this.errorCount + this.warningCount < this.maxMessages))
/* 123 */       message("Warning", exception);
/*     */   }
/*     */ 
/*     */   private void message(String type, SAXParseException exception)
/*     */   {
/* 129 */     String filename = exception.getSystemId();
/* 130 */     if (filename.startsWith(this.baseURI)) {
/* 131 */       filename = filename.substring(this.baseURI.length());
/*     */     }
/*     */ 
/* 134 */     System.out.print(type + ":" + filename + ":" + exception.getLineNumber());
/*     */ 
/* 140 */     if (exception.getColumnNumber() > 0) {
/* 141 */       System.out.print(":" + exception.getColumnNumber());
/*     */     }
/*     */ 
/* 144 */     System.out.println(":" + exception.getMessage());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.xml.resolver.apps.XParseError
 * JD-Core Version:    0.6.0
 */