package org.apache.xerces.parsers;

import java.io.IOException;
import org.apache.xerces.util.EntityResolver2Wrapper;
import org.apache.xerces.util.EntityResolverWrapper;
import org.apache.xerces.util.ErrorHandlerWrapper;
import org.apache.xerces.util.SAXMessageFormatter;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.EntityResolver2;
import org.xml.sax.helpers.LocatorImpl;

public class DOMParser extends AbstractDOMParser
{
  protected static final String USE_ENTITY_RESOLVER2 = "http://xml.org/sax/features/use-entity-resolver2";
  protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
  protected static final String XMLGRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
  private static final String[] RECOGNIZED_PROPERTIES = { "http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/grammar-pool" };
  protected boolean fUseEntityResolver2 = true;

  public DOMParser(XMLParserConfiguration paramXMLParserConfiguration)
  {
    super(paramXMLParserConfiguration);
  }

  public DOMParser()
  {
    this(null, null);
  }

  public DOMParser(SymbolTable paramSymbolTable)
  {
    this(paramSymbolTable, null);
  }

  public DOMParser(SymbolTable paramSymbolTable, XMLGrammarPool paramXMLGrammarPool)
  {
    super((XMLParserConfiguration)ObjectFactory.createObject("org.apache.xerces.xni.parser.XMLParserConfiguration", "org.apache.xerces.parsers.XIncludeAwareParserConfiguration"));
    this.fConfiguration.addRecognizedProperties(RECOGNIZED_PROPERTIES);
    if (paramSymbolTable != null)
      this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/symbol-table", paramSymbolTable);
    if (paramXMLGrammarPool != null)
      this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/grammar-pool", paramXMLGrammarPool);
  }

  public void parse(String paramString)
    throws SAXException, IOException
  {
    XMLInputSource localXMLInputSource = new XMLInputSource(null, paramString, null);
    try
    {
      parse(localXMLInputSource);
    }
    catch (XMLParseException localXMLParseException)
    {
      Exception localException = localXMLParseException.getException();
      if (localException == null)
      {
        localObject = new LocatorImpl();
        ((LocatorImpl)localObject).setPublicId(localXMLParseException.getPublicId());
        ((LocatorImpl)localObject).setSystemId(localXMLParseException.getExpandedSystemId());
        ((LocatorImpl)localObject).setLineNumber(localXMLParseException.getLineNumber());
        ((LocatorImpl)localObject).setColumnNumber(localXMLParseException.getColumnNumber());
        throw new SAXParseException(localXMLParseException.getMessage(), (Locator)localObject);
      }
      if ((localException instanceof SAXException))
        throw ((SAXException)localException);
      if ((localException instanceof IOException))
        throw ((IOException)localException);
      throw new SAXException(localException);
    }
    catch (XNIException localXNIException)
    {
      localXNIException.printStackTrace();
      Object localObject = localXNIException.getException();
      if (localObject == null)
        throw new SAXException(localXNIException.getMessage());
      if ((localObject instanceof SAXException))
        throw ((SAXException)localObject);
      if ((localObject instanceof IOException))
        throw ((IOException)localObject);
      throw new SAXException((Exception)localObject);
    }
  }

  public void parse(InputSource paramInputSource)
    throws SAXException, IOException
  {
    try
    {
      XMLInputSource localXMLInputSource = new XMLInputSource(paramInputSource.getPublicId(), paramInputSource.getSystemId(), null);
      localXMLInputSource.setByteStream(paramInputSource.getByteStream());
      localXMLInputSource.setCharacterStream(paramInputSource.getCharacterStream());
      localXMLInputSource.setEncoding(paramInputSource.getEncoding());
      parse(localXMLInputSource);
    }
    catch (XMLParseException localXMLParseException)
    {
      Exception localException = localXMLParseException.getException();
      if (localException == null)
      {
        localObject = new LocatorImpl();
        ((LocatorImpl)localObject).setPublicId(localXMLParseException.getPublicId());
        ((LocatorImpl)localObject).setSystemId(localXMLParseException.getExpandedSystemId());
        ((LocatorImpl)localObject).setLineNumber(localXMLParseException.getLineNumber());
        ((LocatorImpl)localObject).setColumnNumber(localXMLParseException.getColumnNumber());
        throw new SAXParseException(localXMLParseException.getMessage(), (Locator)localObject);
      }
      if ((localException instanceof SAXException))
        throw ((SAXException)localException);
      if ((localException instanceof IOException))
        throw ((IOException)localException);
      throw new SAXException(localException);
    }
    catch (XNIException localXNIException)
    {
      Object localObject = localXNIException.getException();
      if (localObject == null)
        throw new SAXException(localXNIException.getMessage());
      if ((localObject instanceof SAXException))
        throw ((SAXException)localObject);
      if ((localObject instanceof IOException))
        throw ((IOException)localObject);
      throw new SAXException((Exception)localObject);
    }
  }

  public void setEntityResolver(EntityResolver paramEntityResolver)
  {
    try
    {
      XMLEntityResolver localXMLEntityResolver = (XMLEntityResolver)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/entity-resolver");
      Object localObject;
      if ((this.fUseEntityResolver2) && ((paramEntityResolver instanceof EntityResolver2)))
      {
        if ((localXMLEntityResolver instanceof EntityResolver2Wrapper))
        {
          localObject = (EntityResolver2Wrapper)localXMLEntityResolver;
          ((EntityResolver2Wrapper)localObject).setEntityResolver((EntityResolver2)paramEntityResolver);
        }
        else
        {
          this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/entity-resolver", new EntityResolver2Wrapper((EntityResolver2)paramEntityResolver));
        }
      }
      else if ((localXMLEntityResolver instanceof EntityResolverWrapper))
      {
        localObject = (EntityResolverWrapper)localXMLEntityResolver;
        ((EntityResolverWrapper)localObject).setEntityResolver(paramEntityResolver);
      }
      else
      {
        this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/entity-resolver", new EntityResolverWrapper(paramEntityResolver));
      }
    }
    catch (XMLConfigurationException localXMLConfigurationException)
    {
    }
  }

  public EntityResolver getEntityResolver()
  {
    Object localObject = null;
    try
    {
      XMLEntityResolver localXMLEntityResolver = (XMLEntityResolver)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/entity-resolver");
      if (localXMLEntityResolver != null)
        if ((localXMLEntityResolver instanceof EntityResolverWrapper))
          localObject = ((EntityResolverWrapper)localXMLEntityResolver).getEntityResolver();
        else if ((localXMLEntityResolver instanceof EntityResolver2Wrapper))
          localObject = ((EntityResolver2Wrapper)localXMLEntityResolver).getEntityResolver();
    }
    catch (XMLConfigurationException localXMLConfigurationException)
    {
    }
    return (EntityResolver)localObject;
  }

  public void setErrorHandler(ErrorHandler paramErrorHandler)
  {
    try
    {
      XMLErrorHandler localXMLErrorHandler = (XMLErrorHandler)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/error-handler");
      if ((localXMLErrorHandler instanceof ErrorHandlerWrapper))
      {
        ErrorHandlerWrapper localErrorHandlerWrapper = (ErrorHandlerWrapper)localXMLErrorHandler;
        localErrorHandlerWrapper.setErrorHandler(paramErrorHandler);
      }
      else
      {
        this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/error-handler", new ErrorHandlerWrapper(paramErrorHandler));
      }
    }
    catch (XMLConfigurationException localXMLConfigurationException)
    {
    }
  }

  public ErrorHandler getErrorHandler()
  {
    ErrorHandler localErrorHandler = null;
    try
    {
      XMLErrorHandler localXMLErrorHandler = (XMLErrorHandler)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/error-handler");
      if ((localXMLErrorHandler != null) && ((localXMLErrorHandler instanceof ErrorHandlerWrapper)))
        localErrorHandler = ((ErrorHandlerWrapper)localXMLErrorHandler).getErrorHandler();
    }
    catch (XMLConfigurationException localXMLConfigurationException)
    {
    }
    return localErrorHandler;
  }

  public void setFeature(String paramString, boolean paramBoolean)
    throws SAXNotRecognizedException, SAXNotSupportedException
  {
    try
    {
      if (paramString.equals("http://xml.org/sax/features/use-entity-resolver2"))
      {
        if (paramBoolean != this.fUseEntityResolver2)
        {
          this.fUseEntityResolver2 = paramBoolean;
          setEntityResolver(getEntityResolver());
        }
        return;
      }
      this.fConfiguration.setFeature(paramString, paramBoolean);
    }
    catch (XMLConfigurationException localXMLConfigurationException)
    {
      String str = localXMLConfigurationException.getIdentifier();
      if (localXMLConfigurationException.getType() == 0)
        throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "feature-not-recognized", new Object[] { str }));
      throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "feature-not-supported", new Object[] { str }));
    }
  }

  public boolean getFeature(String paramString)
    throws SAXNotRecognizedException, SAXNotSupportedException
  {
    // Byte code:
    //   0: aload_1
    //   1: ldc 65
    //   3: invokevirtual 66	java/lang/String:equals	(Ljava/lang/Object;)Z
    //   6: ifeq +8 -> 14
    //   9: aload_0
    //   10: getfield 2	org/apache/xerces/parsers/DOMParser:fUseEntityResolver2	Z
    //   13: ireturn
    //   14: aload_0
    //   15: getfield 8	org/apache/xerces/parsers/XMLParser:fConfiguration	Lorg/apache/xerces/xni/parser/XMLParserConfiguration;
    //   18: aload_1
    //   19: invokeinterface 81 2 0
    //   24: ireturn
    //   25: astore_2
    //   26: aload_2
    //   27: invokevirtual 70	org/apache/xerces/xni/parser/XMLConfigurationException:getIdentifier	()Ljava/lang/String;
    //   30: astore_3
    //   31: aload_2
    //   32: invokevirtual 71	org/apache/xerces/xni/parser/XMLConfigurationException:getType	()S
    //   35: ifne +33 -> 68
    //   38: new 72	org/xml/sax/SAXNotRecognizedException
    //   41: dup
    //   42: aload_0
    //   43: getfield 8	org/apache/xerces/parsers/XMLParser:fConfiguration	Lorg/apache/xerces/xni/parser/XMLParserConfiguration;
    //   46: invokeinterface 73 1 0
    //   51: ldc 74
    //   53: iconst_1
    //   54: anewarray 75	java/lang/Object
    //   57: dup
    //   58: iconst_0
    //   59: aload_3
    //   60: aastore
    //   61: invokestatic 76	org/apache/xerces/util/SAXMessageFormatter:formatMessage	(Ljava/util/Locale;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;
    //   64: invokespecial 77	org/xml/sax/SAXNotRecognizedException:<init>	(Ljava/lang/String;)V
    //   67: athrow
    //   68: new 78	org/xml/sax/SAXNotSupportedException
    //   71: dup
    //   72: aload_0
    //   73: getfield 8	org/apache/xerces/parsers/XMLParser:fConfiguration	Lorg/apache/xerces/xni/parser/XMLParserConfiguration;
    //   76: invokeinterface 73 1 0
    //   81: ldc 79
    //   83: iconst_1
    //   84: anewarray 75	java/lang/Object
    //   87: dup
    //   88: iconst_0
    //   89: aload_3
    //   90: aastore
    //   91: invokestatic 76	org/apache/xerces/util/SAXMessageFormatter:formatMessage	(Ljava/util/Locale;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;
    //   94: invokespecial 80	org/xml/sax/SAXNotSupportedException:<init>	(Ljava/lang/String;)V
    //   97: athrow
    //
    // Exception table:
    //   from	to	target	type
    //   0	25	25	org/apache/xerces/xni/parser/XMLConfigurationException
  }

  public void setProperty(String paramString, Object paramObject)
    throws SAXNotRecognizedException, SAXNotSupportedException
  {
    try
    {
      this.fConfiguration.setProperty(paramString, paramObject);
    }
    catch (XMLConfigurationException localXMLConfigurationException)
    {
      String str = localXMLConfigurationException.getIdentifier();
      if (localXMLConfigurationException.getType() == 0)
        throw new SAXNotRecognizedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "property-not-recognized", new Object[] { str }));
      throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(this.fConfiguration.getLocale(), "property-not-supported", new Object[] { str }));
    }
  }

  public Object getProperty(String paramString)
    throws SAXNotRecognizedException, SAXNotSupportedException
  {
    // Byte code:
    //   0: aload_1
    //   1: ldc 84
    //   3: invokevirtual 66	java/lang/String:equals	(Ljava/lang/Object;)Z
    //   6: ifeq +59 -> 65
    //   9: iconst_0
    //   10: istore_2
    //   11: aload_0
    //   12: ldc 85
    //   14: invokevirtual 86	org/apache/xerces/parsers/DOMParser:getFeature	(Ljava/lang/String;)Z
    //   17: istore_2
    //   18: goto +4 -> 22
    //   21: astore_3
    //   22: iload_2
    //   23: ifeq +13 -> 36
    //   26: new 78	org/xml/sax/SAXNotSupportedException
    //   29: dup
    //   30: ldc 87
    //   32: invokespecial 80	org/xml/sax/SAXNotSupportedException:<init>	(Ljava/lang/String;)V
    //   35: athrow
    //   36: aload_0
    //   37: getfield 88	org/apache/xerces/parsers/AbstractDOMParser:fCurrentNode	Lorg/w3c/dom/Node;
    //   40: ifnull +23 -> 63
    //   43: aload_0
    //   44: getfield 88	org/apache/xerces/parsers/AbstractDOMParser:fCurrentNode	Lorg/w3c/dom/Node;
    //   47: invokeinterface 89 1 0
    //   52: iconst_1
    //   53: if_icmpne +10 -> 63
    //   56: aload_0
    //   57: getfield 88	org/apache/xerces/parsers/AbstractDOMParser:fCurrentNode	Lorg/w3c/dom/Node;
    //   60: goto +4 -> 64
    //   63: aconst_null
    //   64: areturn
    //   65: aload_0
    //   66: getfield 8	org/apache/xerces/parsers/XMLParser:fConfiguration	Lorg/apache/xerces/xni/parser/XMLParserConfiguration;
    //   69: aload_1
    //   70: invokeinterface 47 2 0
    //   75: areturn
    //   76: astore_2
    //   77: aload_2
    //   78: invokevirtual 70	org/apache/xerces/xni/parser/XMLConfigurationException:getIdentifier	()Ljava/lang/String;
    //   81: astore_3
    //   82: aload_2
    //   83: invokevirtual 71	org/apache/xerces/xni/parser/XMLConfigurationException:getType	()S
    //   86: ifne +33 -> 119
    //   89: new 72	org/xml/sax/SAXNotRecognizedException
    //   92: dup
    //   93: aload_0
    //   94: getfield 8	org/apache/xerces/parsers/XMLParser:fConfiguration	Lorg/apache/xerces/xni/parser/XMLParserConfiguration;
    //   97: invokeinterface 73 1 0
    //   102: ldc 82
    //   104: iconst_1
    //   105: anewarray 75	java/lang/Object
    //   108: dup
    //   109: iconst_0
    //   110: aload_3
    //   111: aastore
    //   112: invokestatic 76	org/apache/xerces/util/SAXMessageFormatter:formatMessage	(Ljava/util/Locale;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;
    //   115: invokespecial 77	org/xml/sax/SAXNotRecognizedException:<init>	(Ljava/lang/String;)V
    //   118: athrow
    //   119: new 78	org/xml/sax/SAXNotSupportedException
    //   122: dup
    //   123: aload_0
    //   124: getfield 8	org/apache/xerces/parsers/XMLParser:fConfiguration	Lorg/apache/xerces/xni/parser/XMLParserConfiguration;
    //   127: invokeinterface 73 1 0
    //   132: ldc 83
    //   134: iconst_1
    //   135: anewarray 75	java/lang/Object
    //   138: dup
    //   139: iconst_0
    //   140: aload_3
    //   141: aastore
    //   142: invokestatic 76	org/apache/xerces/util/SAXMessageFormatter:formatMessage	(Ljava/util/Locale;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;
    //   145: invokespecial 80	org/xml/sax/SAXNotSupportedException:<init>	(Ljava/lang/String;)V
    //   148: athrow
    //
    // Exception table:
    //   from	to	target	type
    //   11	18	21	org/apache/xerces/xni/parser/XMLConfigurationException
    //   65	76	76	org/apache/xerces/xni/parser/XMLConfigurationException
  }

  public XMLParserConfiguration getXMLParserConfiguration()
  {
    return this.fConfiguration;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.xerces.parsers.DOMParser
 * JD-Core Version:    0.6.0
 */