package org.apache.xerces.dom;

import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeepNodeListImpl
  implements NodeList
{
  protected NodeImpl rootNode;
  protected String tagName;
  protected int changes = 0;
  protected Vector nodes;
  protected String nsName;
  protected boolean enableNS = false;

  public DeepNodeListImpl(NodeImpl paramNodeImpl, String paramString)
  {
    this.rootNode = paramNodeImpl;
    this.tagName = paramString;
    this.nodes = new Vector();
  }

  public DeepNodeListImpl(NodeImpl paramNodeImpl, String paramString1, String paramString2)
  {
    this(paramNodeImpl, paramString2);
    this.nsName = ((paramString1 != null) && (!paramString1.equals("")) ? paramString1 : null);
    this.enableNS = true;
  }

  public int getLength()
  {
    item(2147483647);
    return this.nodes.size();
  }

  public Node item(int paramInt)
  {
    if (this.rootNode.changes() != this.changes)
    {
      this.nodes = new Vector();
      this.changes = this.rootNode.changes();
    }
    if (paramInt < this.nodes.size())
      return (Node)this.nodes.elementAt(paramInt);
    Object localObject;
    if (this.nodes.size() == 0)
      localObject = this.rootNode;
    else
      localObject = (NodeImpl)this.nodes.lastElement();
    while ((localObject != null) && (paramInt >= this.nodes.size()))
    {
      localObject = nextMatchingElementAfter((Node)localObject);
      if (localObject == null)
        continue;
      this.nodes.addElement(localObject);
    }
    return (Node)localObject;
  }

  protected Node nextMatchingElementAfter(Node paramNode)
  {
    while (paramNode != null)
    {
      if (paramNode.hasChildNodes())
      {
        paramNode = paramNode.getFirstChild();
      }
      else
      {
        Node localNode;
        if ((paramNode != this.rootNode) && (null != (localNode = paramNode.getNextSibling())))
        {
          paramNode = localNode;
        }
        else
        {
          localNode = null;
          while (paramNode != this.rootNode)
          {
            localNode = paramNode.getNextSibling();
            if (localNode != null)
              break;
            paramNode = paramNode.getParentNode();
          }
          paramNode = localNode;
        }
      }
      if ((paramNode == this.rootNode) || (paramNode == null) || (paramNode.getNodeType() != 1))
        continue;
      if (!this.enableNS)
      {
        if ((this.tagName.equals("*")) || (((ElementImpl)paramNode).getTagName().equals(this.tagName)))
          return paramNode;
      }
      else
      {
        ElementImpl localElementImpl;
        if (this.tagName.equals("*"))
        {
          if ((this.nsName != null) && (this.nsName.equals("*")))
            return paramNode;
          localElementImpl = (ElementImpl)paramNode;
          if (((this.nsName == null) && (localElementImpl.getNamespaceURI() == null)) || ((this.nsName != null) && (this.nsName.equals(localElementImpl.getNamespaceURI()))))
            return paramNode;
        }
        else
        {
          localElementImpl = (ElementImpl)paramNode;
          if ((localElementImpl.getLocalName() == null) || (!localElementImpl.getLocalName().equals(this.tagName)))
            continue;
          if ((this.nsName != null) && (this.nsName.equals("*")))
            return paramNode;
          if (((this.nsName == null) && (localElementImpl.getNamespaceURI() == null)) || ((this.nsName != null) && (this.nsName.equals(localElementImpl.getNamespaceURI()))))
            return paramNode;
        }
      }
    }
    return null;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.xerces.dom.DeepNodeListImpl
 * JD-Core Version:    0.6.0
 */