/*     */ package org.apache.commons.logging.impl;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.logging.Level;
/*     */ import java.util.logging.Logger;
/*     */ import org.apache.commons.logging.Log;
/*     */ 
/*     */ public class Jdk14Logger
/*     */   implements Log, Serializable
/*     */ {
/*  47 */   protected static final Level dummyLevel = Level.FINE;
/*     */ 
/*  71 */   protected transient Logger logger = null;
/*     */ 
/*  77 */   protected String name = null;
/*     */ 
/*     */   public Jdk14Logger(String name)
/*     */   {
/*  59 */     this.name = name;
/*  60 */     this.logger = getLogger();
/*     */   }
/*     */ 
/*     */   private void log(Level level, String msg, Throwable ex)
/*     */   {
/*  84 */     Logger logger = getLogger();
/*  85 */     if (logger.isLoggable(level))
/*     */     {
/*  87 */       Throwable dummyException = new Throwable();
/*  88 */       StackTraceElement[] locations = dummyException.getStackTrace();
/*     */ 
/*  90 */       String cname = "unknown";
/*  91 */       String method = "unknown";
/*  92 */       if ((locations != null) && (locations.length > 2)) {
/*  93 */         StackTraceElement caller = locations[2];
/*  94 */         cname = caller.getClassName();
/*  95 */         method = caller.getMethodName();
/*     */       }
/*  97 */       if (ex == null)
/*  98 */         logger.logp(level, cname, method, msg);
/*     */       else
/* 100 */         logger.logp(level, cname, method, msg, ex);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void debug(Object message)
/*     */   {
/* 113 */     log(Level.FINE, String.valueOf(message), null);
/*     */   }
/*     */ 
/*     */   public void debug(Object message, Throwable exception)
/*     */   {
/* 125 */     log(Level.FINE, String.valueOf(message), exception);
/*     */   }
/*     */ 
/*     */   public void error(Object message)
/*     */   {
/* 136 */     log(Level.SEVERE, String.valueOf(message), null);
/*     */   }
/*     */ 
/*     */   public void error(Object message, Throwable exception)
/*     */   {
/* 148 */     log(Level.SEVERE, String.valueOf(message), exception);
/*     */   }
/*     */ 
/*     */   public void fatal(Object message)
/*     */   {
/* 159 */     log(Level.SEVERE, String.valueOf(message), null);
/*     */   }
/*     */ 
/*     */   public void fatal(Object message, Throwable exception)
/*     */   {
/* 171 */     log(Level.SEVERE, String.valueOf(message), exception);
/*     */   }
/*     */ 
/*     */   public Logger getLogger()
/*     */   {
/* 179 */     if (this.logger == null) {
/* 180 */       this.logger = Logger.getLogger(this.name);
/*     */     }
/* 182 */     return this.logger;
/*     */   }
/*     */ 
/*     */   public void info(Object message)
/*     */   {
/* 193 */     log(Level.INFO, String.valueOf(message), null);
/*     */   }
/*     */ 
/*     */   public void info(Object message, Throwable exception)
/*     */   {
/* 205 */     log(Level.INFO, String.valueOf(message), exception);
/*     */   }
/*     */ 
/*     */   public boolean isDebugEnabled()
/*     */   {
/* 213 */     return getLogger().isLoggable(Level.FINE);
/*     */   }
/*     */ 
/*     */   public boolean isErrorEnabled()
/*     */   {
/* 221 */     return getLogger().isLoggable(Level.SEVERE);
/*     */   }
/*     */ 
/*     */   public boolean isFatalEnabled()
/*     */   {
/* 229 */     return getLogger().isLoggable(Level.SEVERE);
/*     */   }
/*     */ 
/*     */   public boolean isInfoEnabled()
/*     */   {
/* 237 */     return getLogger().isLoggable(Level.INFO);
/*     */   }
/*     */ 
/*     */   public boolean isTraceEnabled()
/*     */   {
/* 245 */     return getLogger().isLoggable(Level.FINEST);
/*     */   }
/*     */ 
/*     */   public boolean isWarnEnabled()
/*     */   {
/* 253 */     return getLogger().isLoggable(Level.WARNING);
/*     */   }
/*     */ 
/*     */   public void trace(Object message)
/*     */   {
/* 264 */     log(Level.FINEST, String.valueOf(message), null);
/*     */   }
/*     */ 
/*     */   public void trace(Object message, Throwable exception)
/*     */   {
/* 276 */     log(Level.FINEST, String.valueOf(message), exception);
/*     */   }
/*     */ 
/*     */   public void warn(Object message)
/*     */   {
/* 287 */     log(Level.WARNING, String.valueOf(message), null);
/*     */   }
/*     */ 
/*     */   public void warn(Object message, Throwable exception)
/*     */   {
/* 299 */     log(Level.WARNING, String.valueOf(message), exception);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.logging.impl.Jdk14Logger
 * JD-Core Version:    0.6.0
 */