/*     */ package org.apache.commons.collections.map;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ 
/*     */ public class IdentityMap extends AbstractHashedMap
/*     */   implements Serializable, Cloneable
/*     */ {
/*     */   private static final long serialVersionUID = 2028493495224302329L;
/*     */ 
/*     */   public IdentityMap()
/*     */   {
/*  47 */     super(16, 0.75F, 12);
/*     */   }
/*     */ 
/*     */   public IdentityMap(int initialCapacity)
/*     */   {
/*  57 */     super(initialCapacity);
/*     */   }
/*     */ 
/*     */   public IdentityMap(int initialCapacity, float loadFactor)
/*     */   {
/*  70 */     super(initialCapacity, loadFactor);
/*     */   }
/*     */ 
/*     */   public IdentityMap(Map map)
/*     */   {
/*  80 */     super(map);
/*     */   }
/*     */ 
/*     */   protected int hash(Object key)
/*     */   {
/*  92 */     return System.identityHashCode(key);
/*     */   }
/*     */ 
/*     */   protected boolean isEqualKey(Object key1, Object key2)
/*     */   {
/* 104 */     return key1 == key2;
/*     */   }
/*     */ 
/*     */   protected boolean isEqualValue(Object value1, Object value2)
/*     */   {
/* 116 */     return value1 == value2;
/*     */   }
/*     */ 
/*     */   protected AbstractHashedMap.HashEntry createEntry(AbstractHashedMap.HashEntry next, int hashCode, Object key, Object value)
/*     */   {
/* 130 */     return new IdentityEntry(next, hashCode, key, value);
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/* 169 */     return super.clone();
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream out)
/*     */     throws IOException
/*     */   {
/* 176 */     out.defaultWriteObject();
/* 177 */     doWriteObject(out);
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 184 */     in.defaultReadObject();
/* 185 */     doReadObject(in);
/*     */   }
/*     */ 
/*     */   protected static class IdentityEntry extends AbstractHashedMap.HashEntry
/*     */   {
/*     */     protected IdentityEntry(AbstractHashedMap.HashEntry next, int hashCode, Object key, Object value)
/*     */     {
/* 140 */       super(hashCode, key, value);
/*     */     }
/*     */ 
/*     */     public boolean equals(Object obj) {
/* 144 */       if (obj == this) {
/* 145 */         return true;
/*     */       }
/* 147 */       if (!(obj instanceof Map.Entry)) {
/* 148 */         return false;
/*     */       }
/* 150 */       Map.Entry other = (Map.Entry)obj;
/* 151 */       return (getKey() == other.getKey()) && (getValue() == other.getValue());
/*     */     }
/*     */ 
/*     */     public int hashCode()
/*     */     {
/* 157 */       return System.identityHashCode(getKey()) ^ System.identityHashCode(getValue());
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.collections.map.IdentityMap
 * JD-Core Version:    0.6.0
 */