/*     */ package org.apache.commons.collections.functors;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import org.apache.commons.collections.Factory;
/*     */ import org.apache.commons.collections.FunctorException;
/*     */ 
/*     */ public class InstantiateFactory
/*     */   implements Factory, Serializable
/*     */ {
/*     */   static final long serialVersionUID = -7732226881069447957L;
/*     */   private final Class iClassToInstantiate;
/*     */   private final Class[] iParamTypes;
/*     */   private final Object[] iArgs;
/*  45 */   private transient Constructor iConstructor = null;
/*     */ 
/*     */   public static Factory getInstance(Class classToInstantiate, Class[] paramTypes, Object[] args)
/*     */   {
/*  56 */     if (classToInstantiate == null) {
/*  57 */       throw new IllegalArgumentException("Class to instantiate must not be null");
/*     */     }
/*  59 */     if (((paramTypes == null) && (args != null)) || ((paramTypes != null) && (args == null)) || ((paramTypes != null) && (args != null) && (paramTypes.length != args.length)))
/*     */     {
/*  62 */       throw new IllegalArgumentException("Parameter types must match the arguments");
/*     */     }
/*     */ 
/*  65 */     if ((paramTypes == null) || (paramTypes.length == 0)) {
/*  66 */       return new InstantiateFactory(classToInstantiate);
/*     */     }
/*  68 */     paramTypes = (Class[])paramTypes.clone();
/*  69 */     args = (Object[])args.clone();
/*  70 */     return new InstantiateFactory(classToInstantiate, paramTypes, args);
/*     */   }
/*     */ 
/*     */   public InstantiateFactory(Class classToInstantiate)
/*     */   {
/*  82 */     this.iClassToInstantiate = classToInstantiate;
/*  83 */     this.iParamTypes = null;
/*  84 */     this.iArgs = null;
/*  85 */     findConstructor();
/*     */   }
/*     */ 
/*     */   public InstantiateFactory(Class classToInstantiate, Class[] paramTypes, Object[] args)
/*     */   {
/*  98 */     this.iClassToInstantiate = classToInstantiate;
/*  99 */     this.iParamTypes = paramTypes;
/* 100 */     this.iArgs = args;
/* 101 */     findConstructor();
/*     */   }
/*     */ 
/*     */   private void findConstructor()
/*     */   {
/*     */     try
/*     */     {
/* 109 */       this.iConstructor = this.iClassToInstantiate.getConstructor(this.iParamTypes);
/*     */     }
/*     */     catch (NoSuchMethodException ex) {
/* 112 */       throw new IllegalArgumentException("InstantiateFactory: The constructor must exist and be public ");
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object create()
/*     */   {
/* 123 */     if (this.iConstructor == null) {
/* 124 */       findConstructor();
/*     */     }
/*     */     try
/*     */     {
/* 128 */       return this.iConstructor.newInstance(this.iArgs);
/*     */     }
/*     */     catch (InstantiationException ex) {
/* 131 */       throw new FunctorException("InstantiateFactory: InstantiationException", ex);
/*     */     } catch (IllegalAccessException ex) {
/* 133 */       throw new FunctorException("InstantiateFactory: Constructor must be public", ex); } catch (InvocationTargetException ex) {
/*     */     }
/* 135 */     throw new FunctorException("InstantiateFactory: Constructor threw an exception", ex);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.collections.functors.InstantiateFactory
 * JD-Core Version:    0.6.0
 */