/*    */ package org.apache.commons.collections.functors;
/*    */ 
/*    */ import java.io.Serializable;
/*    */ import org.apache.commons.collections.Predicate;
/*    */ 
/*    */ public final class InstanceofPredicate
/*    */   implements Predicate, Serializable
/*    */ {
/*    */   static final long serialVersionUID = -6682656911025165584L;
/*    */   private final Class iType;
/*    */ 
/*    */   public static Predicate getInstance(Class type)
/*    */   {
/* 47 */     if (type == null) {
/* 48 */       throw new IllegalArgumentException("The type to check instanceof must not be null");
/*    */     }
/* 50 */     return new InstanceofPredicate(type);
/*    */   }
/*    */ 
/*    */   public InstanceofPredicate(Class type)
/*    */   {
/* 61 */     this.iType = type;
/*    */   }
/*    */ 
/*    */   public boolean evaluate(Object object)
/*    */   {
/* 71 */     return this.iType.isInstance(object);
/*    */   }
/*    */ 
/*    */   public Class getType()
/*    */   {
/* 81 */     return this.iType;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.collections.functors.InstanceofPredicate
 * JD-Core Version:    0.6.0
 */