/*     */ package org.apache.commons.collections.bag;
/*     */ 
/*     */ import java.util.Set;
/*     */ import org.apache.commons.collections.Bag;
/*     */ import org.apache.commons.collections.collection.SynchronizedCollection;
/*     */ import org.apache.commons.collections.set.SynchronizedSet;
/*     */ 
/*     */ public class SynchronizedBag extends SynchronizedCollection
/*     */   implements Bag
/*     */ {
/*     */   private static final long serialVersionUID = 8084674570753837109L;
/*     */ 
/*     */   public static Bag decorate(Bag bag)
/*     */   {
/*  52 */     return new SynchronizedBag(bag);
/*     */   }
/*     */ 
/*     */   protected SynchronizedBag(Bag bag)
/*     */   {
/*  63 */     super(bag);
/*     */   }
/*     */ 
/*     */   protected SynchronizedBag(Bag bag, Object lock)
/*     */   {
/*  74 */     super(bag, lock);
/*     */   }
/*     */ 
/*     */   protected Bag getBag()
/*     */   {
/*  83 */     return (Bag)this.collection;
/*     */   }
/*     */ 
/*     */   public boolean add(Object object, int count)
/*     */   {
/*  88 */     synchronized (this.lock) {
/*  89 */       return getBag().add(object, count);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean remove(Object object, int count) {
/*  94 */     synchronized (this.lock) {
/*  95 */       return getBag().remove(object, count);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Set uniqueSet() {
/* 100 */     synchronized (this.lock) {
/* 101 */       Set set = getBag().uniqueSet();
/* 102 */       return new SynchronizedBagSet(set, this.lock);
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getCount(Object object) {
/* 107 */     synchronized (this.lock) {
/* 108 */       return getBag().getCount(object);
/*     */     }
/*     */   }
/*     */ 
/*     */   class SynchronizedBagSet extends SynchronizedSet
/*     */   {
/*     */     SynchronizedBagSet(Set set, Object lock)
/*     */     {
/* 123 */       super(lock);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.collections.bag.SynchronizedBag
 * JD-Core Version:    0.6.0
 */