/*      */ package org.apache.commons.collections;
/*      */ 
/*      */ import java.util.Collection;
/*      */ import java.util.ConcurrentModificationException;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.ListIterator;
/*      */ 
/*      */ class CursorableSubList extends CursorableLinkedList
/*      */   implements List
/*      */ {
/* 1455 */   protected CursorableLinkedList _list = null;
/*      */ 
/* 1458 */   protected CursorableLinkedList.Listable _pre = null;
/*      */ 
/* 1461 */   protected CursorableLinkedList.Listable _post = null;
/*      */ 
/*      */   CursorableSubList(CursorableLinkedList list, int from, int to)
/*      */   {
/* 1202 */     if ((0 > from) || (list.size() < to))
/* 1203 */       throw new IndexOutOfBoundsException();
/* 1204 */     if (from > to) {
/* 1205 */       throw new IllegalArgumentException();
/*      */     }
/* 1207 */     this._list = list;
/* 1208 */     if (from < list.size()) {
/* 1209 */       this._head.setNext(this._list.getListableAt(from));
/* 1210 */       this._pre = (null == this._head.next() ? null : this._head.next().prev());
/*      */     } else {
/* 1212 */       this._pre = this._list.getListableAt(from - 1);
/*      */     }
/* 1214 */     if (from == to) {
/* 1215 */       this._head.setNext(null);
/* 1216 */       this._head.setPrev(null);
/* 1217 */       if (to < list.size())
/* 1218 */         this._post = this._list.getListableAt(to);
/*      */       else
/* 1220 */         this._post = null;
/*      */     }
/*      */     else {
/* 1223 */       this._head.setPrev(this._list.getListableAt(to - 1));
/* 1224 */       this._post = this._head.prev().next();
/*      */     }
/* 1226 */     this._size = (to - from);
/* 1227 */     this._modCount = this._list._modCount;
/*      */   }
/*      */ 
/*      */   public void clear()
/*      */   {
/* 1233 */     checkForComod();
/* 1234 */     Iterator it = iterator();
/* 1235 */     while (it.hasNext()) {
/* 1236 */       it.next();
/* 1237 */       it.remove();
/*      */     }
/*      */   }
/*      */ 
/*      */   public Iterator iterator() {
/* 1242 */     checkForComod();
/* 1243 */     return super.iterator();
/*      */   }
/*      */ 
/*      */   public int size() {
/* 1247 */     checkForComod();
/* 1248 */     return super.size();
/*      */   }
/*      */ 
/*      */   public boolean isEmpty() {
/* 1252 */     checkForComod();
/* 1253 */     return super.isEmpty();
/*      */   }
/*      */ 
/*      */   public Object[] toArray() {
/* 1257 */     checkForComod();
/* 1258 */     return super.toArray();
/*      */   }
/*      */ 
/*      */   public Object[] toArray(Object[] a) {
/* 1262 */     checkForComod();
/* 1263 */     return super.toArray(a);
/*      */   }
/*      */ 
/*      */   public boolean contains(Object o) {
/* 1267 */     checkForComod();
/* 1268 */     return super.contains(o);
/*      */   }
/*      */ 
/*      */   public boolean remove(Object o) {
/* 1272 */     checkForComod();
/* 1273 */     return super.remove(o);
/*      */   }
/*      */ 
/*      */   public Object removeFirst() {
/* 1277 */     checkForComod();
/* 1278 */     return super.removeFirst();
/*      */   }
/*      */ 
/*      */   public Object removeLast() {
/* 1282 */     checkForComod();
/* 1283 */     return super.removeLast();
/*      */   }
/*      */ 
/*      */   public boolean addAll(Collection c) {
/* 1287 */     checkForComod();
/* 1288 */     return super.addAll(c);
/*      */   }
/*      */ 
/*      */   public boolean add(Object o) {
/* 1292 */     checkForComod();
/* 1293 */     return super.add(o);
/*      */   }
/*      */ 
/*      */   public boolean addFirst(Object o) {
/* 1297 */     checkForComod();
/* 1298 */     return super.addFirst(o);
/*      */   }
/*      */ 
/*      */   public boolean addLast(Object o) {
/* 1302 */     checkForComod();
/* 1303 */     return super.addLast(o);
/*      */   }
/*      */ 
/*      */   public boolean removeAll(Collection c) {
/* 1307 */     checkForComod();
/* 1308 */     return super.removeAll(c);
/*      */   }
/*      */ 
/*      */   public boolean containsAll(Collection c) {
/* 1312 */     checkForComod();
/* 1313 */     return super.containsAll(c);
/*      */   }
/*      */ 
/*      */   public boolean addAll(int index, Collection c) {
/* 1317 */     checkForComod();
/* 1318 */     return super.addAll(index, c);
/*      */   }
/*      */ 
/*      */   public int hashCode() {
/* 1322 */     checkForComod();
/* 1323 */     return super.hashCode();
/*      */   }
/*      */ 
/*      */   public boolean retainAll(Collection c) {
/* 1327 */     checkForComod();
/* 1328 */     return super.retainAll(c);
/*      */   }
/*      */ 
/*      */   public Object set(int index, Object element) {
/* 1332 */     checkForComod();
/* 1333 */     return super.set(index, element);
/*      */   }
/*      */ 
/*      */   public boolean equals(Object o) {
/* 1337 */     checkForComod();
/* 1338 */     return super.equals(o);
/*      */   }
/*      */ 
/*      */   public Object get(int index) {
/* 1342 */     checkForComod();
/* 1343 */     return super.get(index);
/*      */   }
/*      */ 
/*      */   public Object getFirst() {
/* 1347 */     checkForComod();
/* 1348 */     return super.getFirst();
/*      */   }
/*      */ 
/*      */   public Object getLast() {
/* 1352 */     checkForComod();
/* 1353 */     return super.getLast();
/*      */   }
/*      */ 
/*      */   public void add(int index, Object element) {
/* 1357 */     checkForComod();
/* 1358 */     super.add(index, element);
/*      */   }
/*      */ 
/*      */   public ListIterator listIterator(int index) {
/* 1362 */     checkForComod();
/* 1363 */     return super.listIterator(index);
/*      */   }
/*      */ 
/*      */   public Object remove(int index) {
/* 1367 */     checkForComod();
/* 1368 */     return super.remove(index);
/*      */   }
/*      */ 
/*      */   public int indexOf(Object o) {
/* 1372 */     checkForComod();
/* 1373 */     return super.indexOf(o);
/*      */   }
/*      */ 
/*      */   public int lastIndexOf(Object o) {
/* 1377 */     checkForComod();
/* 1378 */     return super.lastIndexOf(o);
/*      */   }
/*      */ 
/*      */   public ListIterator listIterator() {
/* 1382 */     checkForComod();
/* 1383 */     return super.listIterator();
/*      */   }
/*      */ 
/*      */   public List subList(int fromIndex, int toIndex) {
/* 1387 */     checkForComod();
/* 1388 */     return super.subList(fromIndex, toIndex);
/*      */   }
/*      */ 
/*      */   protected CursorableLinkedList.Listable insertListable(CursorableLinkedList.Listable before, CursorableLinkedList.Listable after, Object value)
/*      */   {
/* 1401 */     this._modCount += 1;
/* 1402 */     this._size += 1;
/* 1403 */     CursorableLinkedList.Listable elt = this._list.insertListable(null == before ? this._pre : before, null == after ? this._post : after, value);
/* 1404 */     if (null == this._head.next()) {
/* 1405 */       this._head.setNext(elt);
/* 1406 */       this._head.setPrev(elt);
/*      */     }
/* 1408 */     if (before == this._head.prev()) {
/* 1409 */       this._head.setPrev(elt);
/*      */     }
/* 1411 */     if (after == this._head.next()) {
/* 1412 */       this._head.setNext(elt);
/*      */     }
/* 1414 */     broadcastListableInserted(elt);
/* 1415 */     return elt;
/*      */   }
/*      */ 
/*      */   protected void removeListable(CursorableLinkedList.Listable elt)
/*      */   {
/* 1422 */     this._modCount += 1;
/* 1423 */     this._size -= 1;
/* 1424 */     if ((this._head.next() == elt) && (this._head.prev() == elt)) {
/* 1425 */       this._head.setNext(null);
/* 1426 */       this._head.setPrev(null);
/*      */     }
/* 1428 */     if (this._head.next() == elt) {
/* 1429 */       this._head.setNext(elt.next());
/*      */     }
/* 1431 */     if (this._head.prev() == elt) {
/* 1432 */       this._head.setPrev(elt.prev());
/*      */     }
/* 1434 */     this._list.removeListable(elt);
/* 1435 */     broadcastListableRemoved(elt);
/*      */   }
/*      */ 
/*      */   protected void checkForComod()
/*      */     throws ConcurrentModificationException
/*      */   {
/* 1447 */     if (this._modCount != this._list._modCount)
/* 1448 */       throw new ConcurrentModificationException();
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.collections.CursorableSubList
 * JD-Core Version:    0.6.0
 */