package javax.xml.transform;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

final class SecuritySupport
{
  static ClassLoader getContextClassLoader()
  {
    return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction()
    {
      public Object run()
      {
        ClassLoader localClassLoader = null;
        try
        {
          localClassLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException localSecurityException)
        {
        }
        return localClassLoader;
      }
    });
  }

  static String getSystemProperty(String paramString)
  {
    return (String)AccessController.doPrivileged(new PrivilegedAction(paramString)
    {
      private final String val$propName;

      public Object run()
      {
        return System.getProperty(this.val$propName);
      }
    });
  }

  static FileInputStream getFileInputStream(File paramFile)
    throws FileNotFoundException
  {
    try
    {
      return (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(paramFile)
      {
        private final File val$file;

        public Object run()
          throws FileNotFoundException
        {
          return new FileInputStream(this.val$file);
        }
      });
    }
    catch (PrivilegedActionException localPrivilegedActionException)
    {
    }
    throw ((FileNotFoundException)localPrivilegedActionException.getException());
  }

  static InputStream getResourceAsStream(ClassLoader paramClassLoader, String paramString)
  {
    return (InputStream)AccessController.doPrivileged(new PrivilegedAction(paramClassLoader, paramString)
    {
      private final ClassLoader val$cl;
      private final String val$name;

      public Object run()
      {
        InputStream localInputStream;
        if (this.val$cl == null)
          localInputStream = ClassLoader.getSystemResourceAsStream(this.val$name);
        else
          localInputStream = this.val$cl.getResourceAsStream(this.val$name);
        return localInputStream;
      }
    });
  }

  static boolean doesFileExist(File paramFile)
  {
    return ((Boolean)AccessController.doPrivileged(new PrivilegedAction(paramFile)
    {
      private final File val$f;

      public Object run()
      {
        return this.val$f.exists() ? Boolean.TRUE : Boolean.FALSE;
      }
    })).booleanValue();
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     javax.xml.transform.SecuritySupport
 * JD-Core Version:    0.6.0
 */