/*     */ package javax.activation;
/*     */ 
/*     */ import java.awt.datatransfer.DataFlavor;
/*     */ import java.awt.datatransfer.UnsupportedFlavorException;
/*     */ import java.io.IOException;
/*     */ import java.io.OutputStream;
/*     */ 
/*     */ class DataSourceDataContentHandler
/*     */   implements DataContentHandler
/*     */ {
/* 738 */   private DataSource ds = null;
/* 739 */   private DataFlavor[] transferFlavors = null;
/* 740 */   private DataContentHandler dch = null;
/*     */ 
/*     */   public DataSourceDataContentHandler(DataContentHandler dch, DataSource ds)
/*     */   {
/* 746 */     this.ds = ds;
/* 747 */     this.dch = dch;
/*     */   }
/*     */ 
/*     */   public DataFlavor[] getTransferDataFlavors()
/*     */   {
/* 756 */     if (this.transferFlavors == null) {
/* 757 */       if (this.dch != null) {
/* 758 */         this.transferFlavors = this.dch.getTransferDataFlavors();
/*     */       } else {
/* 760 */         this.transferFlavors = new DataFlavor[1];
/* 761 */         this.transferFlavors[0] = new ActivationDataFlavor(this.ds.getContentType(), this.ds.getContentType());
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 766 */     return this.transferFlavors;
/*     */   }
/*     */ 
/*     */   public Object getTransferData(DataFlavor df, DataSource ds)
/*     */     throws UnsupportedFlavorException, IOException
/*     */   {
/* 778 */     if (this.dch != null)
/* 779 */       return this.dch.getTransferData(df, ds);
/* 780 */     if (df.equals(getTransferDataFlavors()[0])) {
/* 781 */       return ds.getInputStream();
/*     */     }
/* 783 */     throw new UnsupportedFlavorException(df);
/*     */   }
/*     */ 
/*     */   public Object getContent(DataSource ds) throws IOException
/*     */   {
/* 788 */     if (this.dch != null) {
/* 789 */       return this.dch.getContent(ds);
/*     */     }
/* 791 */     return ds.getInputStream();
/*     */   }
/*     */ 
/*     */   public void writeTo(Object obj, String mimeType, OutputStream os)
/*     */     throws IOException
/*     */   {
/* 799 */     if (this.dch != null)
/* 800 */       this.dch.writeTo(obj, mimeType, os);
/*     */     else
/* 802 */       throw new UnsupportedDataTypeException("no DCH for content type " + this.ds.getContentType());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     javax.activation.DataSourceDataContentHandler
 * JD-Core Version:    0.6.0
 */