/*    */ package javassist.convert;
/*    */ 
/*    */ import javassist.CannotCompileException;
/*    */ import javassist.CtClass;
/*    */ import javassist.bytecode.BadBytecode;
/*    */ import javassist.bytecode.CodeAttribute;
/*    */ import javassist.bytecode.CodeIterator;
/*    */ import javassist.bytecode.ConstPool;
/*    */ import javassist.bytecode.MethodInfo;
/*    */ import javassist.bytecode.Opcode;
/*    */ 
/*    */ public abstract class Transformer
/*    */   implements Opcode
/*    */ {
/*    */   private Transformer next;
/*    */ 
/*    */   public Transformer(Transformer t)
/*    */   {
/* 37 */     this.next = t;
/*    */   }
/*    */   public Transformer getNext() {
/* 40 */     return this.next;
/*    */   }
/*    */   public void initialize(ConstPool cp, CodeAttribute attr) {
/*    */   }
/*    */   public void initialize(ConstPool cp, CtClass clazz, MethodInfo minfo) throws CannotCompileException {
/* 45 */     initialize(cp, minfo.getCodeAttribute());
/*    */   }
/*    */   public void clean() {
/*    */   }
/*    */   public abstract int transform(CtClass paramCtClass, int paramInt, CodeIterator paramCodeIterator, ConstPool paramConstPool) throws CannotCompileException, BadBytecode;
/*    */ 
/*    */   public int extraLocals() {
/* 53 */     return 0;
/*    */   }
/* 55 */   public int extraStack() { return 0;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     javassist.convert.Transformer
 * JD-Core Version:    0.6.0
 */