/*     */ package gnu.trove.decorator;
/*     */ 
/*     */ import gnu.trove.TLongHashSet;
/*     */ import gnu.trove.TLongIterator;
/*     */ import java.util.AbstractSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ 
/*     */ public class TLongHashSetDecorator extends AbstractSet
/*     */   implements Set
/*     */ {
/*     */   protected final TLongHashSet _set;
/*     */ 
/*     */   public TLongHashSetDecorator(TLongHashSet set)
/*     */   {
/*  54 */     this._set = set;
/*     */   }
/*     */ 
/*     */   public boolean add(Object value)
/*     */   {
/*  63 */     return this._set.add(unwrap(value));
/*     */   }
/*     */ 
/*     */   public boolean equals(Object other)
/*     */   {
/*  74 */     if (this._set.equals(other))
/*  75 */       return true;
/*  76 */     if ((other instanceof Set)) {
/*  77 */       Set that = (Set)other;
/*  78 */       if (that.size() != this._set.size()) {
/*  79 */         return false;
/*     */       }
/*  81 */       Iterator it = that.iterator();
/*  82 */       for (int i = that.size(); i-- > 0; ) {
/*  83 */         Object val = it.next();
/*  84 */         if ((val instanceof Long)) {
/*  85 */           long v = unwrap(val);
/*  86 */           if (!this._set.contains(v))
/*     */           {
/*  89 */             return false;
/*     */           }
/*     */         } else {
/*  92 */           return false;
/*     */         }
/*     */       }
/*  95 */       return true;
/*     */     }
/*     */ 
/*  98 */     return false;
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 106 */     this._set.clear();
/*     */   }
/*     */ 
/*     */   public boolean remove(Object value)
/*     */   {
/* 116 */     return this._set.remove(unwrap(value));
/*     */   }
/*     */ 
/*     */   public Iterator iterator()
/*     */   {
/* 125 */     return new Iterator() {
/* 126 */       private final TLongIterator it = TLongHashSetDecorator.this._set.iterator();
/*     */ 
/*     */       public Object next() {
/* 129 */         return TLongHashSetDecorator.this.wrap(this.it.next());
/*     */       }
/*     */ 
/*     */       public boolean hasNext() {
/* 133 */         return this.it.hasNext();
/*     */       }
/*     */ 
/*     */       public void remove() {
/* 137 */         this.it.remove();
/*     */       }
/*     */     };
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 147 */     return this._set.size();
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 155 */     return size() == 0;
/*     */   }
/*     */ 
/*     */   protected Long wrap(long k)
/*     */   {
/* 165 */     return new Long(k);
/*     */   }
/*     */ 
/*     */   protected long unwrap(Object value)
/*     */   {
/* 175 */     return ((Long)value).longValue();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     gnu.trove.decorator.TLongHashSetDecorator
 * JD-Core Version:    0.6.0
 */