/*    */ package gnu.trove;
/*    */ 
/*    */ import java.util.ConcurrentModificationException;
/*    */ import java.util.Iterator;
/*    */ 
/*    */ abstract class THashIterator extends TIterator
/*    */   implements Iterator
/*    */ {
/*    */   protected final TObjectHash _hash;
/*    */ 
/*    */   public THashIterator(TObjectHash hash)
/*    */   {
/* 53 */     super(hash);
/* 54 */     this._hash = hash;
/*    */   }
/*    */ 
/*    */   public Object next()
/*    */   {
/* 67 */     moveToNextIndex();
/* 68 */     return objectAtIndex(this._index);
/*    */   }
/*    */ 
/*    */   protected final int nextIndex()
/*    */   {
/* 81 */     if (this._expectedSize != this._hash.size()) {
/* 82 */       throw new ConcurrentModificationException();
/*    */     }
/*    */ 
/* 85 */     Object[] set = this._hash._set;
/* 86 */     int i = this._index;
/* 87 */     while ((i-- > 0) && ((set[i] == null) || (set[i] == TObjectHash.REMOVED)));
/* 88 */     return i;
/*    */   }
/*    */ 
/*    */   protected abstract Object objectAtIndex(int paramInt);
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     gnu.trove.THashIterator
 * JD-Core Version:    0.6.0
 */