/*     */ package com.sun.xml.txw2.output;
/*     */ 
/*     */ import java.io.Writer;
/*     */ import java.util.Stack;
/*     */ import org.xml.sax.Attributes;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ public class DataWriter extends XMLWriter
/*     */ {
/* 351 */   private static final Object SEEN_NOTHING = new Object();
/* 352 */   private static final Object SEEN_ELEMENT = new Object();
/* 353 */   private static final Object SEEN_DATA = new Object();
/*     */ 
/* 361 */   private Object state = SEEN_NOTHING;
/* 362 */   private Stack stateStack = new Stack();
/*     */ 
/* 364 */   private String indentStep = "";
/* 365 */   private int depth = 0;
/*     */ 
/*     */   public DataWriter(Writer writer, String encoding, CharacterEscapeHandler _escapeHandler)
/*     */   {
/* 114 */     super(writer, encoding, _escapeHandler);
/*     */   }
/*     */ 
/*     */   public DataWriter(Writer writer, String encoding)
/*     */   {
/* 119 */     this(writer, encoding, DumbEscapeHandler.theInstance);
/*     */   }
/*     */ 
/*     */   public DataWriter(Writer writer) {
/* 123 */     this(writer, null, DumbEscapeHandler.theInstance);
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public int getIndentStep()
/*     */   {
/* 149 */     return this.indentStep.length();
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public void setIndentStep(int indentStep)
/*     */   {
/* 165 */     StringBuilder s = new StringBuilder();
/* 166 */     for (; indentStep > 0; indentStep--) s.append(' ');
/* 167 */     setIndentStep(s.toString());
/*     */   }
/*     */ 
/*     */   public void setIndentStep(String s) {
/* 171 */     this.indentStep = s;
/*     */   }
/*     */ 
/*     */   public void reset()
/*     */   {
/* 191 */     this.depth = 0;
/* 192 */     this.state = SEEN_NOTHING;
/* 193 */     this.stateStack = new Stack();
/* 194 */     super.reset();
/*     */   }
/*     */ 
/*     */   public void startElement(String uri, String localName, String qName, Attributes atts)
/*     */     throws SAXException
/*     */   {
/* 221 */     this.stateStack.push(SEEN_ELEMENT);
/* 222 */     this.state = SEEN_NOTHING;
/* 223 */     if (this.depth > 0) {
/* 224 */       super.characters("\n");
/*     */     }
/* 226 */     doIndent();
/* 227 */     super.startElement(uri, localName, qName, atts);
/* 228 */     this.depth += 1;
/*     */   }
/*     */ 
/*     */   public void endElement(String uri, String localName, String qName)
/*     */     throws SAXException
/*     */   {
/* 253 */     this.depth -= 1;
/* 254 */     if (this.state == SEEN_ELEMENT) {
/* 255 */       super.characters("\n");
/* 256 */       doIndent();
/*     */     }
/* 258 */     super.endElement(uri, localName, qName);
/* 259 */     this.state = this.stateStack.pop();
/*     */   }
/*     */ 
/*     */   public void characters(char[] ch, int start, int length)
/*     */     throws SAXException
/*     */   {
/* 309 */     this.state = SEEN_DATA;
/* 310 */     super.characters(ch, start, length);
/*     */   }
/*     */ 
/*     */   public void comment(char[] ch, int start, int length) throws SAXException {
/* 314 */     if (this.depth > 0) {
/* 315 */       super.characters("\n");
/*     */     }
/* 317 */     doIndent();
/* 318 */     super.comment(ch, start, length);
/*     */   }
/*     */ 
/*     */   private void doIndent()
/*     */     throws SAXException
/*     */   {
/* 338 */     if (this.depth > 0) {
/* 339 */       char[] ch = this.indentStep.toCharArray();
/* 340 */       for (int i = 0; i < this.depth; i++)
/* 341 */         characters(ch, 0, ch.length);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.txw2.output.DataWriter
 * JD-Core Version:    0.6.0
 */