/*     */ package com.sun.xml.bind.v2.util;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.InputStreamReader;
/*     */ import java.io.Reader;
/*     */ import javax.activation.DataHandler;
/*     */ import javax.activation.DataSource;
/*     */ import javax.activation.MimeType;
/*     */ import javax.activation.MimeTypeParseException;
/*     */ import javax.xml.transform.stream.StreamSource;
/*     */ 
/*     */ public final class DataSourceSource extends StreamSource
/*     */ {
/*     */   private final DataSource source;
/*     */   private final String charset;
/*     */ 
/*     */   public DataSourceSource(DataHandler dh)
/*     */     throws MimeTypeParseException
/*     */   {
/*  74 */     this(dh.getDataSource());
/*     */   }
/*     */ 
/*     */   public DataSourceSource(DataSource source) throws MimeTypeParseException {
/*  78 */     this.source = source;
/*     */ 
/*  80 */     String ct = source.getContentType();
/*  81 */     if (ct == null) {
/*  82 */       this.charset = null;
/*     */     } else {
/*  84 */       MimeType mimeType = new MimeType(ct);
/*  85 */       this.charset = mimeType.getParameter("charset");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setReader(Reader reader)
/*     */   {
/*  91 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public void setInputStream(InputStream inputStream)
/*     */   {
/*  96 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public Reader getReader()
/*     */   {
/*     */     try {
/* 102 */       if (this.charset == null) return null;
/* 103 */       return new InputStreamReader(this.source.getInputStream(), this.charset);
/*     */     } catch (IOException e) {
/*     */     }
/* 106 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public InputStream getInputStream()
/*     */   {
/*     */     try
/*     */     {
/* 113 */       if (this.charset == null) return this.source.getInputStream();
/* 114 */       return null;
/*     */     } catch (IOException e) {
/*     */     }
/* 117 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public DataSource getDataSource()
/*     */   {
/* 122 */     return this.source;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.bind.v2.util.DataSourceSource
 * JD-Core Version:    0.6.0
 */