/*     */ package com.sun.xml.bind.v2.runtime.unmarshaller;
/*     */ 
/*     */ import com.sun.xml.bind.WhiteSpaceProcessor;
/*     */ import java.lang.reflect.Constructor;
/*     */ import javax.xml.stream.Location;
/*     */ import javax.xml.stream.XMLStreamException;
/*     */ import javax.xml.stream.XMLStreamReader;
/*     */ import org.xml.sax.Attributes;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ class StAXStreamConnector extends StAXConnector
/*     */ {
/*     */   private final XMLStreamReader staxStreamReader;
/* 169 */   protected final StringBuilder buffer = new StringBuilder();
/*     */ 
/* 175 */   protected boolean textReported = false;
/*     */ 
/* 281 */   private final Attributes attributes = new Attributes() {
/*     */     public int getLength() {
/* 283 */       return StAXStreamConnector.this.staxStreamReader.getAttributeCount();
/*     */     }
/*     */ 
/*     */     public String getURI(int index) {
/* 287 */       String uri = StAXStreamConnector.this.staxStreamReader.getAttributeNamespace(index);
/* 288 */       if (uri == null) return "";
/* 289 */       return uri;
/*     */     }
/*     */ 
/*     */     public String getLocalName(int index) {
/* 293 */       return StAXStreamConnector.this.staxStreamReader.getAttributeLocalName(index);
/*     */     }
/*     */ 
/*     */     public String getQName(int index) {
/* 297 */       String prefix = StAXStreamConnector.this.staxStreamReader.getAttributePrefix(index);
/* 298 */       if ((prefix == null) || (prefix.length() == 0)) {
/* 299 */         return getLocalName(index);
/*     */       }
/* 301 */       return prefix + ':' + getLocalName(index);
/*     */     }
/*     */ 
/*     */     public String getType(int index) {
/* 305 */       return StAXStreamConnector.this.staxStreamReader.getAttributeType(index);
/*     */     }
/*     */ 
/*     */     public String getValue(int index) {
/* 309 */       return StAXStreamConnector.this.staxStreamReader.getAttributeValue(index);
/*     */     }
/*     */ 
/*     */     public int getIndex(String uri, String localName) {
/* 313 */       for (int i = getLength() - 1; i >= 0; i--)
/* 314 */         if ((localName.equals(getLocalName(i))) && (uri.equals(getURI(i))))
/* 315 */           return i;
/* 316 */       return -1;
/*     */     }
/*     */ 
/*     */     public int getIndex(String qName)
/*     */     {
/* 322 */       for (int i = getLength() - 1; i >= 0; i--) {
/* 323 */         if (qName.equals(getQName(i)))
/* 324 */           return i;
/*     */       }
/* 326 */       return -1;
/*     */     }
/*     */ 
/*     */     public String getType(String uri, String localName) {
/* 330 */       int index = getIndex(uri, localName);
/* 331 */       if (index < 0) return null;
/* 332 */       return getType(index);
/*     */     }
/*     */ 
/*     */     public String getType(String qName) {
/* 336 */       int index = getIndex(qName);
/* 337 */       if (index < 0) return null;
/* 338 */       return getType(index);
/*     */     }
/*     */ 
/*     */     public String getValue(String uri, String localName) {
/* 342 */       int index = getIndex(uri, localName);
/* 343 */       if (index < 0) return null;
/* 344 */       return getValue(index);
/*     */     }
/*     */ 
/*     */     public String getValue(String qName) {
/* 348 */       int index = getIndex(qName);
/* 349 */       if (index < 0) return null;
/* 350 */       return getValue(index);
/*     */     }
/* 281 */   };
/*     */ 
/* 378 */   private static final Class FI_STAX_READER_CLASS = initFIStAXReaderClass();
/* 379 */   private static final Constructor<? extends StAXConnector> FI_CONNECTOR_CTOR = initFastInfosetConnectorClass();
/*     */ 
/* 413 */   private static final Class STAX_EX_READER_CLASS = initStAXExReader();
/* 414 */   private static final Constructor<? extends StAXConnector> STAX_EX_CONNECTOR_CTOR = initStAXExConnector();
/*     */ 
/*     */   public static StAXConnector create(XMLStreamReader reader, XmlVisitor visitor)
/*     */   {
/* 106 */     Class readerClass = reader.getClass();
/* 107 */     if ((FI_STAX_READER_CLASS != null) && (FI_STAX_READER_CLASS.isAssignableFrom(readerClass)) && (FI_CONNECTOR_CTOR != null)) {
/*     */       try {
/* 109 */         return (StAXConnector)FI_CONNECTOR_CTOR.newInstance(new Object[] { reader, visitor });
/*     */       }
/*     */       catch (Exception t)
/*     */       {
/*     */       }
/*     */     }
/* 115 */     boolean isZephyr = readerClass.getName().equals("com.sun.xml.stream.XMLReaderImpl");
/* 116 */     if (!isZephyr)
/*     */     {
/* 119 */       if (!checkImplementaionNameOfSjsxp(reader))
/*     */       {
/* 122 */         if ((!getBoolProp(reader, "org.codehaus.stax2.internNames")) || (!getBoolProp(reader, "org.codehaus.stax2.internNsUris")))
/*     */         {
/* 126 */           visitor = new InterningXmlVisitor(visitor);
/*     */         }
/*     */       }
/*     */     }
/* 128 */     if ((STAX_EX_READER_CLASS != null) && (STAX_EX_READER_CLASS.isAssignableFrom(readerClass)))
/*     */       try {
/* 130 */         return (StAXConnector)STAX_EX_CONNECTOR_CTOR.newInstance(new Object[] { reader, visitor });
/*     */       }
/*     */       catch (Exception t)
/*     */       {
/*     */       }
/* 135 */     return new StAXStreamConnector(reader, visitor);
/*     */   }
/*     */ 
/*     */   private static boolean checkImplementaionNameOfSjsxp(XMLStreamReader reader) {
/*     */     try {
/* 140 */       Object name = reader.getProperty("http://java.sun.com/xml/stream/properties/implementation-name");
/* 141 */       return (name != null) && (name.equals("sjsxp"));
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 145 */     return false;
/*     */   }
/*     */ 
/*     */   private static boolean getBoolProp(XMLStreamReader r, String n)
/*     */   {
/*     */     try {
/* 151 */       Object o = r.getProperty(n);
/* 152 */       if ((o instanceof Boolean)) return ((Boolean)o).booleanValue();
/* 153 */       return false;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 157 */     return false;
/*     */   }
/*     */ 
/*     */   protected StAXStreamConnector(XMLStreamReader staxStreamReader, XmlVisitor visitor)
/*     */   {
/* 178 */     super(visitor);
/* 179 */     this.staxStreamReader = staxStreamReader;
/*     */   }
/*     */ 
/*     */   public void bridge() throws XMLStreamException
/*     */   {
/*     */     try
/*     */     {
/* 186 */       int depth = 0;
/*     */ 
/* 189 */       int event = this.staxStreamReader.getEventType();
/* 190 */       if (event == 7)
/*     */       {
/* 192 */         while (!this.staxStreamReader.isStartElement()) {
/* 193 */           event = this.staxStreamReader.next();
/*     */         }
/*     */       }
/*     */ 
/* 197 */       if (event != 1) {
/* 198 */         throw new IllegalStateException("The current event is not START_ELEMENT\n but " + event);
/*     */       }
/* 200 */       handleStartDocument(this.staxStreamReader.getNamespaceContext());
/*     */       while (true)
/*     */       {
/* 207 */         switch (event) {
/*     */         case 1:
/* 209 */           handleStartElement();
/* 210 */           depth++;
/* 211 */           break;
/*     */         case 2:
/* 213 */           depth--;
/* 214 */           handleEndElement();
/* 215 */           if (depth != 0) break; break;
/*     */         case 4:
/*     */         case 6:
/*     */         case 12:
/* 220 */           handleCharacters();
/*     */         case 3:
/*     */         case 5:
/*     */         case 7:
/*     */         case 8:
/*     */         case 9:
/*     */         case 10:
/* 225 */         case 11: } event = this.staxStreamReader.next();
/*     */       }
/*     */ 
/* 228 */       this.staxStreamReader.next();
/*     */ 
/* 230 */       handleEndDocument();
/*     */     } catch (SAXException e) {
/* 232 */       throw new XMLStreamException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Location getCurrentLocation() {
/* 237 */     return this.staxStreamReader.getLocation();
/*     */   }
/*     */ 
/*     */   protected String getCurrentQName() {
/* 241 */     return getQName(this.staxStreamReader.getPrefix(), this.staxStreamReader.getLocalName());
/*     */   }
/*     */ 
/*     */   private void handleEndElement() throws SAXException {
/* 245 */     processText(false);
/*     */ 
/* 248 */     this.tagName.uri = fixNull(this.staxStreamReader.getNamespaceURI());
/* 249 */     this.tagName.local = this.staxStreamReader.getLocalName();
/* 250 */     this.visitor.endElement(this.tagName);
/*     */ 
/* 253 */     int nsCount = this.staxStreamReader.getNamespaceCount();
/* 254 */     for (int i = nsCount - 1; i >= 0; i--)
/* 255 */       this.visitor.endPrefixMapping(fixNull(this.staxStreamReader.getNamespacePrefix(i)));
/*     */   }
/*     */ 
/*     */   private void handleStartElement() throws SAXException
/*     */   {
/* 260 */     processText(true);
/*     */ 
/* 263 */     int nsCount = this.staxStreamReader.getNamespaceCount();
/* 264 */     for (int i = 0; i < nsCount; i++) {
/* 265 */       this.visitor.startPrefixMapping(fixNull(this.staxStreamReader.getNamespacePrefix(i)), fixNull(this.staxStreamReader.getNamespaceURI(i)));
/*     */     }
/*     */ 
/* 271 */     this.tagName.uri = fixNull(this.staxStreamReader.getNamespaceURI());
/* 272 */     this.tagName.local = this.staxStreamReader.getLocalName();
/* 273 */     this.tagName.atts = this.attributes;
/*     */ 
/* 275 */     this.visitor.startElement(this.tagName);
/*     */   }
/*     */ 
/*     */   protected void handleCharacters()
/*     */     throws XMLStreamException, SAXException
/*     */   {
/* 355 */     if (this.predictor.expectText())
/* 356 */       this.buffer.append(this.staxStreamReader.getTextCharacters(), this.staxStreamReader.getTextStart(), this.staxStreamReader.getTextLength());
/*     */   }
/*     */ 
/*     */   private void processText(boolean ignorable)
/*     */     throws SAXException
/*     */   {
/* 363 */     if ((this.predictor.expectText()) && ((!ignorable) || (!WhiteSpaceProcessor.isWhiteSpace(this.buffer)))) {
/* 364 */       if (this.textReported)
/* 365 */         this.textReported = false;
/*     */       else {
/* 367 */         this.visitor.text(this.buffer);
/*     */       }
/*     */     }
/* 370 */     this.buffer.setLength(0);
/*     */   }
/*     */ 
/*     */   private static Class initFIStAXReaderClass()
/*     */   {
/*     */     try
/*     */     {
/* 383 */       Class fisr = UnmarshallerImpl.class.getClassLoader().loadClass("org.jvnet.fastinfoset.stax.FastInfosetStreamReader");
/*     */ 
/* 385 */       Class sdp = UnmarshallerImpl.class.getClassLoader().loadClass("com.sun.xml.fastinfoset.stax.StAXDocumentParser");
/*     */ 
/* 388 */       if (fisr.isAssignableFrom(sdp)) {
/* 389 */         return sdp;
/*     */       }
/* 391 */       return null; } catch (Throwable e) {
/*     */     }
/* 393 */     return null;
/*     */   }
/*     */ 
/*     */   private static Constructor<? extends StAXConnector> initFastInfosetConnectorClass()
/*     */   {
/*     */     try {
/* 399 */       if (FI_STAX_READER_CLASS == null) {
/* 400 */         return null;
/*     */       }
/* 402 */       Class c = UnmarshallerImpl.class.getClassLoader().loadClass("com.sun.xml.bind.v2.runtime.unmarshaller.FastInfosetConnector");
/*     */ 
/* 404 */       return c.getConstructor(new Class[] { FI_STAX_READER_CLASS, XmlVisitor.class }); } catch (Throwable e) {
/*     */     }
/* 406 */     return null;
/*     */   }
/*     */ 
/*     */   private static Class initStAXExReader()
/*     */   {
/*     */     try
/*     */     {
/* 418 */       return UnmarshallerImpl.class.getClassLoader().loadClass("org.jvnet.staxex.XMLStreamReaderEx"); } catch (Throwable e) {
/*     */     }
/* 420 */     return null;
/*     */   }
/*     */ 
/*     */   private static Constructor<? extends StAXConnector> initStAXExConnector()
/*     */   {
/*     */     try {
/* 426 */       Class c = UnmarshallerImpl.class.getClassLoader().loadClass("com.sun.xml.bind.v2.runtime.unmarshaller.StAXExConnector");
/* 427 */       return c.getConstructor(new Class[] { STAX_EX_READER_CLASS, XmlVisitor.class }); } catch (Throwable e) {
/*     */     }
/* 429 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.bind.v2.runtime.unmarshaller.StAXStreamConnector
 * JD-Core Version:    0.6.0
 */