/*     */ package com.sun.xml.bind.v2.runtime.unmarshaller;
/*     */ 
/*     */ import com.sun.xml.bind.WhiteSpaceProcessor;
/*     */ import com.sun.xml.fastinfoset.stax.StAXDocumentParser;
/*     */ import javax.xml.stream.Location;
/*     */ import javax.xml.stream.XMLStreamException;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ final class FastInfosetConnector extends StAXConnector
/*     */ {
/*     */   private final StAXDocumentParser fastInfosetStreamReader;
/*     */   private boolean textReported;
/*  64 */   private final Base64Data base64Data = new Base64Data();
/*     */ 
/*  67 */   private final StringBuilder buffer = new StringBuilder();
/*     */ 
/* 248 */   private final CharSequenceImpl charArray = new CharSequenceImpl();
/*     */ 
/*     */   public FastInfosetConnector(StAXDocumentParser fastInfosetStreamReader, XmlVisitor visitor)
/*     */   {
/*  71 */     super(visitor);
/*  72 */     fastInfosetStreamReader.setStringInterning(true);
/*  73 */     this.fastInfosetStreamReader = fastInfosetStreamReader;
/*     */   }
/*     */ 
/*     */   public void bridge() throws XMLStreamException
/*     */   {
/*     */     try {
/*  79 */       int depth = 0;
/*     */ 
/*  82 */       int event = this.fastInfosetStreamReader.getEventType();
/*  83 */       if (event == 7)
/*     */       {
/*  85 */         while (!this.fastInfosetStreamReader.isStartElement()) {
/*  86 */           event = this.fastInfosetStreamReader.next();
/*     */         }
/*     */       }
/*     */ 
/*  90 */       if (event != 1) {
/*  91 */         throw new IllegalStateException("The current event is not START_ELEMENT\n but " + event);
/*     */       }
/*     */ 
/*  95 */       handleStartDocument(this.fastInfosetStreamReader.getNamespaceContext());
/*     */       while (true)
/*     */       {
/* 102 */         switch (event) {
/*     */         case 1:
/* 104 */           handleStartElement();
/* 105 */           depth++;
/* 106 */           break;
/*     */         case 2:
/* 108 */           depth--;
/* 109 */           handleEndElement();
/* 110 */           if (depth != 0) break; break;
/*     */         case 4:
/*     */         case 6:
/*     */         case 12:
/* 115 */           if (!this.predictor.expectText()) {
/*     */             break;
/*     */           }
/* 118 */           event = this.fastInfosetStreamReader.peekNext();
/* 119 */           if (event == 2)
/* 120 */             processNonIgnorableText();
/* 121 */           else if (event == 1)
/* 122 */             processIgnorableText();
/*     */           else
/* 124 */             handleFragmentedCharacters(); case 3:
/*     */         case 5:
/*     */         case 7:
/*     */         case 8:
/*     */         case 9:
/*     */         case 10:
/* 130 */         case 11: } event = this.fastInfosetStreamReader.next();
/*     */       }
/*     */ 
/* 133 */       this.fastInfosetStreamReader.next();
/*     */ 
/* 135 */       handleEndDocument();
/*     */     } catch (SAXException e) {
/* 137 */       throw new XMLStreamException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Location getCurrentLocation() {
/* 142 */     return this.fastInfosetStreamReader.getLocation();
/*     */   }
/*     */ 
/*     */   protected String getCurrentQName() {
/* 146 */     return this.fastInfosetStreamReader.getNameString();
/*     */   }
/*     */ 
/*     */   private void handleStartElement() throws SAXException {
/* 150 */     processUnreportedText();
/*     */ 
/* 152 */     for (int i = 0; i < this.fastInfosetStreamReader.accessNamespaceCount(); i++) {
/* 153 */       this.visitor.startPrefixMapping(this.fastInfosetStreamReader.getNamespacePrefix(i), this.fastInfosetStreamReader.getNamespaceURI(i));
/*     */     }
/*     */ 
/* 157 */     this.tagName.uri = this.fastInfosetStreamReader.accessNamespaceURI();
/* 158 */     this.tagName.local = this.fastInfosetStreamReader.accessLocalName();
/* 159 */     this.tagName.atts = this.fastInfosetStreamReader.getAttributesHolder();
/*     */ 
/* 161 */     this.visitor.startElement(this.tagName);
/*     */   }
/*     */ 
/*     */   private void handleFragmentedCharacters() throws XMLStreamException, SAXException {
/* 165 */     this.buffer.setLength(0);
/*     */ 
/* 168 */     this.buffer.append(this.fastInfosetStreamReader.accessTextCharacters(), this.fastInfosetStreamReader.accessTextStart(), this.fastInfosetStreamReader.accessTextLength());
/*     */     while (true)
/*     */     {
/* 174 */       switch (this.fastInfosetStreamReader.peekNext()) {
/*     */       case 1:
/* 176 */         processBufferedText(true);
/* 177 */         return;
/*     */       case 2:
/* 179 */         processBufferedText(false);
/* 180 */         return;
/*     */       case 4:
/*     */       case 6:
/*     */       case 12:
/* 185 */         this.fastInfosetStreamReader.next();
/* 186 */         this.buffer.append(this.fastInfosetStreamReader.accessTextCharacters(), this.fastInfosetStreamReader.accessTextStart(), this.fastInfosetStreamReader.accessTextLength());
/*     */ 
/* 189 */         break;
/*     */       case 3:
/*     */       case 5:
/*     */       case 7:
/*     */       case 8:
/*     */       case 9:
/*     */       case 10:
/*     */       case 11:
/*     */       default:
/* 191 */         this.fastInfosetStreamReader.next();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void handleEndElement() throws SAXException {
/* 197 */     processUnreportedText();
/*     */ 
/* 199 */     this.tagName.uri = this.fastInfosetStreamReader.accessNamespaceURI();
/* 200 */     this.tagName.local = this.fastInfosetStreamReader.accessLocalName();
/*     */ 
/* 202 */     this.visitor.endElement(this.tagName);
/*     */ 
/* 204 */     for (int i = this.fastInfosetStreamReader.accessNamespaceCount() - 1; i >= 0; i--)
/* 205 */       this.visitor.endPrefixMapping(this.fastInfosetStreamReader.getNamespacePrefix(i));
/*     */   }
/*     */ 
/*     */   private void processNonIgnorableText()
/*     */     throws SAXException
/*     */   {
/* 251 */     this.textReported = true;
/* 252 */     if (this.fastInfosetStreamReader.getTextAlgorithmBytes() == null) {
/* 253 */       this.charArray.set();
/* 254 */       this.visitor.text(this.charArray);
/*     */     } else {
/* 256 */       this.base64Data.set(this.fastInfosetStreamReader.getTextAlgorithmBytesClone(), null);
/* 257 */       this.visitor.text(this.base64Data);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void processIgnorableText() throws SAXException {
/* 262 */     if (this.fastInfosetStreamReader.getTextAlgorithmBytes() == null) {
/* 263 */       this.charArray.set();
/* 264 */       if (!WhiteSpaceProcessor.isWhiteSpace(this.charArray)) {
/* 265 */         this.visitor.text(this.charArray);
/* 266 */         this.textReported = true;
/*     */       }
/*     */     } else {
/* 269 */       this.base64Data.set(this.fastInfosetStreamReader.getTextAlgorithmBytesClone(), null);
/* 270 */       this.visitor.text(this.base64Data);
/* 271 */       this.textReported = true;
/*     */     }
/*     */   }
/*     */ 
/*     */   private void processBufferedText(boolean ignorable) throws SAXException {
/* 276 */     if ((!ignorable) || (!WhiteSpaceProcessor.isWhiteSpace(this.buffer))) {
/* 277 */       this.visitor.text(this.buffer);
/* 278 */       this.textReported = true;
/*     */     }
/*     */   }
/*     */ 
/*     */   private void processUnreportedText() throws SAXException {
/* 283 */     if ((!this.textReported) && (this.predictor.expectText())) {
/* 284 */       this.visitor.text("");
/*     */     }
/* 286 */     this.textReported = false;
/*     */   }
/*     */ 
/*     */   private final class CharSequenceImpl
/*     */     implements CharSequence
/*     */   {
/*     */     char[] ch;
/*     */     int start;
/*     */     int length;
/*     */ 
/*     */     CharSequenceImpl()
/*     */     {
/*     */     }
/*     */ 
/*     */     CharSequenceImpl(char[] ch, int start, int length)
/*     */     {
/* 218 */       this.ch = ch;
/* 219 */       this.start = start;
/* 220 */       this.length = length;
/*     */     }
/*     */ 
/*     */     public void set() {
/* 224 */       this.ch = FastInfosetConnector.this.fastInfosetStreamReader.accessTextCharacters();
/* 225 */       this.start = FastInfosetConnector.this.fastInfosetStreamReader.accessTextStart();
/* 226 */       this.length = FastInfosetConnector.this.fastInfosetStreamReader.accessTextLength();
/*     */     }
/*     */ 
/*     */     public final int length()
/*     */     {
/* 232 */       return this.length;
/*     */     }
/*     */ 
/*     */     public final char charAt(int index) {
/* 236 */       return this.ch[(this.start + index)];
/*     */     }
/*     */ 
/*     */     public final CharSequence subSequence(int start, int end) {
/* 240 */       return new CharSequenceImpl(FastInfosetConnector.this, this.ch, this.start + start, end - start);
/*     */     }
/*     */ 
/*     */     public String toString() {
/* 244 */       return new String(this.ch, this.start, this.length);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.bind.v2.runtime.unmarshaller.FastInfosetConnector
 * JD-Core Version:    0.6.0
 */