/*     */ package com.sun.xml.bind.v2.runtime;
/*     */ 
/*     */ import java.util.HashSet;
/*     */ import java.util.IdentityHashMap;
/*     */ import java.util.Map;
/*     */ import java.util.Set;
/*     */ 
/*     */ public final class AssociationMap<XmlNode>
/*     */ {
/*  75 */   private final Map<XmlNode, Entry<XmlNode>> byElement = new IdentityHashMap();
/*  76 */   private final Map<Object, Entry<XmlNode>> byPeer = new IdentityHashMap();
/*  77 */   private final Set<XmlNode> usedNodes = new HashSet();
/*     */ 
/*     */   public void addInner(XmlNode element, Object inner)
/*     */   {
/*  81 */     Entry e = (Entry)this.byElement.get(element);
/*  82 */     if (e != null) {
/*  83 */       if (e.inner != null)
/*  84 */         this.byPeer.remove(e.inner);
/*  85 */       Entry.access$002(e, inner);
/*     */     } else {
/*  87 */       e = new Entry();
/*  88 */       Entry.access$102(e, element);
/*  89 */       Entry.access$002(e, inner);
/*     */     }
/*     */ 
/*  92 */     this.byElement.put(element, e);
/*     */ 
/*  94 */     Entry old = (Entry)this.byPeer.put(inner, e);
/*  95 */     if (old != null) {
/*  96 */       if (old.outer != null)
/*  97 */         this.byPeer.remove(old.outer);
/*  98 */       if (old.element != null)
/*  99 */         this.byElement.remove(old.element);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void addOuter(XmlNode element, Object outer)
/*     */   {
/* 105 */     Entry e = (Entry)this.byElement.get(element);
/* 106 */     if (e != null) {
/* 107 */       if (e.outer != null)
/* 108 */         this.byPeer.remove(e.outer);
/* 109 */       Entry.access$202(e, outer);
/*     */     } else {
/* 111 */       e = new Entry();
/* 112 */       Entry.access$102(e, element);
/* 113 */       Entry.access$202(e, outer);
/*     */     }
/*     */ 
/* 116 */     this.byElement.put(element, e);
/*     */ 
/* 118 */     Entry old = (Entry)this.byPeer.put(outer, e);
/* 119 */     if (old != null) {
/* 120 */       Entry.access$202(old, null);
/*     */ 
/* 122 */       if (old.inner == null)
/*     */       {
/* 124 */         this.byElement.remove(old.element);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void addUsed(XmlNode n) {
/* 129 */     this.usedNodes.add(n);
/*     */   }
/*     */ 
/*     */   public Entry<XmlNode> byElement(Object e) {
/* 133 */     return (Entry)this.byElement.get(e);
/*     */   }
/*     */ 
/*     */   public Entry<XmlNode> byPeer(Object o) {
/* 137 */     return (Entry)this.byPeer.get(o);
/*     */   }
/*     */ 
/*     */   public Object getInnerPeer(XmlNode element) {
/* 141 */     Entry e = byElement(element);
/* 142 */     if (e == null) return null;
/* 143 */     return e.inner;
/*     */   }
/*     */ 
/*     */   public Object getOuterPeer(XmlNode element) {
/* 147 */     Entry e = byElement(element);
/* 148 */     if (e == null) return null;
/* 149 */     return e.outer;
/*     */   }
/*     */ 
/*     */   static final class Entry<XmlNode>
/*     */   {
/*     */     private XmlNode element;
/*     */     private Object inner;
/*     */     private Object outer;
/*     */ 
/*     */     public XmlNode element()
/*     */     {
/*  65 */       return this.element;
/*     */     }
/*     */     public Object inner() {
/*  68 */       return this.inner;
/*     */     }
/*     */     public Object outer() {
/*  71 */       return this.outer;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.bind.v2.runtime.AssociationMap
 * JD-Core Version:    0.6.0
 */