/*     */ package com.sun.xml.bind.v2;
/*     */ 
/*     */ import com.sun.xml.bind.Util;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Modifier;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashSet;
/*     */ import java.util.LinkedList;
/*     */ import java.util.Map;
/*     */ import java.util.Stack;
/*     */ import java.util.TreeSet;
/*     */ import java.util.WeakHashMap;
/*     */ import java.util.logging.Level;
/*     */ import java.util.logging.Logger;
/*     */ 
/*     */ public final class ClassFactory
/*     */ {
/*  66 */   private static final Class[] emptyClass = new Class[0];
/*  67 */   private static final Object[] emptyObject = new Object[0];
/*     */ 
/*  69 */   private static final Logger logger = Util.getClassLogger();
/*     */ 
/*  76 */   private static final ThreadLocal<Map<Class, Constructor>> tls = new ThreadLocal() {
/*     */     public Map<Class, Constructor> initialValue() {
/*  78 */       return new WeakHashMap();
/*     */     }
/*  76 */   };
/*     */ 
/* 214 */   public static final Class[] COLLECTION_IMPL_CLASSES = { ArrayList.class, LinkedList.class, HashSet.class, TreeSet.class, Stack.class };
/*     */ 
/*     */   public static <T> T create0(Class<T> clazz)
/*     */     throws IllegalAccessException, InvocationTargetException, InstantiationException
/*     */   {
/*  86 */     Map m = (Map)tls.get();
/*  87 */     Constructor cons = (Constructor)m.get(clazz);
/*  88 */     if (cons == null) {
/*     */       try {
/*  90 */         cons = clazz.getDeclaredConstructor(emptyClass);
/*     */       } catch (NoSuchMethodException e) {
/*  92 */         logger.log(Level.INFO, "No default constructor found on " + clazz, e);
/*     */         NoSuchMethodError exp;
/*     */         NoSuchMethodError exp;
/*  94 */         if ((clazz.getDeclaringClass() != null) && (!Modifier.isStatic(clazz.getModifiers())))
/*  95 */           exp = new NoSuchMethodError(Messages.NO_DEFAULT_CONSTRUCTOR_IN_INNER_CLASS.format(new Object[] { clazz.getName() }));
/*     */         else {
/*  97 */           exp = new NoSuchMethodError(e.getMessage());
/*     */         }
/*  99 */         exp.initCause(e);
/* 100 */         throw exp;
/*     */       }
/*     */ 
/* 103 */       int classMod = clazz.getModifiers();
/*     */ 
/* 105 */       if ((!Modifier.isPublic(classMod)) || (!Modifier.isPublic(cons.getModifiers()))) {
/*     */         try
/*     */         {
/* 108 */           cons.setAccessible(true);
/*     */         }
/*     */         catch (SecurityException e) {
/* 111 */           logger.log(Level.FINE, "Unable to make the constructor of " + clazz + " accessible", e);
/* 112 */           throw e;
/*     */         }
/*     */       }
/*     */ 
/* 116 */       m.put(clazz, cons);
/*     */     }
/*     */ 
/* 119 */     return cons.newInstance(emptyObject);
/*     */   }
/*     */ 
/*     */   public static <T> T create(Class<T> clazz)
/*     */   {
/*     */     Throwable target;
/*     */     try
/*     */     {
/* 128 */       return create0(clazz);
/*     */     } catch (InstantiationException e) {
/* 130 */       logger.log(Level.INFO, "failed to create a new instance of " + clazz, e);
/* 131 */       throw new InstantiationError(e.toString());
/*     */     } catch (IllegalAccessException e) {
/* 133 */       logger.log(Level.INFO, "failed to create a new instance of " + clazz, e);
/* 134 */       throw new IllegalAccessError(e.toString());
/*     */     } catch (InvocationTargetException e) {
/* 136 */       target = e.getTargetException();
/*     */ 
/* 140 */       if ((target instanceof RuntimeException)) {
/* 141 */         throw ((RuntimeException)target);
/*     */       }
/*     */ 
/* 144 */       if ((target instanceof Error)) {
/* 145 */         throw ((Error)target);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 150 */     throw new IllegalStateException(target);
/*     */   }
/*     */ 
/*     */   public static Object create(Method method)
/*     */   {
/*     */     Throwable errorMsg;
/*     */     try
/*     */     {
/* 160 */       return method.invoke(null, emptyObject);
/*     */     } catch (InvocationTargetException ive) {
/* 162 */       Throwable target = ive.getTargetException();
/*     */ 
/* 164 */       if ((target instanceof RuntimeException)) {
/* 165 */         throw ((RuntimeException)target);
/*     */       }
/* 167 */       if ((target instanceof Error)) {
/* 168 */         throw ((Error)target);
/*     */       }
/* 170 */       throw new IllegalStateException(target);
/*     */     } catch (IllegalAccessException e) {
/* 172 */       logger.log(Level.INFO, "failed to create a new instance of " + method.getReturnType().getName(), e);
/* 173 */       throw new IllegalAccessError(e.toString());
/*     */     } catch (IllegalArgumentException iae) {
/* 175 */       logger.log(Level.INFO, "failed to create a new instance of " + method.getReturnType().getName(), iae);
/* 176 */       errorMsg = iae;
/*     */     } catch (NullPointerException npe) {
/* 178 */       logger.log(Level.INFO, "failed to create a new instance of " + method.getReturnType().getName(), npe);
/* 179 */       errorMsg = npe;
/*     */     } catch (ExceptionInInitializerError eie) {
/* 181 */       logger.log(Level.INFO, "failed to create a new instance of " + method.getReturnType().getName(), eie);
/* 182 */       errorMsg = eie;
/*     */     }
/*     */ 
/* 186 */     NoSuchMethodError exp = new NoSuchMethodError(errorMsg.getMessage());
/* 187 */     exp.initCause(errorMsg);
/* 188 */     throw exp;
/*     */   }
/*     */ 
/*     */   public static <T> Class<? extends T> inferImplClass(Class<T> fieldType, Class[] knownImplClasses)
/*     */   {
/* 198 */     if (!fieldType.isInterface())
/*     */     {
/* 201 */       return fieldType;
/*     */     }
/* 203 */     for (Class impl : knownImplClasses) {
/* 204 */       if (fieldType.isAssignableFrom(impl)) {
/* 205 */         return impl.asSubclass(fieldType);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 211 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.bind.v2.ClassFactory
 * JD-Core Version:    0.6.0
 */