/*     */ package com.sun.xml.bind.marshaller;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.Writer;
/*     */ import java.util.Stack;
/*     */ import org.xml.sax.Attributes;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ public class DataWriter extends XMLWriter
/*     */ {
/* 370 */   private static final Object SEEN_NOTHING = new Object();
/* 371 */   private static final Object SEEN_ELEMENT = new Object();
/* 372 */   private static final Object SEEN_DATA = new Object();
/*     */ 
/* 380 */   private Object state = SEEN_NOTHING;
/* 381 */   private Stack<Object> stateStack = new Stack();
/*     */ 
/* 383 */   private String indentStep = "";
/* 384 */   private int depth = 0;
/*     */ 
/*     */   public DataWriter(Writer writer, String encoding, CharacterEscapeHandler _escapeHandler)
/*     */   {
/* 131 */     super(writer, encoding, _escapeHandler);
/*     */   }
/*     */ 
/*     */   public DataWriter(Writer writer, String encoding)
/*     */   {
/* 136 */     this(writer, encoding, DumbEscapeHandler.theInstance);
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public int getIndentStep()
/*     */   {
/* 162 */     return this.indentStep.length();
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public void setIndentStep(int indentStep)
/*     */   {
/* 178 */     StringBuilder buf = new StringBuilder();
/* 179 */     for (; indentStep > 0; indentStep--)
/* 180 */       buf.append(' ');
/* 181 */     setIndentStep(buf.toString());
/*     */   }
/*     */ 
/*     */   public void setIndentStep(String s) {
/* 185 */     this.indentStep = s;
/*     */   }
/*     */ 
/*     */   public void reset()
/*     */   {
/* 205 */     this.depth = 0;
/* 206 */     this.state = SEEN_NOTHING;
/* 207 */     this.stateStack = new Stack();
/* 208 */     super.reset();
/*     */   }
/*     */ 
/*     */   protected void writeXmlDecl(String decl) throws IOException {
/* 212 */     super.writeXmlDecl(decl);
/* 213 */     write('\n');
/*     */   }
/*     */ 
/*     */   public void startElement(String uri, String localName, String qName, Attributes atts)
/*     */     throws SAXException
/*     */   {
/* 240 */     this.stateStack.push(SEEN_ELEMENT);
/* 241 */     this.state = SEEN_NOTHING;
/* 242 */     if (this.depth > 0) {
/* 243 */       super.characters("\n");
/*     */     }
/* 245 */     doIndent();
/* 246 */     super.startElement(uri, localName, qName, atts);
/* 247 */     this.depth += 1;
/*     */   }
/*     */ 
/*     */   public void endElement(String uri, String localName, String qName)
/*     */     throws SAXException
/*     */   {
/* 272 */     this.depth -= 1;
/* 273 */     if (this.state == SEEN_ELEMENT) {
/* 274 */       super.characters("\n");
/* 275 */       doIndent();
/*     */     }
/* 277 */     super.endElement(uri, localName, qName);
/* 278 */     this.state = this.stateStack.pop();
/*     */   }
/*     */ 
/*     */   public void endDocument() throws SAXException {
/*     */     try {
/* 283 */       write('\n');
/*     */     } catch (IOException e) {
/* 285 */       throw new SAXException(e);
/*     */     }
/* 287 */     super.endDocument();
/*     */   }
/*     */ 
/*     */   public void characters(char[] ch, int start, int length)
/*     */     throws SAXException
/*     */   {
/* 336 */     this.state = SEEN_DATA;
/* 337 */     super.characters(ch, start, length);
/*     */   }
/*     */ 
/*     */   private void doIndent()
/*     */     throws SAXException
/*     */   {
/* 357 */     if (this.depth > 0) {
/* 358 */       char[] ch = this.indentStep.toCharArray();
/* 359 */       for (int i = 0; i < this.depth; i++)
/* 360 */         characters(ch, 0, ch.length);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.bind.marshaller.DataWriter
 * JD-Core Version:    0.6.0
 */