package antlr.debug.misc;

import antlr.ASTFactory;
import antlr.CommonAST;
import antlr.collections.AST;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintStream;
import javax.swing.JFrame;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class ASTFrame extends JFrame
{
  static final int WIDTH = 200;
  static final int HEIGHT = 300;

  public ASTFrame(String paramString, AST paramAST)
  {
    super(paramString);
    MyTreeSelectionListener localMyTreeSelectionListener = new MyTreeSelectionListener();
    JTreeASTPanel localJTreeASTPanel = new JTreeASTPanel(new JTreeASTModel(paramAST), null);
    Container localContainer = getContentPane();
    localContainer.add(localJTreeASTPanel, "Center");
    addWindowListener(new WindowAdapter()
    {
      public void windowClosing(WindowEvent paramWindowEvent)
      {
        Frame localFrame = (Frame)paramWindowEvent.getSource();
        localFrame.setVisible(false);
        localFrame.dispose();
      }
    });
    setSize(200, 300);
  }

  public static void main(String[] paramArrayOfString)
  {
    ASTFactory localASTFactory = new ASTFactory();
    CommonAST localCommonAST = (CommonAST)localASTFactory.create(0, "ROOT");
    localCommonAST.addChild((CommonAST)localASTFactory.create(0, "C1"));
    localCommonAST.addChild((CommonAST)localASTFactory.create(0, "C2"));
    localCommonAST.addChild((CommonAST)localASTFactory.create(0, "C3"));
    ASTFrame localASTFrame = new ASTFrame("AST JTree Example", localCommonAST);
    localASTFrame.setVisible(true);
  }

  class MyTreeSelectionListener
    implements TreeSelectionListener
  {
    MyTreeSelectionListener()
    {
    }

    public void valueChanged(TreeSelectionEvent paramTreeSelectionEvent)
    {
      TreePath localTreePath = paramTreeSelectionEvent.getPath();
      System.out.println("Selected: " + localTreePath.getLastPathComponent());
      Object[] arrayOfObject = localTreePath.getPath();
      for (int i = 0; i < arrayOfObject.length; i++)
        System.out.print("->" + arrayOfObject[i]);
      System.out.println();
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.debug.misc.ASTFrame
 * JD-Core Version:    0.6.0
 */