package antlr.debug;

import antlr.LLkParser;
import antlr.MismatchedTokenException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.Utils;
import antlr.collections.impl.BitSet;
import java.io.PrintStream;
import java.lang.reflect.Constructor;

public class LLkDebuggingParser extends LLkParser
  implements DebuggingParser
{
  protected ParserEventSupport parserEventSupport = new ParserEventSupport(this);
  private boolean _notDebugMode = false;
  protected String[] ruleNames;
  protected String[] semPredNames;

  public LLkDebuggingParser(int paramInt)
  {
    super(paramInt);
  }

  public LLkDebuggingParser(ParserSharedInputState paramParserSharedInputState, int paramInt)
  {
    super(paramParserSharedInputState, paramInt);
  }

  public LLkDebuggingParser(TokenBuffer paramTokenBuffer, int paramInt)
  {
    super(paramTokenBuffer, paramInt);
  }

  public LLkDebuggingParser(TokenStream paramTokenStream, int paramInt)
  {
    super(paramTokenStream, paramInt);
  }

  public void addMessageListener(MessageListener paramMessageListener)
  {
    this.parserEventSupport.addMessageListener(paramMessageListener);
  }

  public void addParserListener(ParserListener paramParserListener)
  {
    this.parserEventSupport.addParserListener(paramParserListener);
  }

  public void addParserMatchListener(ParserMatchListener paramParserMatchListener)
  {
    this.parserEventSupport.addParserMatchListener(paramParserMatchListener);
  }

  public void addParserTokenListener(ParserTokenListener paramParserTokenListener)
  {
    this.parserEventSupport.addParserTokenListener(paramParserTokenListener);
  }

  public void addSemanticPredicateListener(SemanticPredicateListener paramSemanticPredicateListener)
  {
    this.parserEventSupport.addSemanticPredicateListener(paramSemanticPredicateListener);
  }

  public void addSyntacticPredicateListener(SyntacticPredicateListener paramSyntacticPredicateListener)
  {
    this.parserEventSupport.addSyntacticPredicateListener(paramSyntacticPredicateListener);
  }

  public void addTraceListener(TraceListener paramTraceListener)
  {
    this.parserEventSupport.addTraceListener(paramTraceListener);
  }

  public void consume()
    throws TokenStreamException
  {
    int i = -99;
    i = LA(1);
    super.consume();
    this.parserEventSupport.fireConsume(i);
  }

  protected void fireEnterRule(int paramInt1, int paramInt2)
  {
    if (isDebugMode())
      this.parserEventSupport.fireEnterRule(paramInt1, this.inputState.guessing, paramInt2);
  }

  protected void fireExitRule(int paramInt1, int paramInt2)
  {
    if (isDebugMode())
      this.parserEventSupport.fireExitRule(paramInt1, this.inputState.guessing, paramInt2);
  }

  protected boolean fireSemanticPredicateEvaluated(int paramInt1, int paramInt2, boolean paramBoolean)
  {
    if (isDebugMode())
      return this.parserEventSupport.fireSemanticPredicateEvaluated(paramInt1, paramInt2, paramBoolean, this.inputState.guessing);
    return paramBoolean;
  }

  protected void fireSyntacticPredicateFailed()
  {
    if (isDebugMode())
      this.parserEventSupport.fireSyntacticPredicateFailed(this.inputState.guessing);
  }

  protected void fireSyntacticPredicateStarted()
  {
    if (isDebugMode())
      this.parserEventSupport.fireSyntacticPredicateStarted(this.inputState.guessing);
  }

  protected void fireSyntacticPredicateSucceeded()
  {
    if (isDebugMode())
      this.parserEventSupport.fireSyntacticPredicateSucceeded(this.inputState.guessing);
  }

  public String getRuleName(int paramInt)
  {
    return this.ruleNames[paramInt];
  }

  public String getSemPredName(int paramInt)
  {
    return this.semPredNames[paramInt];
  }

  public synchronized void goToSleep()
  {
    try
    {
      wait();
    }
    catch (InterruptedException localInterruptedException)
    {
    }
  }

  public boolean isDebugMode()
  {
    return !this._notDebugMode;
  }

  public boolean isGuessing()
  {
    return this.inputState.guessing > 0;
  }

  public int LA(int paramInt)
    throws TokenStreamException
  {
    int i = super.LA(paramInt);
    this.parserEventSupport.fireLA(paramInt, i);
    return i;
  }

  public void match(int paramInt)
    throws MismatchedTokenException, TokenStreamException
  {
    String str = LT(1).getText();
    int i = LA(1);
    try
    {
      super.match(paramInt);
      this.parserEventSupport.fireMatch(paramInt, str, this.inputState.guessing);
    }
    catch (MismatchedTokenException localMismatchedTokenException)
    {
      if (this.inputState.guessing == 0)
        this.parserEventSupport.fireMismatch(i, paramInt, str, this.inputState.guessing);
      throw localMismatchedTokenException;
    }
  }

  public void match(BitSet paramBitSet)
    throws MismatchedTokenException, TokenStreamException
  {
    String str = LT(1).getText();
    int i = LA(1);
    try
    {
      super.match(paramBitSet);
      this.parserEventSupport.fireMatch(i, paramBitSet, str, this.inputState.guessing);
    }
    catch (MismatchedTokenException localMismatchedTokenException)
    {
      if (this.inputState.guessing == 0)
        this.parserEventSupport.fireMismatch(i, paramBitSet, str, this.inputState.guessing);
      throw localMismatchedTokenException;
    }
  }

  public void matchNot(int paramInt)
    throws MismatchedTokenException, TokenStreamException
  {
    String str = LT(1).getText();
    int i = LA(1);
    try
    {
      super.matchNot(paramInt);
      this.parserEventSupport.fireMatchNot(i, paramInt, str, this.inputState.guessing);
    }
    catch (MismatchedTokenException localMismatchedTokenException)
    {
      if (this.inputState.guessing == 0)
        this.parserEventSupport.fireMismatchNot(i, paramInt, str, this.inputState.guessing);
      throw localMismatchedTokenException;
    }
  }

  public void removeMessageListener(MessageListener paramMessageListener)
  {
    this.parserEventSupport.removeMessageListener(paramMessageListener);
  }

  public void removeParserListener(ParserListener paramParserListener)
  {
    this.parserEventSupport.removeParserListener(paramParserListener);
  }

  public void removeParserMatchListener(ParserMatchListener paramParserMatchListener)
  {
    this.parserEventSupport.removeParserMatchListener(paramParserMatchListener);
  }

  public void removeParserTokenListener(ParserTokenListener paramParserTokenListener)
  {
    this.parserEventSupport.removeParserTokenListener(paramParserTokenListener);
  }

  public void removeSemanticPredicateListener(SemanticPredicateListener paramSemanticPredicateListener)
  {
    this.parserEventSupport.removeSemanticPredicateListener(paramSemanticPredicateListener);
  }

  public void removeSyntacticPredicateListener(SyntacticPredicateListener paramSyntacticPredicateListener)
  {
    this.parserEventSupport.removeSyntacticPredicateListener(paramSyntacticPredicateListener);
  }

  public void removeTraceListener(TraceListener paramTraceListener)
  {
    this.parserEventSupport.removeTraceListener(paramTraceListener);
  }

  public void reportError(RecognitionException paramRecognitionException)
  {
    this.parserEventSupport.fireReportError(paramRecognitionException);
    super.reportError(paramRecognitionException);
  }

  public void reportError(String paramString)
  {
    this.parserEventSupport.fireReportError(paramString);
    super.reportError(paramString);
  }

  public void reportWarning(String paramString)
  {
    this.parserEventSupport.fireReportWarning(paramString);
    super.reportWarning(paramString);
  }

  public void setDebugMode(boolean paramBoolean)
  {
    this._notDebugMode = (!paramBoolean);
  }

  public void setupDebugging(TokenBuffer paramTokenBuffer)
  {
    setupDebugging(null, paramTokenBuffer);
  }

  public void setupDebugging(TokenStream paramTokenStream)
  {
    setupDebugging(paramTokenStream, null);
  }

  protected void setupDebugging(TokenStream paramTokenStream, TokenBuffer paramTokenBuffer)
  {
    setDebugMode(true);
    try
    {
      try
      {
        Utils.loadClass("javax.swing.JButton");
      }
      catch (ClassNotFoundException localClassNotFoundException)
      {
        System.err.println("Swing is required to use ParseView, but is not present in your CLASSPATH");
        System.exit(1);
      }
      Class localClass = Utils.loadClass("antlr.parseview.ParseView");
      Constructor localConstructor = localClass.getConstructor(new Class[] { LLkDebuggingParser.class, TokenStream.class, TokenBuffer.class });
      localConstructor.newInstance(new Object[] { this, paramTokenStream, paramTokenBuffer });
    }
    catch (Exception localException)
    {
      System.err.println("Error initializing ParseView: " + localException);
      System.err.println("Please report this to Scott Stanchfield, thetick@magelang.com");
      System.exit(1);
    }
  }

  public synchronized void wakeUp()
  {
    notify();
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.debug.LLkDebuggingParser
 * JD-Core Version:    0.6.0
 */