package antlr;

abstract class GrammarAtom extends AlternativeElement
{
  protected String label;
  protected String atomText;
  protected int tokenType = 0;
  protected boolean not = false;
  protected String ASTNodeType = null;

  public GrammarAtom(Grammar paramGrammar, Token paramToken, int paramInt)
  {
    super(paramGrammar, paramToken, paramInt);
    this.atomText = paramToken.getText();
  }

  public String getLabel()
  {
    return this.label;
  }

  public String getText()
  {
    return this.atomText;
  }

  public int getType()
  {
    return this.tokenType;
  }

  public void setLabel(String paramString)
  {
    this.label = paramString;
  }

  public String getASTNodeType()
  {
    return this.ASTNodeType;
  }

  public void setASTNodeType(String paramString)
  {
    this.ASTNodeType = paramString;
  }

  public void setOption(Token paramToken1, Token paramToken2)
  {
    if (paramToken1.getText().equals("AST"))
      setASTNodeType(paramToken2.getText());
    else
      this.grammar.antlrTool.error("Invalid element option:" + paramToken1.getText(), this.grammar.getFilename(), paramToken1.getLine(), paramToken1.getColumn());
  }

  public String toString()
  {
    String str = " ";
    if (this.label != null)
      str = str + this.label + ":";
    if (this.not)
      str = str + "~";
    return str + this.atomText;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.GrammarAtom
 * JD-Core Version:    0.6.0
 */