package antlr;

import antlr.collections.impl.Vector;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class Grammar
{
  protected Tool antlrTool;
  protected CodeGenerator generator;
  protected LLkGrammarAnalyzer theLLkAnalyzer;
  protected Hashtable symbols;
  protected boolean buildAST = false;
  protected boolean analyzerDebug = false;
  protected boolean interactive = false;
  protected String superClass = null;
  protected TokenManager tokenManager;
  protected String exportVocab = null;
  protected String importVocab = null;
  protected Hashtable options;
  protected Vector rules;
  protected Token preambleAction = new CommonToken(0, "");
  protected String className = null;
  protected String fileName = null;
  protected Token classMemberAction = new CommonToken(0, "");
  protected boolean hasSyntacticPredicate = false;
  protected boolean hasUserErrorHandling = false;
  protected int maxk = 1;
  protected boolean traceRules = false;
  protected boolean debuggingOutput = false;
  protected boolean defaultErrorHandler = true;
  protected String comment = null;

  public Grammar(String paramString1, Tool paramTool, String paramString2)
  {
    this.className = paramString1;
    this.antlrTool = paramTool;
    this.symbols = new Hashtable();
    this.options = new Hashtable();
    this.rules = new Vector(100);
    this.superClass = paramString2;
  }

  public void define(RuleSymbol paramRuleSymbol)
  {
    this.rules.appendElement(paramRuleSymbol);
    this.symbols.put(paramRuleSymbol.getId(), paramRuleSymbol);
  }

  public abstract void generate()
    throws IOException;

  protected String getClassName()
  {
    return this.className;
  }

  public boolean getDefaultErrorHandler()
  {
    return this.defaultErrorHandler;
  }

  public String getFilename()
  {
    return this.fileName;
  }

  public int getIntegerOption(String paramString)
    throws NumberFormatException
  {
    Token localToken = (Token)this.options.get(paramString);
    if ((localToken == null) || (localToken.getType() != 20))
      throw new NumberFormatException();
    return Integer.parseInt(localToken.getText());
  }

  public Token getOption(String paramString)
  {
    return (Token)this.options.get(paramString);
  }

  protected abstract String getSuperClass();

  public GrammarSymbol getSymbol(String paramString)
  {
    return (GrammarSymbol)this.symbols.get(paramString);
  }

  public Enumeration getSymbols()
  {
    return this.symbols.elements();
  }

  public boolean hasOption(String paramString)
  {
    return this.options.containsKey(paramString);
  }

  public boolean isDefined(String paramString)
  {
    return this.symbols.containsKey(paramString);
  }

  public abstract void processArguments(String[] paramArrayOfString);

  public void setCodeGenerator(CodeGenerator paramCodeGenerator)
  {
    this.generator = paramCodeGenerator;
  }

  public void setFilename(String paramString)
  {
    this.fileName = paramString;
  }

  public void setGrammarAnalyzer(LLkGrammarAnalyzer paramLLkGrammarAnalyzer)
  {
    this.theLLkAnalyzer = paramLLkGrammarAnalyzer;
  }

  public boolean setOption(String paramString, Token paramToken)
  {
    this.options.put(paramString, paramToken);
    String str = paramToken.getText();
    if (paramString.equals("k"))
    {
      try
      {
        this.maxk = getIntegerOption("k");
        if (this.maxk <= 0)
        {
          this.antlrTool.error("option 'k' must be greater than 0 (was " + paramToken.getText() + ")", getFilename(), paramToken.getLine(), paramToken.getColumn());
          this.maxk = 1;
        }
      }
      catch (NumberFormatException localNumberFormatException1)
      {
        this.antlrTool.error("option 'k' must be an integer (was " + paramToken.getText() + ")", getFilename(), paramToken.getLine(), paramToken.getColumn());
      }
      return true;
    }
    int i;
    if (paramString.equals("codeGenMakeSwitchThreshold"))
    {
      try
      {
        i = getIntegerOption("codeGenMakeSwitchThreshold");
      }
      catch (NumberFormatException localNumberFormatException2)
      {
        this.antlrTool.error("option 'codeGenMakeSwitchThreshold' must be an integer", getFilename(), paramToken.getLine(), paramToken.getColumn());
      }
      return true;
    }
    if (paramString.equals("codeGenBitsetTestThreshold"))
    {
      try
      {
        i = getIntegerOption("codeGenBitsetTestThreshold");
      }
      catch (NumberFormatException localNumberFormatException3)
      {
        this.antlrTool.error("option 'codeGenBitsetTestThreshold' must be an integer", getFilename(), paramToken.getLine(), paramToken.getColumn());
      }
      return true;
    }
    if (paramString.equals("defaultErrorHandler"))
    {
      if (str.equals("true"))
        this.defaultErrorHandler = true;
      else if (str.equals("false"))
        this.defaultErrorHandler = false;
      else
        this.antlrTool.error("Value for defaultErrorHandler must be true or false", getFilename(), paramToken.getLine(), paramToken.getColumn());
      return true;
    }
    if (paramString.equals("analyzerDebug"))
    {
      if (str.equals("true"))
        this.analyzerDebug = true;
      else if (str.equals("false"))
        this.analyzerDebug = false;
      else
        this.antlrTool.error("option 'analyzerDebug' must be true or false", getFilename(), paramToken.getLine(), paramToken.getColumn());
      return true;
    }
    if (paramString.equals("codeGenDebug"))
    {
      if (str.equals("true"))
        this.analyzerDebug = true;
      else if (str.equals("false"))
        this.analyzerDebug = false;
      else
        this.antlrTool.error("option 'codeGenDebug' must be true or false", getFilename(), paramToken.getLine(), paramToken.getColumn());
      return true;
    }
    if (paramString.equals("classHeaderSuffix"))
      return true;
    if (paramString.equals("classHeaderPrefix"))
      return true;
    if (paramString.equals("namespaceAntlr"))
      return true;
    if (paramString.equals("namespaceStd"))
      return true;
    if (paramString.equals("genHashLines"))
      return true;
    return paramString.equals("noConstructors");
  }

  public void setTokenManager(TokenManager paramTokenManager)
  {
    this.tokenManager = paramTokenManager;
  }

  public String toString()
  {
    StringBuffer localStringBuffer = new StringBuffer(20000);
    Enumeration localEnumeration = this.rules.elements();
    while (localEnumeration.hasMoreElements())
    {
      RuleSymbol localRuleSymbol = (RuleSymbol)localEnumeration.nextElement();
      if (localRuleSymbol.id.equals("mnextToken"))
        continue;
      localStringBuffer.append(localRuleSymbol.getBlock().toString());
      localStringBuffer.append("\n\n");
    }
    return localStringBuffer.toString();
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.Grammar
 * JD-Core Version:    0.6.0
 */