package antlr;

import antlr.actions.csharp.ActionLexer;
import antlr.collections.impl.BitSet;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class CSharpCodeGenerator extends CodeGenerator
{
  protected int syntacticPredLevel = 0;
  protected boolean genAST = false;
  protected boolean saveText = false;
  boolean usingCustomAST = false;
  String labeledElementType;
  String labeledElementASTType;
  String labeledElementInit;
  String commonExtraArgs;
  String commonExtraParams;
  String commonLocalVars;
  String lt1Value;
  String exceptionThrown;
  String throwNoViable;
  RuleBlock currentRule;
  String currentASTResult;
  Hashtable treeVariableMap = new Hashtable();
  Hashtable declaredASTVariables = new Hashtable();
  int astVarNumber = 1;
  protected static final String NONUNIQUE = new String();
  public static final int caseSizeThreshold = 127;
  private antlr.collections.impl.Vector semPreds;
  private java.util.Vector astTypes;
  private static CSharpNameSpace nameSpace = null;
  int saveIndexCreateLevel;
  int blockNestingLevel;

  public CSharpCodeGenerator()
  {
    this.charFormatter = new CSharpCharFormatter();
  }

  protected int addSemPred(String paramString)
  {
    this.semPreds.appendElement(paramString);
    return this.semPreds.size() - 1;
  }

  public void exitIfError()
  {
    if (this.antlrTool.hasError())
      this.antlrTool.fatalError("Exiting due to errors.");
  }

  public void gen()
  {
    try
    {
      Enumeration localEnumeration = this.behavior.grammars.elements();
      while (localEnumeration.hasMoreElements())
      {
        localObject = (Grammar)localEnumeration.nextElement();
        ((Grammar)localObject).setGrammarAnalyzer(this.analyzer);
        ((Grammar)localObject).setCodeGenerator(this);
        this.analyzer.setGrammar((Grammar)localObject);
        setupGrammarParameters((Grammar)localObject);
        ((Grammar)localObject).generate();
        exitIfError();
      }
      Object localObject = this.behavior.tokenManagers.elements();
      while (((Enumeration)localObject).hasMoreElements())
      {
        TokenManager localTokenManager = (TokenManager)((Enumeration)localObject).nextElement();
        if (!localTokenManager.isReadOnly())
        {
          genTokenTypes(localTokenManager);
          genTokenInterchange(localTokenManager);
        }
        exitIfError();
      }
    }
    catch (IOException localIOException)
    {
      this.antlrTool.reportException(localIOException, null);
    }
  }

  public void gen(ActionElement paramActionElement)
  {
    if (this.DEBUG_CODE_GENERATOR)
      System.out.println("genAction(" + paramActionElement + ")");
    if (paramActionElement.isSemPred)
    {
      genSemPred(paramActionElement.actionText, paramActionElement.line);
    }
    else
    {
      if (this.grammar.hasSyntacticPredicate)
      {
        println("if (0==inputState.guessing)");
        println("{");
        this.tabs += 1;
      }
      ActionTransInfo localActionTransInfo = new ActionTransInfo();
      String str = processActionForSpecialSymbols(paramActionElement.actionText, paramActionElement.getLine(), this.currentRule, localActionTransInfo);
      if (localActionTransInfo.refRuleRoot != null)
        println(localActionTransInfo.refRuleRoot + " = (" + this.labeledElementASTType + ")currentAST.root;");
      printAction(str);
      if (localActionTransInfo.assignToRoot)
      {
        println("currentAST.root = " + localActionTransInfo.refRuleRoot + ";");
        println("if ( (null != " + localActionTransInfo.refRuleRoot + ") && (null != " + localActionTransInfo.refRuleRoot + ".getFirstChild()) )");
        this.tabs += 1;
        println("currentAST.child = " + localActionTransInfo.refRuleRoot + ".getFirstChild();");
        this.tabs -= 1;
        println("else");
        this.tabs += 1;
        println("currentAST.child = " + localActionTransInfo.refRuleRoot + ";");
        this.tabs -= 1;
        println("currentAST.advanceChildToEnd();");
      }
      if (this.grammar.hasSyntacticPredicate)
      {
        this.tabs -= 1;
        println("}");
      }
    }
  }

  public void gen(AlternativeBlock paramAlternativeBlock)
  {
    if (this.DEBUG_CODE_GENERATOR)
      System.out.println("gen(" + paramAlternativeBlock + ")");
    println("{");
    this.tabs += 1;
    genBlockPreamble(paramAlternativeBlock);
    genBlockInitAction(paramAlternativeBlock);
    String str = this.currentASTResult;
    if (paramAlternativeBlock.getLabel() != null)
      this.currentASTResult = paramAlternativeBlock.getLabel();
    boolean bool = this.grammar.theLLkAnalyzer.deterministic(paramAlternativeBlock);
    CSharpBlockFinishingInfo localCSharpBlockFinishingInfo = genCommonBlock(paramAlternativeBlock, true);
    genBlockFinish(localCSharpBlockFinishingInfo, this.throwNoViable);
    this.tabs -= 1;
    println("}");
    this.currentASTResult = str;
  }

  public void gen(BlockEndElement paramBlockEndElement)
  {
    if (this.DEBUG_CODE_GENERATOR)
      System.out.println("genRuleEnd(" + paramBlockEndElement + ")");
  }

  public void gen(CharLiteralElement paramCharLiteralElement)
  {
    if (this.DEBUG_CODE_GENERATOR)
      System.out.println("genChar(" + paramCharLiteralElement + ")");
    if (paramCharLiteralElement.getLabel() != null)
      println(paramCharLiteralElement.getLabel() + " = " + this.lt1Value + ";");
    boolean bool = this.saveText;
    this.saveText = ((this.saveText) && (paramCharLiteralElement.getAutoGenType() == 1));
    genMatch(paramCharLiteralElement);
    this.saveText = bool;
  }

  public void gen(CharRangeElement paramCharRangeElement)
  {
    if ((paramCharRangeElement.getLabel() != null) && (this.syntacticPredLevel == 0))
      println(paramCharRangeElement.getLabel() + " = " + this.lt1Value + ";");
    int i = ((this.grammar instanceof LexerGrammar)) && ((!this.saveText) || (paramCharRangeElement.getAutoGenType() == 3)) ? 1 : 0;
    if (i != 0)
      println("_saveIndex = text.Length;");
    println("matchRange(" + OctalToUnicode(paramCharRangeElement.beginText) + "," + OctalToUnicode(paramCharRangeElement.endText) + ");");
    if (i != 0)
      println("text.Length = _saveIndex;");
  }

  public void gen(LexerGrammar paramLexerGrammar)
    throws IOException
  {
    if (paramLexerGrammar.debuggingOutput)
      this.semPreds = new antlr.collections.impl.Vector();
    setGrammar(paramLexerGrammar);
    if (!(this.grammar instanceof LexerGrammar))
      this.antlrTool.panic("Internal error generating lexer");
    genBody(paramLexerGrammar);
  }

  public void gen(OneOrMoreBlock paramOneOrMoreBlock)
  {
    if (this.DEBUG_CODE_GENERATOR)
      System.out.println("gen+(" + paramOneOrMoreBlock + ")");
    println("{ // ( ... )+");
    this.tabs += 1;
    this.blockNestingLevel += 1;
    genBlockPreamble(paramOneOrMoreBlock);
    String str2;
    if (paramOneOrMoreBlock.getLabel() != null)
      str2 = "_cnt_" + paramOneOrMoreBlock.getLabel();
    else
      str2 = "_cnt" + paramOneOrMoreBlock.ID;
    println("int " + str2 + "=0;");
    String str1;
    if (paramOneOrMoreBlock.getLabel() != null)
      str1 = paramOneOrMoreBlock.getLabel();
    else
      str1 = "_loop" + paramOneOrMoreBlock.ID;
    println("for (;;)");
    println("{");
    this.tabs += 1;
    this.blockNestingLevel += 1;
    genBlockInitAction(paramOneOrMoreBlock);
    String str3 = this.currentASTResult;
    if (paramOneOrMoreBlock.getLabel() != null)
      this.currentASTResult = paramOneOrMoreBlock.getLabel();
    boolean bool = this.grammar.theLLkAnalyzer.deterministic(paramOneOrMoreBlock);
    int i = 0;
    int j = this.grammar.maxk;
    if ((!paramOneOrMoreBlock.greedy) && (paramOneOrMoreBlock.exitLookaheadDepth <= this.grammar.maxk) && (paramOneOrMoreBlock.exitCache[paramOneOrMoreBlock.exitLookaheadDepth].containsEpsilon()))
    {
      i = 1;
      j = paramOneOrMoreBlock.exitLookaheadDepth;
    }
    else if ((!paramOneOrMoreBlock.greedy) && (paramOneOrMoreBlock.exitLookaheadDepth == 2147483647))
    {
      i = 1;
    }
    if (i != 0)
    {
      if (this.DEBUG_CODE_GENERATOR)
        System.out.println("nongreedy (...)+ loop; exit depth is " + paramOneOrMoreBlock.exitLookaheadDepth);
      localObject = getLookaheadTestExpression(paramOneOrMoreBlock.exitCache, j);
      println("// nongreedy exit test");
      println("if ((" + str2 + " >= 1) && " + (String)localObject + ") goto " + str1 + "_breakloop;");
    }
    Object localObject = genCommonBlock(paramOneOrMoreBlock, false);
    genBlockFinish((CSharpBlockFinishingInfo)localObject, "if (" + str2 + " >= 1) { goto " + str1 + "_breakloop; } else { " + this.throwNoViable + "; }");
    println(str2 + "++;");
    this.tabs -= 1;
    if (this.blockNestingLevel-- == this.saveIndexCreateLevel)
      this.saveIndexCreateLevel = 0;
    println("}");
    _print(str1 + "_breakloop:");
    println(";");
    this.tabs -= 1;
    if (this.blockNestingLevel-- == this.saveIndexCreateLevel)
      this.saveIndexCreateLevel = 0;
    println("}    // ( ... )+");
    this.currentASTResult = str3;
  }

  public void gen(ParserGrammar paramParserGrammar)
    throws IOException
  {
    if (paramParserGrammar.debuggingOutput)
      this.semPreds = new antlr.collections.impl.Vector();
    setGrammar(paramParserGrammar);
    if (!(this.grammar instanceof ParserGrammar))
      this.antlrTool.panic("Internal error generating parser");
    genBody(paramParserGrammar);
  }

  public void gen(RuleRefElement paramRuleRefElement)
  {
    if (this.DEBUG_CODE_GENERATOR)
      System.out.println("genRR(" + paramRuleRefElement + ")");
    RuleSymbol localRuleSymbol = (RuleSymbol)this.grammar.getSymbol(paramRuleRefElement.targetRule);
    if ((localRuleSymbol == null) || (!localRuleSymbol.isDefined()))
    {
      this.antlrTool.error("Rule '" + paramRuleRefElement.targetRule + "' is not defined", this.grammar.getFilename(), paramRuleRefElement.getLine(), paramRuleRefElement.getColumn());
      return;
    }
    if (!(localRuleSymbol instanceof RuleSymbol))
    {
      this.antlrTool.error("'" + paramRuleRefElement.targetRule + "' does not name a grammar rule", this.grammar.getFilename(), paramRuleRefElement.getLine(), paramRuleRefElement.getColumn());
      return;
    }
    genErrorTryForElement(paramRuleRefElement);
    if (((this.grammar instanceof TreeWalkerGrammar)) && (paramRuleRefElement.getLabel() != null) && (this.syntacticPredLevel == 0))
      println(paramRuleRefElement.getLabel() + " = _t==ASTNULL ? null : " + this.lt1Value + ";");
    if (((this.grammar instanceof LexerGrammar)) && ((!this.saveText) || (paramRuleRefElement.getAutoGenType() == 3)))
    {
      declareSaveIndexVariableIfNeeded();
      println("_saveIndex = text.Length;");
    }
    printTabs();
    if (paramRuleRefElement.idAssign != null)
    {
      if (localRuleSymbol.block.returnAction == null)
        this.antlrTool.warning("Rule '" + paramRuleRefElement.targetRule + "' has no return type", this.grammar.getFilename(), paramRuleRefElement.getLine(), paramRuleRefElement.getColumn());
      _print(paramRuleRefElement.idAssign + "=");
    }
    else if ((!(this.grammar instanceof LexerGrammar)) && (this.syntacticPredLevel == 0) && (localRuleSymbol.block.returnAction != null))
    {
      this.antlrTool.warning("Rule '" + paramRuleRefElement.targetRule + "' returns a value", this.grammar.getFilename(), paramRuleRefElement.getLine(), paramRuleRefElement.getColumn());
    }
    GenRuleInvocation(paramRuleRefElement);
    if (((this.grammar instanceof LexerGrammar)) && ((!this.saveText) || (paramRuleRefElement.getAutoGenType() == 3)))
    {
      declareSaveIndexVariableIfNeeded();
      println("text.Length = _saveIndex;");
    }
    if (this.syntacticPredLevel == 0)
    {
      int i = (this.grammar.hasSyntacticPredicate) && (((this.grammar.buildAST) && (paramRuleRefElement.getLabel() != null)) || ((this.genAST) && (paramRuleRefElement.getAutoGenType() == 1))) ? 1 : 0;
      if (i != 0)
      {
        println("if (0 == inputState.guessing)");
        println("{");
        this.tabs += 1;
      }
      if ((this.grammar.buildAST) && (paramRuleRefElement.getLabel() != null))
        println(paramRuleRefElement.getLabel() + "_AST = (" + this.labeledElementASTType + ")returnAST;");
      if (this.genAST)
        switch (paramRuleRefElement.getAutoGenType())
        {
        case 1:
          if (this.usingCustomAST)
            println("astFactory.addASTChild(ref currentAST, (AST)returnAST);");
          else
            println("astFactory.addASTChild(ref currentAST, returnAST);");
          break;
        case 2:
          this.antlrTool.error("Internal: encountered ^ after rule reference");
          break;
        }
      if (((this.grammar instanceof LexerGrammar)) && (paramRuleRefElement.getLabel() != null))
        println(paramRuleRefElement.getLabel() + " = returnToken_;");
      if (i != 0)
      {
        this.tabs -= 1;
        println("}");
      }
    }
    genErrorCatchForElement(paramRuleRefElement);
  }

  public void gen(StringLiteralElement paramStringLiteralElement)
  {
    if (this.DEBUG_CODE_GENERATOR)
      System.out.println("genString(" + paramStringLiteralElement + ")");
    if ((paramStringLiteralElement.getLabel() != null) && (this.syntacticPredLevel == 0))
      println(paramStringLiteralElement.getLabel() + " = " + this.lt1Value + ";");
    genElementAST(paramStringLiteralElement);
    boolean bool = this.saveText;
    this.saveText = ((this.saveText) && (paramStringLiteralElement.getAutoGenType() == 1));
    genMatch(paramStringLiteralElement);
    this.saveText = bool;
    if ((this.grammar instanceof TreeWalkerGrammar))
      println("_t = _t.getNextSibling();");
  }

  public void gen(TokenRangeElement paramTokenRangeElement)
  {
    genErrorTryForElement(paramTokenRangeElement);
    if ((paramTokenRangeElement.getLabel() != null) && (this.syntacticPredLevel == 0))
      println(paramTokenRangeElement.getLabel() + " = " + this.lt1Value + ";");
    genElementAST(paramTokenRangeElement);
    println("matchRange(" + OctalToUnicode(paramTokenRangeElement.beginText) + "," + OctalToUnicode(paramTokenRangeElement.endText) + ");");
    genErrorCatchForElement(paramTokenRangeElement);
  }

  public void gen(TokenRefElement paramTokenRefElement)
  {
    if (this.DEBUG_CODE_GENERATOR)
      System.out.println("genTokenRef(" + paramTokenRefElement + ")");
    if ((this.grammar instanceof LexerGrammar))
      this.antlrTool.panic("Token reference found in lexer");
    genErrorTryForElement(paramTokenRefElement);
    if ((paramTokenRefElement.getLabel() != null) && (this.syntacticPredLevel == 0))
      println(paramTokenRefElement.getLabel() + " = " + this.lt1Value + ";");
    genElementAST(paramTokenRefElement);
    genMatch(paramTokenRefElement);
    genErrorCatchForElement(paramTokenRefElement);
    if ((this.grammar instanceof TreeWalkerGrammar))
      println("_t = _t.getNextSibling();");
  }

  public void gen(TreeElement paramTreeElement)
  {
    println("AST __t" + paramTreeElement.ID + " = _t;");
    if (paramTreeElement.root.getLabel() != null)
      println(paramTreeElement.root.getLabel() + " = (ASTNULL == _t) ? null : (" + this.labeledElementASTType + ")_t;");
    if (paramTreeElement.root.getAutoGenType() == 3)
    {
      this.antlrTool.error("Suffixing a root node with '!' is not implemented", this.grammar.getFilename(), paramTreeElement.getLine(), paramTreeElement.getColumn());
      paramTreeElement.root.setAutoGenType(1);
    }
    if (paramTreeElement.root.getAutoGenType() == 2)
    {
      this.antlrTool.warning("Suffixing a root node with '^' is redundant; already a root", this.grammar.getFilename(), paramTreeElement.getLine(), paramTreeElement.getColumn());
      paramTreeElement.root.setAutoGenType(1);
    }
    genElementAST(paramTreeElement.root);
    if (this.grammar.buildAST)
    {
      println("ASTPair __currentAST" + paramTreeElement.ID + " = currentAST.copy();");
      println("currentAST.root = currentAST.child;");
      println("currentAST.child = null;");
    }
    if ((paramTreeElement.root instanceof WildcardElement))
      println("if (null == _t) throw new MismatchedTokenException();");
    else
      genMatch(paramTreeElement.root);
    println("_t = _t.getFirstChild();");
    for (int i = 0; i < paramTreeElement.getAlternatives().size(); i++)
    {
      Alternative localAlternative = paramTreeElement.getAlternativeAt(i);
      for (AlternativeElement localAlternativeElement = localAlternative.head; localAlternativeElement != null; localAlternativeElement = localAlternativeElement.next)
        localAlternativeElement.generate();
    }
    if (this.grammar.buildAST)
      println("currentAST = __currentAST" + paramTreeElement.ID + ";");
    println("_t = __t" + paramTreeElement.ID + ";");
    println("_t = _t.getNextSibling();");
  }

  public void gen(TreeWalkerGrammar paramTreeWalkerGrammar)
    throws IOException
  {
    setGrammar(paramTreeWalkerGrammar);
    if (!(this.grammar instanceof TreeWalkerGrammar))
      this.antlrTool.panic("Internal error generating tree-walker");
    genBody(paramTreeWalkerGrammar);
  }

  public void gen(WildcardElement paramWildcardElement)
  {
    if ((paramWildcardElement.getLabel() != null) && (this.syntacticPredLevel == 0))
      println(paramWildcardElement.getLabel() + " = " + this.lt1Value + ";");
    genElementAST(paramWildcardElement);
    if ((this.grammar instanceof TreeWalkerGrammar))
    {
      println("if (null == _t) throw new MismatchedTokenException();");
    }
    else if ((this.grammar instanceof LexerGrammar))
    {
      if (((this.grammar instanceof LexerGrammar)) && ((!this.saveText) || (paramWildcardElement.getAutoGenType() == 3)))
      {
        declareSaveIndexVariableIfNeeded();
        println("_saveIndex = text.Length;");
      }
      println("matchNot(EOF/*_CHAR*/);");
      if (((this.grammar instanceof LexerGrammar)) && ((!this.saveText) || (paramWildcardElement.getAutoGenType() == 3)))
      {
        declareSaveIndexVariableIfNeeded();
        println("text.Length = _saveIndex;");
      }
    }
    else
    {
      println("matchNot(" + getValueString(1) + ");");
    }
    if ((this.grammar instanceof TreeWalkerGrammar))
      println("_t = _t.getNextSibling();");
  }

  public void gen(ZeroOrMoreBlock paramZeroOrMoreBlock)
  {
    if (this.DEBUG_CODE_GENERATOR)
      System.out.println("gen*(" + paramZeroOrMoreBlock + ")");
    println("{    // ( ... )*");
    this.tabs += 1;
    this.blockNestingLevel += 1;
    genBlockPreamble(paramZeroOrMoreBlock);
    String str1;
    if (paramZeroOrMoreBlock.getLabel() != null)
      str1 = paramZeroOrMoreBlock.getLabel();
    else
      str1 = "_loop" + paramZeroOrMoreBlock.ID;
    println("for (;;)");
    println("{");
    this.tabs += 1;
    this.blockNestingLevel += 1;
    genBlockInitAction(paramZeroOrMoreBlock);
    String str2 = this.currentASTResult;
    if (paramZeroOrMoreBlock.getLabel() != null)
      this.currentASTResult = paramZeroOrMoreBlock.getLabel();
    boolean bool = this.grammar.theLLkAnalyzer.deterministic(paramZeroOrMoreBlock);
    int i = 0;
    int j = this.grammar.maxk;
    if ((!paramZeroOrMoreBlock.greedy) && (paramZeroOrMoreBlock.exitLookaheadDepth <= this.grammar.maxk) && (paramZeroOrMoreBlock.exitCache[paramZeroOrMoreBlock.exitLookaheadDepth].containsEpsilon()))
    {
      i = 1;
      j = paramZeroOrMoreBlock.exitLookaheadDepth;
    }
    else if ((!paramZeroOrMoreBlock.greedy) && (paramZeroOrMoreBlock.exitLookaheadDepth == 2147483647))
    {
      i = 1;
    }
    if (i != 0)
    {
      if (this.DEBUG_CODE_GENERATOR)
        System.out.println("nongreedy (...)* loop; exit depth is " + paramZeroOrMoreBlock.exitLookaheadDepth);
      localObject = getLookaheadTestExpression(paramZeroOrMoreBlock.exitCache, j);
      println("// nongreedy exit test");
      println("if (" + (String)localObject + ") goto " + str1 + "_breakloop;");
    }
    Object localObject = genCommonBlock(paramZeroOrMoreBlock, false);
    genBlockFinish((CSharpBlockFinishingInfo)localObject, "goto " + str1 + "_breakloop;");
    this.tabs -= 1;
    if (this.blockNestingLevel-- == this.saveIndexCreateLevel)
      this.saveIndexCreateLevel = 0;
    println("}");
    _print(str1 + "_breakloop:");
    println(";");
    this.tabs -= 1;
    if (this.blockNestingLevel-- == this.saveIndexCreateLevel)
      this.saveIndexCreateLevel = 0;
    println("}    // ( ... )*");
    this.currentASTResult = str2;
  }

  protected void genAlt(Alternative paramAlternative, AlternativeBlock paramAlternativeBlock)
  {
    boolean bool1 = this.genAST;
    this.genAST = ((this.genAST) && (paramAlternative.getAutoGen()));
    boolean bool2 = this.saveText;
    this.saveText = ((this.saveText) && (paramAlternative.getAutoGen()));
    Hashtable localHashtable = this.treeVariableMap;
    this.treeVariableMap = new Hashtable();
    if (paramAlternative.exceptionSpec != null)
    {
      println("try        // for error handling");
      println("{");
      this.tabs += 1;
    }
    for (AlternativeElement localAlternativeElement = paramAlternative.head; !(localAlternativeElement instanceof BlockEndElement); localAlternativeElement = localAlternativeElement.next)
      localAlternativeElement.generate();
    if (this.genAST)
      if ((paramAlternativeBlock instanceof RuleBlock))
      {
        RuleBlock localRuleBlock = (RuleBlock)paramAlternativeBlock;
        if (this.usingCustomAST)
          println(localRuleBlock.getRuleName() + "_AST = (" + this.labeledElementASTType + ")currentAST.root;");
        else
          println(localRuleBlock.getRuleName() + "_AST = currentAST.root;");
      }
      else if (paramAlternativeBlock.getLabel() != null)
      {
        this.antlrTool.warning("Labeled subrules not yet supported", this.grammar.getFilename(), paramAlternativeBlock.getLine(), paramAlternativeBlock.getColumn());
      }
    if (paramAlternative.exceptionSpec != null)
    {
      this.tabs -= 1;
      println("}");
      genErrorHandler(paramAlternative.exceptionSpec);
    }
    this.genAST = bool1;
    this.saveText = bool2;
    this.treeVariableMap = localHashtable;
  }

  protected void genBitsets(antlr.collections.impl.Vector paramVector, int paramInt)
  {
    println("");
    for (int i = 0; i < paramVector.size(); i++)
    {
      BitSet localBitSet = (BitSet)paramVector.elementAt(i);
      localBitSet.growToInclude(paramInt);
      genBitSet(localBitSet, i);
    }
  }

  private void genBitSet(BitSet paramBitSet, int paramInt)
  {
    println("private static long[] mk_" + getBitsetName(paramInt) + "()");
    println("{");
    this.tabs += 1;
    int i = paramBitSet.lengthInLongWords();
    if (i < 8)
    {
      println("long[] data = { " + paramBitSet.toStringOfWords() + "};");
    }
    else
    {
      println("long[] data = new long[" + i + "];");
      long[] arrayOfLong = paramBitSet.toPackedArray();
      int j = 0;
      while (j < arrayOfLong.length)
      {
        if ((j + 1 == arrayOfLong.length) || (arrayOfLong[j] != arrayOfLong[(j + 1)]))
        {
          println("data[" + j + "]=" + arrayOfLong[j] + "L;");
          j++;
          continue;
        }
        for (int k = j + 1; (k < arrayOfLong.length) && (arrayOfLong[k] == arrayOfLong[j]); k++);
        println("for (int i = " + j + "; i<=" + (k - 1) + "; i++) { data[i]=" + arrayOfLong[j] + "L; }");
        j = k;
      }
    }
    println("return data;");
    this.tabs -= 1;
    println("}");
    println("public static readonly BitSet " + getBitsetName(paramInt) + " = new BitSet(" + "mk_" + getBitsetName(paramInt) + "()" + ");");
  }

  protected String getBitsetName(int paramInt)
  {
    return "tokenSet_" + paramInt + "_";
  }

  private void genBlockFinish(CSharpBlockFinishingInfo paramCSharpBlockFinishingInfo, String paramString)
  {
    if ((paramCSharpBlockFinishingInfo.needAnErrorClause) && ((paramCSharpBlockFinishingInfo.generatedAnIf) || (paramCSharpBlockFinishingInfo.generatedSwitch)))
    {
      if (paramCSharpBlockFinishingInfo.generatedAnIf)
      {
        println("else");
        println("{");
      }
      else
      {
        println("{");
      }
      this.tabs += 1;
      println(paramString);
      this.tabs -= 1;
      println("}");
    }
    if (paramCSharpBlockFinishingInfo.postscript != null)
      if ((paramCSharpBlockFinishingInfo.needAnErrorClause) && (paramCSharpBlockFinishingInfo.generatedSwitch) && (!paramCSharpBlockFinishingInfo.generatedAnIf) && (paramString != null))
      {
        if ((paramString.indexOf("throw") == 0) || (paramString.indexOf("goto") == 0))
        {
          int i = paramCSharpBlockFinishingInfo.postscript.indexOf("break;") + 6;
          String str = paramCSharpBlockFinishingInfo.postscript.substring(i);
          println(str);
        }
        else
        {
          println(paramCSharpBlockFinishingInfo.postscript);
        }
      }
      else
        println(paramCSharpBlockFinishingInfo.postscript);
  }

  protected void genBlockInitAction(AlternativeBlock paramAlternativeBlock)
  {
    if (paramAlternativeBlock.initAction != null)
      printAction(processActionForSpecialSymbols(paramAlternativeBlock.initAction, paramAlternativeBlock.getLine(), this.currentRule, null));
  }

  protected void genBlockPreamble(AlternativeBlock paramAlternativeBlock)
  {
    if ((paramAlternativeBlock instanceof RuleBlock))
    {
      RuleBlock localRuleBlock = (RuleBlock)paramAlternativeBlock;
      if (localRuleBlock.labeledElements != null)
        for (int i = 0; i < localRuleBlock.labeledElements.size(); i++)
        {
          AlternativeElement localAlternativeElement = (AlternativeElement)localRuleBlock.labeledElements.elementAt(i);
          if (((localAlternativeElement instanceof RuleRefElement)) || (((localAlternativeElement instanceof AlternativeBlock)) && (!(localAlternativeElement instanceof RuleBlock)) && (!(localAlternativeElement instanceof SynPredBlock))))
          {
            if ((!(localAlternativeElement instanceof RuleRefElement)) && (((AlternativeBlock)localAlternativeElement).not) && (this.analyzer.subruleCanBeInverted((AlternativeBlock)localAlternativeElement, this.grammar instanceof LexerGrammar)))
            {
              println(this.labeledElementType + " " + localAlternativeElement.getLabel() + " = " + this.labeledElementInit + ";");
              if (!this.grammar.buildAST)
                continue;
              genASTDeclaration(localAlternativeElement);
            }
            else
            {
              if (this.grammar.buildAST)
                genASTDeclaration(localAlternativeElement);
              if ((this.grammar instanceof LexerGrammar))
                println("IToken " + localAlternativeElement.getLabel() + " = null;");
              if (!(this.grammar instanceof TreeWalkerGrammar))
                continue;
              println(this.labeledElementType + " " + localAlternativeElement.getLabel() + " = " + this.labeledElementInit + ";");
            }
          }
          else
          {
            println(this.labeledElementType + " " + localAlternativeElement.getLabel() + " = " + this.labeledElementInit + ";");
            if (!this.grammar.buildAST)
              continue;
            if (((localAlternativeElement instanceof GrammarAtom)) && (((GrammarAtom)localAlternativeElement).getASTNodeType() != null))
            {
              GrammarAtom localGrammarAtom = (GrammarAtom)localAlternativeElement;
              genASTDeclaration(localAlternativeElement, localGrammarAtom.getASTNodeType());
            }
            else
            {
              genASTDeclaration(localAlternativeElement);
            }
          }
        }
    }
  }

  public void genBody(LexerGrammar paramLexerGrammar)
    throws IOException
  {
    setupOutput(this.grammar.getClassName());
    this.genAST = false;
    this.saveText = true;
    this.tabs = 0;
    genHeader();
    println(this.behavior.getHeaderAction(""));
    if (nameSpace != null)
      nameSpace.emitDeclarations(this.currentOutput);
    this.tabs += 1;
    println("// Generate header specific to lexer CSharp file");
    println("using System;");
    println("using Stream                          = System.IO.Stream;");
    println("using TextReader                      = System.IO.TextReader;");
    println("using Hashtable                       = System.Collections.Hashtable;");
    println("using Comparer                        = System.Collections.Comparer;");
    if (!paramLexerGrammar.caseSensitiveLiterals)
    {
      println("using CaseInsensitiveHashCodeProvider = System.Collections.CaseInsensitiveHashCodeProvider;");
      println("using CaseInsensitiveComparer         = System.Collections.CaseInsensitiveComparer;");
    }
    println("");
    println("using TokenStreamException            = antlr.TokenStreamException;");
    println("using TokenStreamIOException          = antlr.TokenStreamIOException;");
    println("using TokenStreamRecognitionException = antlr.TokenStreamRecognitionException;");
    println("using CharStreamException             = antlr.CharStreamException;");
    println("using CharStreamIOException           = antlr.CharStreamIOException;");
    println("using ANTLRException                  = antlr.ANTLRException;");
    println("using CharScanner                     = antlr.CharScanner;");
    println("using InputBuffer                     = antlr.InputBuffer;");
    println("using ByteBuffer                      = antlr.ByteBuffer;");
    println("using CharBuffer                      = antlr.CharBuffer;");
    println("using Token                           = antlr.Token;");
    println("using IToken                          = antlr.IToken;");
    println("using CommonToken                     = antlr.CommonToken;");
    println("using SemanticException               = antlr.SemanticException;");
    println("using RecognitionException            = antlr.RecognitionException;");
    println("using NoViableAltForCharException     = antlr.NoViableAltForCharException;");
    println("using MismatchedCharException         = antlr.MismatchedCharException;");
    println("using TokenStream                     = antlr.TokenStream;");
    println("using LexerSharedInputState           = antlr.LexerSharedInputState;");
    println("using BitSet                          = antlr.collections.impl.BitSet;");
    println(this.grammar.preambleAction.getText());
    String str = null;
    if (this.grammar.superClass != null)
      str = this.grammar.superClass;
    else
      str = "antlr." + this.grammar.getSuperClass();
    if (this.grammar.comment != null)
      _println(this.grammar.comment);
    Token localToken = (Token)this.grammar.options.get("classHeaderPrefix");
    if (localToken == null)
    {
      print("public ");
    }
    else
    {
      localObject1 = StringUtils.stripFrontBack(localToken.getText(), "\"", "\"");
      if (localObject1 == null)
        print("public ");
      else
        print((String)localObject1 + " ");
    }
    print("class " + this.grammar.getClassName() + " : " + str);
    println(", TokenStream");
    Object localObject1 = (Token)this.grammar.options.get("classHeaderSuffix");
    if (localObject1 != null)
    {
      localObject2 = StringUtils.stripFrontBack(((Token)localObject1).getText(), "\"", "\"");
      if (localObject2 != null)
        print(", " + (String)localObject2);
    }
    println(" {");
    this.tabs += 1;
    genTokenDefinitions(this.grammar.tokenManager);
    print(processActionForSpecialSymbols(this.grammar.classMemberAction.getText(), this.grammar.classMemberAction.getLine(), this.currentRule, null));
    println("public " + this.grammar.getClassName() + "(Stream ins) : this(new ByteBuffer(ins))");
    println("{");
    println("}");
    println("");
    println("public " + this.grammar.getClassName() + "(TextReader r) : this(new CharBuffer(r))");
    println("{");
    println("}");
    println("");
    print("public " + this.grammar.getClassName() + "(InputBuffer ib)");
    if (this.grammar.debuggingOutput)
      println(" : this(new LexerSharedInputState(new antlr.debug.DebuggingInputBuffer(ib)))");
    else
      println(" : this(new LexerSharedInputState(ib))");
    println("{");
    println("}");
    println("");
    println("public " + this.grammar.getClassName() + "(LexerSharedInputState state) : base(state)");
    println("{");
    this.tabs += 1;
    println("initialize();");
    this.tabs -= 1;
    println("}");
    println("private void initialize()");
    println("{");
    this.tabs += 1;
    if (this.grammar.debuggingOutput)
    {
      println("ruleNames  = _ruleNames;");
      println("semPredNames = _semPredNames;");
      println("setupDebugging();");
    }
    println("caseSensitiveLiterals = " + paramLexerGrammar.caseSensitiveLiterals + ";");
    println("setCaseSensitive(" + paramLexerGrammar.caseSensitive + ");");
    if (paramLexerGrammar.caseSensitiveLiterals)
      println("literals = new Hashtable(100, (float) 0.4, null, Comparer.Default);");
    else
      println("literals = new Hashtable(100, (float) 0.4, CaseInsensitiveHashCodeProvider.Default, CaseInsensitiveComparer.Default);");
    Object localObject2 = this.grammar.tokenManager.getTokenSymbolKeys();
    Object localObject4;
    while (((Enumeration)localObject2).hasMoreElements())
    {
      localObject3 = (String)((Enumeration)localObject2).nextElement();
      if (((String)localObject3).charAt(0) != '"')
        continue;
      TokenSymbol localTokenSymbol = this.grammar.tokenManager.getTokenSymbol((String)localObject3);
      if (!(localTokenSymbol instanceof StringLiteralSymbol))
        continue;
      localObject4 = (StringLiteralSymbol)localTokenSymbol;
      println("literals.Add(" + ((StringLiteralSymbol)localObject4).getId() + ", " + ((StringLiteralSymbol)localObject4).getTokenType() + ");");
    }
    this.tabs -= 1;
    println("}");
    if (this.grammar.debuggingOutput)
    {
      println("private static readonly string[] _ruleNames = new string[] {");
      localObject3 = this.grammar.rules.elements();
      i = 0;
      while (((Enumeration)localObject3).hasMoreElements())
      {
        localObject4 = (GrammarSymbol)((Enumeration)localObject3).nextElement();
        if (!(localObject4 instanceof RuleSymbol))
          continue;
        println("  \"" + ((RuleSymbol)localObject4).getId() + "\",");
      }
      println("};");
    }
    genNextToken();
    Object localObject3 = this.grammar.rules.elements();
    int i = 0;
    while (((Enumeration)localObject3).hasMoreElements())
    {
      localObject4 = (RuleSymbol)((Enumeration)localObject3).nextElement();
      if (!((RuleSymbol)localObject4).getId().equals("mnextToken"))
        genRule((RuleSymbol)localObject4, false, i++, this.grammar.tokenManager);
      exitIfError();
    }
    if (this.grammar.debuggingOutput)
      genSemPredMap();
    genBitsets(this.bitsetsUsed, ((LexerGrammar)this.grammar).charVocabulary.size());
    println("");
    this.tabs -= 1;
    println("}");
    this.tabs -= 1;
    if (nameSpace != null)
      nameSpace.emitClosures(this.currentOutput);
    this.currentOutput.close();
    this.currentOutput = null;
  }

  public void genInitFactory(Grammar paramGrammar)
  {
    if (paramGrammar.buildAST)
    {
      println("static public void initializeASTFactory( ASTFactory factory )");
      println("{");
      this.tabs += 1;
      println("factory.setMaxNodeType(" + paramGrammar.tokenManager.maxTokenType() + ");");
      antlr.collections.impl.Vector localVector = paramGrammar.tokenManager.getVocabulary();
      for (int i = 0; i < localVector.size(); i++)
      {
        String str = (String)localVector.elementAt(i);
        if (str == null)
          continue;
        TokenSymbol localTokenSymbol = paramGrammar.tokenManager.getTokenSymbol(str);
        if ((localTokenSymbol == null) || (localTokenSymbol.getASTNodeType() == null))
          continue;
        println("factory.setTokenTypeASTNodeType(" + str + ", \"" + localTokenSymbol.getASTNodeType() + "\");");
      }
      this.tabs -= 1;
      println("}");
    }
  }

  public void genBody(ParserGrammar paramParserGrammar)
    throws IOException
  {
    setupOutput(this.grammar.getClassName());
    this.genAST = this.grammar.buildAST;
    this.tabs = 0;
    genHeader();
    println(this.behavior.getHeaderAction(""));
    if (nameSpace != null)
      nameSpace.emitDeclarations(this.currentOutput);
    this.tabs += 1;
    println("// Generate the header common to all output files.");
    println("using System;");
    println("");
    println("using TokenBuffer              = antlr.TokenBuffer;");
    println("using TokenStreamException     = antlr.TokenStreamException;");
    println("using TokenStreamIOException   = antlr.TokenStreamIOException;");
    println("using ANTLRException           = antlr.ANTLRException;");
    String str1 = this.grammar.getSuperClass();
    String[] arrayOfString = split(str1, ".");
    println("using " + arrayOfString[(arrayOfString.length - 1)] + " = antlr." + str1 + ";");
    println("using Token                    = antlr.Token;");
    println("using IToken                   = antlr.IToken;");
    println("using TokenStream              = antlr.TokenStream;");
    println("using RecognitionException     = antlr.RecognitionException;");
    println("using NoViableAltException     = antlr.NoViableAltException;");
    println("using MismatchedTokenException = antlr.MismatchedTokenException;");
    println("using SemanticException        = antlr.SemanticException;");
    println("using ParserSharedInputState   = antlr.ParserSharedInputState;");
    println("using BitSet                   = antlr.collections.impl.BitSet;");
    if (this.genAST)
    {
      println("using AST                      = antlr.collections.AST;");
      println("using ASTPair                  = antlr.ASTPair;");
      println("using ASTFactory               = antlr.ASTFactory;");
      println("using ASTArray                 = antlr.collections.impl.ASTArray;");
    }
    println(this.grammar.preambleAction.getText());
    String str2 = null;
    if (this.grammar.superClass != null)
      str2 = this.grammar.superClass;
    else
      str2 = "antlr." + this.grammar.getSuperClass();
    if (this.grammar.comment != null)
      _println(this.grammar.comment);
    Token localToken = (Token)this.grammar.options.get("classHeaderPrefix");
    if (localToken == null)
    {
      print("public ");
    }
    else
    {
      localObject1 = StringUtils.stripFrontBack(localToken.getText(), "\"", "\"");
      if (localObject1 == null)
        print("public ");
      else
        print((String)localObject1 + " ");
    }
    println("class " + this.grammar.getClassName() + " : " + str2);
    Object localObject1 = (Token)this.grammar.options.get("classHeaderSuffix");
    if (localObject1 != null)
    {
      localObject2 = StringUtils.stripFrontBack(((Token)localObject1).getText(), "\"", "\"");
      if (localObject2 != null)
        print("              , " + (String)localObject2);
    }
    println("{");
    this.tabs += 1;
    genTokenDefinitions(this.grammar.tokenManager);
    GrammarSymbol localGrammarSymbol;
    if (this.grammar.debuggingOutput)
    {
      println("private static readonly string[] _ruleNames = new string[] {");
      this.tabs += 1;
      localObject2 = this.grammar.rules.elements();
      i = 0;
      while (((Enumeration)localObject2).hasMoreElements())
      {
        localGrammarSymbol = (GrammarSymbol)((Enumeration)localObject2).nextElement();
        if (!(localGrammarSymbol instanceof RuleSymbol))
          continue;
        println("  \"" + ((RuleSymbol)localGrammarSymbol).getId() + "\",");
      }
      this.tabs -= 1;
      println("};");
    }
    print(processActionForSpecialSymbols(this.grammar.classMemberAction.getText(), this.grammar.classMemberAction.getLine(), this.currentRule, null));
    println("");
    println("protected void initialize()");
    println("{");
    this.tabs += 1;
    println("tokenNames = tokenNames_;");
    if (this.grammar.buildAST)
      println("initializeFactory();");
    if (this.grammar.debuggingOutput)
    {
      println("ruleNames  = _ruleNames;");
      println("semPredNames = _semPredNames;");
      println("setupDebugging(tokenBuf);");
    }
    this.tabs -= 1;
    println("}");
    println("");
    println("");
    println("protected " + this.grammar.getClassName() + "(TokenBuffer tokenBuf, int k) : base(tokenBuf, k)");
    println("{");
    this.tabs += 1;
    println("initialize();");
    this.tabs -= 1;
    println("}");
    println("");
    println("public " + this.grammar.getClassName() + "(TokenBuffer tokenBuf) : this(tokenBuf," + this.grammar.maxk + ")");
    println("{");
    println("}");
    println("");
    println("protected " + this.grammar.getClassName() + "(TokenStream lexer, int k) : base(lexer,k)");
    println("{");
    this.tabs += 1;
    println("initialize();");
    this.tabs -= 1;
    println("}");
    println("");
    println("public " + this.grammar.getClassName() + "(TokenStream lexer) : this(lexer," + this.grammar.maxk + ")");
    println("{");
    println("}");
    println("");
    println("public " + this.grammar.getClassName() + "(ParserSharedInputState state) : base(state," + this.grammar.maxk + ")");
    println("{");
    this.tabs += 1;
    println("initialize();");
    this.tabs -= 1;
    println("}");
    println("");
    this.astTypes = new java.util.Vector(100);
    Object localObject2 = this.grammar.rules.elements();
    int i = 0;
    while (((Enumeration)localObject2).hasMoreElements())
    {
      localGrammarSymbol = (GrammarSymbol)((Enumeration)localObject2).nextElement();
      if ((localGrammarSymbol instanceof RuleSymbol))
      {
        RuleSymbol localRuleSymbol = (RuleSymbol)localGrammarSymbol;
        genRule(localRuleSymbol, localRuleSymbol.references.size() == 0, i++, this.grammar.tokenManager);
      }
      exitIfError();
    }
    if (this.usingCustomAST)
    {
      println("public new " + this.labeledElementASTType + " getAST()");
      println("{");
      this.tabs += 1;
      println("return (" + this.labeledElementASTType + ") returnAST;");
      this.tabs -= 1;
      println("}");
      println("");
    }
    println("private void initializeFactory()");
    println("{");
    this.tabs += 1;
    if (this.grammar.buildAST)
    {
      println("if (astFactory == null)");
      println("{");
      this.tabs += 1;
      if (this.usingCustomAST)
        println("astFactory = new ASTFactory(\"" + this.labeledElementASTType + "\");");
      else
        println("astFactory = new ASTFactory();");
      this.tabs -= 1;
      println("}");
      println("initializeASTFactory( astFactory );");
    }
    this.tabs -= 1;
    println("}");
    genInitFactory(paramParserGrammar);
    genTokenStrings();
    genBitsets(this.bitsetsUsed, this.grammar.tokenManager.maxTokenType());
    if (this.grammar.debuggingOutput)
      genSemPredMap();
    println("");
    this.tabs -= 1;
    println("}");
    this.tabs -= 1;
    if (nameSpace != null)
      nameSpace.emitClosures(this.currentOutput);
    this.currentOutput.close();
    this.currentOutput = null;
  }

  public void genBody(TreeWalkerGrammar paramTreeWalkerGrammar)
    throws IOException
  {
    setupOutput(this.grammar.getClassName());
    this.genAST = this.grammar.buildAST;
    this.tabs = 0;
    genHeader();
    println(this.behavior.getHeaderAction(""));
    if (nameSpace != null)
      nameSpace.emitDeclarations(this.currentOutput);
    this.tabs += 1;
    println("// Generate header specific to the tree-parser CSharp file");
    println("using System;");
    println("");
    println("using " + this.grammar.getSuperClass() + " = antlr." + this.grammar.getSuperClass() + ";");
    println("using Token                    = antlr.Token;");
    println("using IToken                   = antlr.IToken;");
    println("using AST                      = antlr.collections.AST;");
    println("using RecognitionException     = antlr.RecognitionException;");
    println("using ANTLRException           = antlr.ANTLRException;");
    println("using NoViableAltException     = antlr.NoViableAltException;");
    println("using MismatchedTokenException = antlr.MismatchedTokenException;");
    println("using SemanticException        = antlr.SemanticException;");
    println("using BitSet                   = antlr.collections.impl.BitSet;");
    println("using ASTPair                  = antlr.ASTPair;");
    println("using ASTFactory               = antlr.ASTFactory;");
    println("using ASTArray                 = antlr.collections.impl.ASTArray;");
    println(this.grammar.preambleAction.getText());
    String str1 = null;
    if (this.grammar.superClass != null)
      str1 = this.grammar.superClass;
    else
      str1 = "antlr." + this.grammar.getSuperClass();
    println("");
    if (this.grammar.comment != null)
      _println(this.grammar.comment);
    Token localToken = (Token)this.grammar.options.get("classHeaderPrefix");
    if (localToken == null)
    {
      print("public ");
    }
    else
    {
      localObject1 = StringUtils.stripFrontBack(localToken.getText(), "\"", "\"");
      if (localObject1 == null)
        print("public ");
      else
        print((String)localObject1 + " ");
    }
    println("class " + this.grammar.getClassName() + " : " + str1);
    Object localObject1 = (Token)this.grammar.options.get("classHeaderSuffix");
    if (localObject1 != null)
    {
      localObject2 = StringUtils.stripFrontBack(((Token)localObject1).getText(), "\"", "\"");
      if (localObject2 != null)
        print("              , " + (String)localObject2);
    }
    println("{");
    this.tabs += 1;
    genTokenDefinitions(this.grammar.tokenManager);
    print(processActionForSpecialSymbols(this.grammar.classMemberAction.getText(), this.grammar.classMemberAction.getLine(), this.currentRule, null));
    println("public " + this.grammar.getClassName() + "()");
    println("{");
    this.tabs += 1;
    println("tokenNames = tokenNames_;");
    this.tabs -= 1;
    println("}");
    println("");
    this.astTypes = new java.util.Vector();
    Object localObject2 = this.grammar.rules.elements();
    int i = 0;
    String str2 = "";
    while (((Enumeration)localObject2).hasMoreElements())
    {
      GrammarSymbol localGrammarSymbol = (GrammarSymbol)((Enumeration)localObject2).nextElement();
      if ((localGrammarSymbol instanceof RuleSymbol))
      {
        RuleSymbol localRuleSymbol = (RuleSymbol)localGrammarSymbol;
        genRule(localRuleSymbol, localRuleSymbol.references.size() == 0, i++, this.grammar.tokenManager);
      }
      exitIfError();
    }
    if (this.usingCustomAST)
    {
      println("public new " + this.labeledElementASTType + " getAST()");
      println("{");
      this.tabs += 1;
      println("return (" + this.labeledElementASTType + ") returnAST;");
      this.tabs -= 1;
      println("}");
      println("");
    }
    genInitFactory(this.grammar);
    genTokenStrings();
    genBitsets(this.bitsetsUsed, this.grammar.tokenManager.maxTokenType());
    this.tabs -= 1;
    println("}");
    println("");
    this.tabs -= 1;
    if (nameSpace != null)
      nameSpace.emitClosures(this.currentOutput);
    this.currentOutput.close();
    this.currentOutput = null;
  }

  protected void genCases(BitSet paramBitSet)
  {
    if (this.DEBUG_CODE_GENERATOR)
      System.out.println("genCases(" + paramBitSet + ")");
    int[] arrayOfInt = paramBitSet.toArray();
    int i = (this.grammar instanceof LexerGrammar) ? 4 : 1;
    int j = 1;
    int k = 1;
    for (int m = 0; m < arrayOfInt.length; m++)
    {
      if (j == 1)
        print("");
      else
        _print("  ");
      _print("case " + getValueString(arrayOfInt[m]) + ":");
      if (j == i)
      {
        _println("");
        k = 1;
        j = 1;
      }
      else
      {
        j++;
        k = 0;
      }
    }
    if (k == 0)
      _println("");
  }

  public CSharpBlockFinishingInfo genCommonBlock(AlternativeBlock paramAlternativeBlock, boolean paramBoolean)
  {
    int i = 0;
    int j = 0;
    int k = 0;
    CSharpBlockFinishingInfo localCSharpBlockFinishingInfo = new CSharpBlockFinishingInfo();
    if (this.DEBUG_CODE_GENERATOR)
      System.out.println("genCommonBlock(" + paramAlternativeBlock + ")");
    boolean bool1 = this.genAST;
    this.genAST = ((this.genAST) && (paramAlternativeBlock.getAutoGen()));
    boolean bool2 = this.saveText;
    this.saveText = ((this.saveText) && (paramAlternativeBlock.getAutoGen()));
    Object localObject1;
    if ((paramAlternativeBlock.not) && (this.analyzer.subruleCanBeInverted(paramAlternativeBlock, this.grammar instanceof LexerGrammar)))
    {
      if (this.DEBUG_CODE_GENERATOR)
        System.out.println("special case: ~(subrule)");
      localObject1 = this.analyzer.look(1, paramAlternativeBlock);
      if ((paramAlternativeBlock.getLabel() != null) && (this.syntacticPredLevel == 0))
        println(paramAlternativeBlock.getLabel() + " = " + this.lt1Value + ";");
      genElementAST(paramAlternativeBlock);
      String str1 = "";
      if ((this.grammar instanceof TreeWalkerGrammar))
        if (this.usingCustomAST)
          str1 = "(AST)_t,";
        else
          str1 = "_t,";
      println("match(" + str1 + getBitsetName(markBitsetForGen(((Lookahead)localObject1).fset)) + ");");
      if ((this.grammar instanceof TreeWalkerGrammar))
        println("_t = _t.getNextSibling();");
      return localCSharpBlockFinishingInfo;
    }
    if (paramAlternativeBlock.getAlternatives().size() == 1)
    {
      localObject1 = paramAlternativeBlock.getAlternativeAt(0);
      if (((Alternative)localObject1).synPred != null)
        this.antlrTool.warning("Syntactic predicate superfluous for single alternative", this.grammar.getFilename(), paramAlternativeBlock.getAlternativeAt(0).synPred.getLine(), paramAlternativeBlock.getAlternativeAt(0).synPred.getColumn());
      if (paramBoolean)
      {
        if (((Alternative)localObject1).semPred != null)
          genSemPred(((Alternative)localObject1).semPred, paramAlternativeBlock.line);
        genAlt((Alternative)localObject1, paramAlternativeBlock);
        return localCSharpBlockFinishingInfo;
      }
    }
    int m = 0;
    for (int n = 0; n < paramAlternativeBlock.getAlternatives().size(); n++)
    {
      Alternative localAlternative1 = paramAlternativeBlock.getAlternativeAt(n);
      if (!suitableForCaseExpression(localAlternative1))
        continue;
      m++;
    }
    Object localObject2;
    if (m >= this.makeSwitchThreshold)
    {
      String str2 = lookaheadString(1);
      j = 1;
      if ((this.grammar instanceof TreeWalkerGrammar))
      {
        println("if (null == _t)");
        this.tabs += 1;
        println("_t = ASTNULL;");
        this.tabs -= 1;
      }
      println("switch ( " + str2 + " )");
      println("{");
      this.blockNestingLevel += 1;
      for (i2 = 0; i2 < paramAlternativeBlock.alternatives.size(); i2++)
      {
        Alternative localAlternative2 = paramAlternativeBlock.getAlternativeAt(i2);
        if (!suitableForCaseExpression(localAlternative2))
          continue;
        localObject2 = localAlternative2.cache[1];
        if ((((Lookahead)localObject2).fset.degree() == 0) && (!((Lookahead)localObject2).containsEpsilon()))
        {
          this.antlrTool.warning("Alternate omitted due to empty prediction set", this.grammar.getFilename(), localAlternative2.head.getLine(), localAlternative2.head.getColumn());
        }
        else
        {
          genCases(((Lookahead)localObject2).fset);
          println("{");
          this.tabs += 1;
          this.blockNestingLevel += 1;
          genAlt(localAlternative2, paramAlternativeBlock);
          println("break;");
          if (this.blockNestingLevel-- == this.saveIndexCreateLevel)
            this.saveIndexCreateLevel = 0;
          this.tabs -= 1;
          println("}");
        }
      }
      println("default:");
      this.tabs += 1;
    }
    int i1 = (this.grammar instanceof LexerGrammar) ? this.grammar.maxk : 0;
    for (int i2 = i1; i2 >= 0; i2--)
    {
      if (this.DEBUG_CODE_GENERATOR)
        System.out.println("checking depth " + i2);
      for (i3 = 0; i3 < paramAlternativeBlock.alternatives.size(); i3++)
      {
        localObject2 = paramAlternativeBlock.getAlternativeAt(i3);
        if (this.DEBUG_CODE_GENERATOR)
          System.out.println("genAlt: " + i3);
        if ((j != 0) && (suitableForCaseExpression((Alternative)localObject2)))
        {
          if (!this.DEBUG_CODE_GENERATOR)
            continue;
          System.out.println("ignoring alt because it was in the switch");
        }
        else
        {
          boolean bool3 = false;
          String str4;
          if ((this.grammar instanceof LexerGrammar))
          {
            int i4 = ((Alternative)localObject2).lookaheadDepth;
            if (i4 == 2147483647);
            for (i4 = this.grammar.maxk; (i4 >= 1) && (localObject2.cache[i4].containsEpsilon()); i4--);
            if (i4 != i2)
            {
              if (!this.DEBUG_CODE_GENERATOR)
                continue;
              System.out.println("ignoring alt because effectiveDepth!=altDepth;" + i4 + "!=" + i2);
              continue;
            }
            bool3 = lookaheadIsEmpty((Alternative)localObject2, i4);
            str4 = getLookaheadTestExpression((Alternative)localObject2, i4);
          }
          else
          {
            bool3 = lookaheadIsEmpty((Alternative)localObject2, this.grammar.maxk);
            str4 = getLookaheadTestExpression((Alternative)localObject2, this.grammar.maxk);
          }
          if ((localObject2.cache[1].fset.degree() > 127) && (suitableForCaseExpression((Alternative)localObject2)))
          {
            if (i == 0)
            {
              println("if " + str4);
              println("{");
            }
            else
            {
              println("else if " + str4);
              println("{");
            }
          }
          else if ((bool3) && (((Alternative)localObject2).semPred == null) && (((Alternative)localObject2).synPred == null))
          {
            if (i == 0)
              println("{");
            else
              println("else {");
            localCSharpBlockFinishingInfo.needAnErrorClause = false;
          }
          else
          {
            if (((Alternative)localObject2).semPred != null)
            {
              ActionTransInfo localActionTransInfo = new ActionTransInfo();
              String str5 = processActionForSpecialSymbols(((Alternative)localObject2).semPred, paramAlternativeBlock.line, this.currentRule, localActionTransInfo);
              if ((((this.grammar instanceof ParserGrammar)) || ((this.grammar instanceof LexerGrammar))) && (this.grammar.debuggingOutput))
                str4 = "(" + str4 + "&& fireSemanticPredicateEvaluated(antlr.debug.SemanticPredicateEventArgs.PREDICTING," + addSemPred(this.charFormatter.escapeString(str5)) + "," + str5 + "))";
              else
                str4 = "(" + str4 + "&&(" + str5 + "))";
            }
            if (i > 0)
            {
              if (((Alternative)localObject2).synPred != null)
              {
                println("else {");
                this.tabs += 1;
                this.blockNestingLevel += 1;
                genSynPred(((Alternative)localObject2).synPred, str4);
                k++;
              }
              else
              {
                println("else if " + str4 + " {");
              }
            }
            else if (((Alternative)localObject2).synPred != null)
            {
              genSynPred(((Alternative)localObject2).synPred, str4);
            }
            else
            {
              if ((this.grammar instanceof TreeWalkerGrammar))
              {
                println("if (_t == null)");
                this.tabs += 1;
                println("_t = ASTNULL;");
                this.tabs -= 1;
              }
              println("if " + str4);
              println("{");
            }
          }
          this.blockNestingLevel += 1;
          i++;
          this.tabs += 1;
          genAlt((Alternative)localObject2, paramAlternativeBlock);
          this.tabs -= 1;
          if (this.blockNestingLevel-- == this.saveIndexCreateLevel)
            this.saveIndexCreateLevel = 0;
          println("}");
        }
      }
    }
    String str3 = "";
    for (int i3 = 1; i3 <= k; i3++)
    {
      str3 = str3 + "}";
      if (this.blockNestingLevel-- != this.saveIndexCreateLevel)
        continue;
      this.saveIndexCreateLevel = 0;
    }
    this.genAST = bool1;
    this.saveText = bool2;
    if (j != 0)
    {
      this.tabs -= 1;
      localCSharpBlockFinishingInfo.postscript = (str3 + "break; }");
      if (this.blockNestingLevel-- == this.saveIndexCreateLevel)
        this.saveIndexCreateLevel = 0;
      localCSharpBlockFinishingInfo.generatedSwitch = true;
      localCSharpBlockFinishingInfo.generatedAnIf = (i > 0);
    }
    else
    {
      localCSharpBlockFinishingInfo.postscript = str3;
      localCSharpBlockFinishingInfo.generatedSwitch = false;
      localCSharpBlockFinishingInfo.generatedAnIf = (i > 0);
    }
    return (CSharpBlockFinishingInfo)(CSharpBlockFinishingInfo)localCSharpBlockFinishingInfo;
  }

  private static boolean suitableForCaseExpression(Alternative paramAlternative)
  {
    return (paramAlternative.lookaheadDepth == 1) && (paramAlternative.semPred == null) && (!paramAlternative.cache[1].containsEpsilon()) && (paramAlternative.cache[1].fset.degree() <= 127);
  }

  private void genElementAST(AlternativeElement paramAlternativeElement)
  {
    if (((this.grammar instanceof TreeWalkerGrammar)) && (!this.grammar.buildAST))
    {
      if (paramAlternativeElement.getLabel() == null)
      {
        String str1 = this.lt1Value;
        String str2 = "tmp" + this.astVarNumber + "_AST";
        this.astVarNumber += 1;
        mapTreeVariable(paramAlternativeElement, str2);
        println(this.labeledElementASTType + " " + str2 + "_in = " + str1 + ";");
      }
      return;
    }
    if ((this.grammar.buildAST) && (this.syntacticPredLevel == 0))
    {
      int i = (this.genAST) && ((paramAlternativeElement.getLabel() != null) || (paramAlternativeElement.getAutoGenType() != 3)) ? 1 : 0;
      if ((paramAlternativeElement.getAutoGenType() != 3) && ((paramAlternativeElement instanceof TokenRefElement)))
        i = 1;
      int j = (this.grammar.hasSyntacticPredicate) && (i != 0) ? 1 : 0;
      String str3;
      String str4;
      if (paramAlternativeElement.getLabel() != null)
      {
        str3 = paramAlternativeElement.getLabel();
        str4 = paramAlternativeElement.getLabel();
      }
      else
      {
        str3 = this.lt1Value;
        str4 = "tmp" + this.astVarNumber;
        this.astVarNumber += 1;
      }
      if (i != 0)
        if ((paramAlternativeElement instanceof GrammarAtom))
        {
          localObject = (GrammarAtom)paramAlternativeElement;
          if (((GrammarAtom)localObject).getASTNodeType() != null)
            genASTDeclaration(paramAlternativeElement, str4, ((GrammarAtom)localObject).getASTNodeType());
          else
            genASTDeclaration(paramAlternativeElement, str4, this.labeledElementASTType);
        }
        else
        {
          genASTDeclaration(paramAlternativeElement, str4, this.labeledElementASTType);
        }
      Object localObject = str4 + "_AST";
      mapTreeVariable(paramAlternativeElement, (String)localObject);
      if ((this.grammar instanceof TreeWalkerGrammar))
        println(this.labeledElementASTType + " " + (String)localObject + "_in = null;");
      if ((j == 0) || (paramAlternativeElement.getLabel() != null))
        if ((paramAlternativeElement instanceof GrammarAtom))
          println((String)localObject + " = " + getASTCreateString((GrammarAtom)paramAlternativeElement, str3) + ";");
        else
          println((String)localObject + " = " + getASTCreateString(str3) + ";");
      if ((paramAlternativeElement.getLabel() == null) && (i != 0))
      {
        str3 = this.lt1Value;
        if ((paramAlternativeElement instanceof GrammarAtom))
          println((String)localObject + " = " + getASTCreateString((GrammarAtom)paramAlternativeElement, str3) + ";");
        else
          println((String)localObject + " = " + getASTCreateString(str3) + ";");
        if ((this.grammar instanceof TreeWalkerGrammar))
          println((String)localObject + "_in = " + str3 + ";");
      }
      if (this.genAST)
        switch (paramAlternativeElement.getAutoGenType())
        {
        case 1:
          if ((this.usingCustomAST) || (((paramAlternativeElement instanceof GrammarAtom)) && (((GrammarAtom)paramAlternativeElement).getASTNodeType() != null)))
            println("astFactory.addASTChild(ref currentAST, (AST)" + (String)localObject + ");");
          else
            println("astFactory.addASTChild(ref currentAST, " + (String)localObject + ");");
          break;
        case 2:
          if ((this.usingCustomAST) || (((paramAlternativeElement instanceof GrammarAtom)) && (((GrammarAtom)paramAlternativeElement).getASTNodeType() != null)))
            println("astFactory.makeASTRoot(ref currentAST, (AST)" + (String)localObject + ");");
          else
            println("astFactory.makeASTRoot(ref currentAST, " + (String)localObject + ");");
          break;
        }
      if (j == 0);
    }
  }

  private void genErrorCatchForElement(AlternativeElement paramAlternativeElement)
  {
    if (paramAlternativeElement.getLabel() == null)
      return;
    String str = paramAlternativeElement.enclosingRuleName;
    if ((this.grammar instanceof LexerGrammar))
      str = CodeGenerator.encodeLexerRuleName(paramAlternativeElement.enclosingRuleName);
    RuleSymbol localRuleSymbol = (RuleSymbol)this.grammar.getSymbol(str);
    if (localRuleSymbol == null)
      this.antlrTool.panic("Enclosing rule not found!");
    ExceptionSpec localExceptionSpec = localRuleSymbol.block.findExceptionSpec(paramAlternativeElement.getLabel());
    if (localExceptionSpec != null)
    {
      this.tabs -= 1;
      println("}");
      genErrorHandler(localExceptionSpec);
    }
  }

  private void genErrorHandler(ExceptionSpec paramExceptionSpec)
  {
    for (int i = 0; i < paramExceptionSpec.handlers.size(); i++)
    {
      ExceptionHandler localExceptionHandler = (ExceptionHandler)paramExceptionSpec.handlers.elementAt(i);
      println("catch (" + localExceptionHandler.exceptionTypeAndName.getText() + ")");
      println("{");
      this.tabs += 1;
      if (this.grammar.hasSyntacticPredicate)
      {
        println("if (0 == inputState.guessing)");
        println("{");
        this.tabs += 1;
      }
      ActionTransInfo localActionTransInfo = new ActionTransInfo();
      printAction(processActionForSpecialSymbols(localExceptionHandler.action.getText(), localExceptionHandler.action.getLine(), this.currentRule, localActionTransInfo));
      if (this.grammar.hasSyntacticPredicate)
      {
        this.tabs -= 1;
        println("}");
        println("else");
        println("{");
        this.tabs += 1;
        println("throw;");
        this.tabs -= 1;
        println("}");
      }
      this.tabs -= 1;
      println("}");
    }
  }

  private void genErrorTryForElement(AlternativeElement paramAlternativeElement)
  {
    if (paramAlternativeElement.getLabel() == null)
      return;
    String str = paramAlternativeElement.enclosingRuleName;
    if ((this.grammar instanceof LexerGrammar))
      str = CodeGenerator.encodeLexerRuleName(paramAlternativeElement.enclosingRuleName);
    RuleSymbol localRuleSymbol = (RuleSymbol)this.grammar.getSymbol(str);
    if (localRuleSymbol == null)
      this.antlrTool.panic("Enclosing rule not found!");
    ExceptionSpec localExceptionSpec = localRuleSymbol.block.findExceptionSpec(paramAlternativeElement.getLabel());
    if (localExceptionSpec != null)
    {
      println("try   // for error handling");
      println("{");
      this.tabs += 1;
    }
  }

  protected void genASTDeclaration(AlternativeElement paramAlternativeElement)
  {
    genASTDeclaration(paramAlternativeElement, this.labeledElementASTType);
  }

  protected void genASTDeclaration(AlternativeElement paramAlternativeElement, String paramString)
  {
    genASTDeclaration(paramAlternativeElement, paramAlternativeElement.getLabel(), paramString);
  }

  protected void genASTDeclaration(AlternativeElement paramAlternativeElement, String paramString1, String paramString2)
  {
    if (this.declaredASTVariables.contains(paramAlternativeElement))
      return;
    println(paramString2 + " " + paramString1 + "_AST = null;");
    this.declaredASTVariables.put(paramAlternativeElement, paramAlternativeElement);
  }

  protected void genHeader()
  {
    println("// $ANTLR " + Tool.version + ": " + "\"" + this.antlrTool.fileMinusPath(this.antlrTool.grammarFile) + "\"" + " -> " + "\"" + this.grammar.getClassName() + ".cs\"$");
  }

  private void genLiteralsTest()
  {
    println("_ttype = testLiteralsTable(_ttype);");
  }

  private void genLiteralsTestForPartialToken()
  {
    println("_ttype = testLiteralsTable(text.ToString(_begin, text.Length-_begin), _ttype);");
  }

  protected void genMatch(BitSet paramBitSet)
  {
  }

  protected void genMatch(GrammarAtom paramGrammarAtom)
  {
    if ((paramGrammarAtom instanceof StringLiteralElement))
    {
      if ((this.grammar instanceof LexerGrammar))
        genMatchUsingAtomText(paramGrammarAtom);
      else
        genMatchUsingAtomTokenType(paramGrammarAtom);
    }
    else if ((paramGrammarAtom instanceof CharLiteralElement))
    {
      if ((this.grammar instanceof LexerGrammar))
        genMatchUsingAtomText(paramGrammarAtom);
      else
        this.antlrTool.error("cannot ref character literals in grammar: " + paramGrammarAtom);
    }
    else if ((paramGrammarAtom instanceof TokenRefElement))
      genMatchUsingAtomText(paramGrammarAtom);
    else if ((paramGrammarAtom instanceof WildcardElement))
      gen((WildcardElement)paramGrammarAtom);
  }

  protected void genMatchUsingAtomText(GrammarAtom paramGrammarAtom)
  {
    String str = "";
    if ((this.grammar instanceof TreeWalkerGrammar))
      if (this.usingCustomAST)
        str = "(AST)_t,";
      else
        str = "_t,";
    if (((this.grammar instanceof LexerGrammar)) && ((!this.saveText) || (paramGrammarAtom.getAutoGenType() == 3)))
    {
      declareSaveIndexVariableIfNeeded();
      println("_saveIndex = text.Length;");
    }
    print(paramGrammarAtom.not ? "matchNot(" : "match(");
    _print(str);
    if (paramGrammarAtom.atomText.equals("EOF"))
      _print("Token.EOF_TYPE");
    else
      _print(paramGrammarAtom.atomText);
    _println(");");
    if (((this.grammar instanceof LexerGrammar)) && ((!this.saveText) || (paramGrammarAtom.getAutoGenType() == 3)))
    {
      declareSaveIndexVariableIfNeeded();
      println("text.Length = _saveIndex;");
    }
  }

  protected void genMatchUsingAtomTokenType(GrammarAtom paramGrammarAtom)
  {
    String str1 = "";
    if ((this.grammar instanceof TreeWalkerGrammar))
      if (this.usingCustomAST)
        str1 = "(AST)_t,";
      else
        str1 = "_t,";
    Object localObject = null;
    String str2 = str1 + getValueString(paramGrammarAtom.getType());
    println((paramGrammarAtom.not ? "matchNot(" : "match(") + str2 + ");");
  }

  public void genNextToken()
  {
    int i = 0;
    for (int j = 0; j < this.grammar.rules.size(); j++)
    {
      localRuleSymbol1 = (RuleSymbol)this.grammar.rules.elementAt(j);
      if ((!localRuleSymbol1.isDefined()) || (!localRuleSymbol1.access.equals("public")))
        continue;
      i = 1;
      break;
    }
    if (i == 0)
    {
      println("");
      println("override public IToken nextToken()\t\t\t//throws TokenStreamException");
      println("{");
      this.tabs += 1;
      println("try");
      println("{");
      this.tabs += 1;
      println("uponEOF();");
      this.tabs -= 1;
      println("}");
      println("catch(CharStreamIOException csioe)");
      println("{");
      this.tabs += 1;
      println("throw new TokenStreamIOException(csioe.io);");
      this.tabs -= 1;
      println("}");
      println("catch(CharStreamException cse)");
      println("{");
      this.tabs += 1;
      println("throw new TokenStreamException(cse.Message);");
      this.tabs -= 1;
      println("}");
      println("return new CommonToken(Token.EOF_TYPE, \"\");");
      this.tabs -= 1;
      println("}");
      println("");
      return;
    }
    RuleBlock localRuleBlock = MakeGrammar.createNextTokenRule(this.grammar, this.grammar.rules, "nextToken");
    RuleSymbol localRuleSymbol1 = new RuleSymbol("mnextToken");
    localRuleSymbol1.setDefined();
    localRuleSymbol1.setBlock(localRuleBlock);
    localRuleSymbol1.access = "private";
    this.grammar.define(localRuleSymbol1);
    boolean bool = this.grammar.theLLkAnalyzer.deterministic(localRuleBlock);
    String str1 = null;
    if (((LexerGrammar)this.grammar).filterMode)
      str1 = ((LexerGrammar)this.grammar).filterRule;
    println("");
    println("override public IToken nextToken()\t\t\t//throws TokenStreamException");
    println("{");
    this.tabs += 1;
    this.blockNestingLevel = 1;
    this.saveIndexCreateLevel = 0;
    println("IToken theRetToken = null;");
    _println("tryAgain:");
    println("for (;;)");
    println("{");
    this.tabs += 1;
    println("IToken _token = null;");
    println("int _ttype = Token.INVALID_TYPE;");
    if (((LexerGrammar)this.grammar).filterMode)
    {
      println("setCommitToPath(false);");
      if (str1 != null)
      {
        if (!this.grammar.isDefined(CodeGenerator.encodeLexerRuleName(str1)))
        {
          this.grammar.antlrTool.error("Filter rule " + str1 + " does not exist in this lexer");
        }
        else
        {
          RuleSymbol localRuleSymbol2 = (RuleSymbol)this.grammar.getSymbol(CodeGenerator.encodeLexerRuleName(str1));
          if (!localRuleSymbol2.isDefined())
            this.grammar.antlrTool.error("Filter rule " + str1 + " does not exist in this lexer");
          else if (localRuleSymbol2.access.equals("public"))
            this.grammar.antlrTool.error("Filter rule " + str1 + " must be protected");
        }
        println("int _m;");
        println("_m = mark();");
      }
    }
    println("resetText();");
    println("try     // for char stream error handling");
    println("{");
    this.tabs += 1;
    println("try     // for lexical error handling");
    println("{");
    this.tabs += 1;
    for (int k = 0; k < localRuleBlock.getAlternatives().size(); k++)
    {
      localObject1 = localRuleBlock.getAlternativeAt(k);
      if (!localObject1.cache[1].containsEpsilon())
        continue;
      localObject2 = (RuleRefElement)((Alternative)localObject1).head;
      String str3 = CodeGenerator.decodeLexerRuleName(((RuleRefElement)localObject2).targetRule);
      this.antlrTool.warning("public lexical rule " + str3 + " is optional (can match \"nothing\")");
    }
    String str2 = System.getProperty("line.separator");
    Object localObject1 = genCommonBlock(localRuleBlock, false);
    Object localObject2 = "if (cached_LA1==EOF_CHAR) { uponEOF(); returnToken_ = makeToken(Token.EOF_TYPE); }";
    localObject2 = (String)localObject2 + str2 + "\t\t\t\t";
    if (((LexerGrammar)this.grammar).filterMode)
    {
      if (str1 == null)
      {
        localObject2 = (String)localObject2 + "\t\t\t\telse";
        localObject2 = (String)localObject2 + "\t\t\t\t{";
        localObject2 = (String)localObject2 + "\t\t\t\t\tconsume();";
        localObject2 = (String)localObject2 + "\t\t\t\t\tgoto tryAgain;";
        localObject2 = (String)localObject2 + "\t\t\t\t}";
      }
      else
      {
        localObject2 = (String)localObject2 + "\t\t\t\t\telse" + str2 + "\t\t\t\t\t{" + str2 + "\t\t\t\t\tcommit();" + str2 + "\t\t\t\t\ttry {m" + str1 + "(false);}" + str2 + "\t\t\t\t\tcatch(RecognitionException e)" + str2 + "\t\t\t\t\t{" + str2 + "\t\t\t\t\t\t// catastrophic failure" + str2 + "\t\t\t\t\t\treportError(e);" + str2 + "\t\t\t\t\t\tconsume();" + str2 + "\t\t\t\t\t}" + str2 + "\t\t\t\t\tgoto tryAgain;" + str2 + "\t\t\t\t}";
      }
    }
    else
      localObject2 = (String)localObject2 + "else {" + this.throwNoViable + "}";
    genBlockFinish((CSharpBlockFinishingInfo)localObject1, (String)localObject2);
    if ((((LexerGrammar)this.grammar).filterMode) && (str1 != null))
      println("commit();");
    println("if ( null==returnToken_ ) goto tryAgain; // found SKIP token");
    println("_ttype = returnToken_.Type;");
    if (((LexerGrammar)this.grammar).getTestLiterals())
      genLiteralsTest();
    println("returnToken_.Type = _ttype;");
    println("return returnToken_;");
    this.tabs -= 1;
    println("}");
    println("catch (RecognitionException e) {");
    this.tabs += 1;
    if (((LexerGrammar)this.grammar).filterMode)
      if (str1 == null)
      {
        println("if (!getCommitToPath())");
        println("{");
        this.tabs += 1;
        println("consume();");
        println("goto tryAgain;");
        this.tabs -= 1;
        println("}");
      }
      else
      {
        println("if (!getCommitToPath())");
        println("{");
        this.tabs += 1;
        println("rewind(_m);");
        println("resetText();");
        println("try {m" + str1 + "(false);}");
        println("catch(RecognitionException ee) {");
        println("\t// horrendous failure: error in filter rule");
        println("\treportError(ee);");
        println("\tconsume();");
        println("}");
        this.tabs -= 1;
        println("}");
        println("else");
      }
    if (localRuleBlock.getDefaultErrorHandler())
    {
      println("{");
      this.tabs += 1;
      println("reportError(e);");
      println("consume();");
      this.tabs -= 1;
      println("}");
    }
    else
    {
      this.tabs += 1;
      println("throw new TokenStreamRecognitionException(e);");
      this.tabs -= 1;
    }
    this.tabs -= 1;
    println("}");
    this.tabs -= 1;
    println("}");
    println("catch (CharStreamException cse) {");
    println("\tif ( cse is CharStreamIOException ) {");
    println("\t\tthrow new TokenStreamIOException(((CharStreamIOException)cse).io);");
    println("\t}");
    println("\telse {");
    println("\t\tthrow new TokenStreamException(cse.Message);");
    println("\t}");
    println("}");
    this.tabs -= 1;
    println("}");
    this.tabs -= 1;
    println("}");
    println("");
  }

  public void genRule(RuleSymbol paramRuleSymbol, boolean paramBoolean, int paramInt, TokenManager paramTokenManager)
  {
    this.tabs = 1;
    if (this.DEBUG_CODE_GENERATOR)
      System.out.println("genRule(" + paramRuleSymbol.getId() + ")");
    if (!paramRuleSymbol.isDefined())
    {
      this.antlrTool.error("undefined rule: " + paramRuleSymbol.getId());
      return;
    }
    RuleBlock localRuleBlock = paramRuleSymbol.getBlock();
    this.currentRule = localRuleBlock;
    this.currentASTResult = paramRuleSymbol.getId();
    this.declaredASTVariables.clear();
    boolean bool1 = this.genAST;
    this.genAST = ((this.genAST) && (localRuleBlock.getAutoGen()));
    this.saveText = localRuleBlock.getAutoGen();
    if (paramRuleSymbol.comment != null)
      _println(paramRuleSymbol.comment);
    print(paramRuleSymbol.access + " ");
    if (localRuleBlock.returnAction != null)
      _print(extractTypeOfAction(localRuleBlock.returnAction, localRuleBlock.getLine(), localRuleBlock.getColumn()) + " ");
    else
      _print("void ");
    _print(paramRuleSymbol.getId() + "(");
    _print(this.commonExtraParams);
    if ((this.commonExtraParams.length() != 0) && (localRuleBlock.argAction != null))
      _print(",");
    if (localRuleBlock.argAction != null)
    {
      _println("");
      this.tabs += 1;
      println(localRuleBlock.argAction);
      this.tabs -= 1;
      print(")");
    }
    else
    {
      _print(")");
    }
    _print(" //throws " + this.exceptionThrown);
    if ((this.grammar instanceof ParserGrammar))
      _print(", TokenStreamException");
    else if ((this.grammar instanceof LexerGrammar))
      _print(", CharStreamException, TokenStreamException");
    if (localRuleBlock.throwsSpec != null)
      if ((this.grammar instanceof LexerGrammar))
        this.antlrTool.error("user-defined throws spec not allowed (yet) for lexer rule " + localRuleBlock.ruleName);
      else
        _print(", " + localRuleBlock.throwsSpec);
    _println("");
    _println("{");
    this.tabs += 1;
    if (localRuleBlock.returnAction != null)
      println(localRuleBlock.returnAction + ";");
    println(this.commonLocalVars);
    if (this.grammar.traceRules)
      if ((this.grammar instanceof TreeWalkerGrammar))
      {
        if (this.usingCustomAST)
          println("traceIn(\"" + paramRuleSymbol.getId() + "\",(AST)_t);");
        else
          println("traceIn(\"" + paramRuleSymbol.getId() + "\",_t);");
      }
      else
        println("traceIn(\"" + paramRuleSymbol.getId() + "\");");
    if ((this.grammar instanceof LexerGrammar))
    {
      if (paramRuleSymbol.getId().equals("mEOF"))
        println("_ttype = Token.EOF_TYPE;");
      else
        println("_ttype = " + paramRuleSymbol.getId().substring(1) + ";");
      this.blockNestingLevel = 1;
      this.saveIndexCreateLevel = 0;
    }
    if (this.grammar.debuggingOutput)
      if ((this.grammar instanceof ParserGrammar))
        println("fireEnterRule(" + paramInt + ",0);");
      else if ((this.grammar instanceof LexerGrammar))
        println("fireEnterRule(" + paramInt + ",_ttype);");
    if ((this.grammar.debuggingOutput) || (this.grammar.traceRules))
    {
      println("try { // debugging");
      this.tabs += 1;
    }
    if ((this.grammar instanceof TreeWalkerGrammar))
      println(this.labeledElementASTType + " " + paramRuleSymbol.getId() + "_AST_in = (" + this.labeledElementASTType + ")_t;");
    if (this.grammar.buildAST)
    {
      println("returnAST = null;");
      println("ASTPair currentAST = new ASTPair();");
      println(this.labeledElementASTType + " " + paramRuleSymbol.getId() + "_AST = null;");
    }
    genBlockPreamble(localRuleBlock);
    genBlockInitAction(localRuleBlock);
    println("");
    ExceptionSpec localExceptionSpec = localRuleBlock.findExceptionSpec("");
    if ((localExceptionSpec != null) || (localRuleBlock.getDefaultErrorHandler()))
    {
      println("try {      // for error handling");
      this.tabs += 1;
    }
    Object localObject;
    if (localRuleBlock.alternatives.size() == 1)
    {
      Alternative localAlternative = localRuleBlock.getAlternativeAt(0);
      localObject = localAlternative.semPred;
      if (localObject != null)
        genSemPred((String)localObject, this.currentRule.line);
      if (localAlternative.synPred != null)
        this.antlrTool.warning("Syntactic predicate ignored for single alternative", this.grammar.getFilename(), localAlternative.synPred.getLine(), localAlternative.synPred.getColumn());
      genAlt(localAlternative, localRuleBlock);
    }
    else
    {
      boolean bool2 = this.grammar.theLLkAnalyzer.deterministic(localRuleBlock);
      localObject = genCommonBlock(localRuleBlock, false);
      genBlockFinish((CSharpBlockFinishingInfo)localObject, this.throwNoViable);
    }
    if ((localExceptionSpec != null) || (localRuleBlock.getDefaultErrorHandler()))
    {
      this.tabs -= 1;
      println("}");
    }
    if (localExceptionSpec != null)
    {
      genErrorHandler(localExceptionSpec);
    }
    else if (localRuleBlock.getDefaultErrorHandler())
    {
      println("catch (" + this.exceptionThrown + " ex)");
      println("{");
      this.tabs += 1;
      if (this.grammar.hasSyntacticPredicate)
      {
        println("if (0 == inputState.guessing)");
        println("{");
        this.tabs += 1;
      }
      println("reportError(ex);");
      if (!(this.grammar instanceof TreeWalkerGrammar))
      {
        Lookahead localLookahead = this.grammar.theLLkAnalyzer.FOLLOW(1, localRuleBlock.endNode);
        localObject = getBitsetName(markBitsetForGen(localLookahead.fset));
        println("recover(ex," + (String)localObject + ");");
      }
      else
      {
        println("if (null != _t)");
        println("{");
        this.tabs += 1;
        println("_t = _t.getNextSibling();");
        this.tabs -= 1;
        println("}");
      }
      if (this.grammar.hasSyntacticPredicate)
      {
        this.tabs -= 1;
        println("}");
        println("else");
        println("{");
        this.tabs += 1;
        println("throw ex;");
        this.tabs -= 1;
        println("}");
      }
      this.tabs -= 1;
      println("}");
    }
    if (this.grammar.buildAST)
      println("returnAST = " + paramRuleSymbol.getId() + "_AST;");
    if ((this.grammar instanceof TreeWalkerGrammar))
      println("retTree_ = _t;");
    if (localRuleBlock.getTestLiterals())
      if (paramRuleSymbol.access.equals("protected"))
        genLiteralsTestForPartialToken();
      else
        genLiteralsTest();
    if ((this.grammar instanceof LexerGrammar))
    {
      println("if (_createToken && (null == _token) && (_ttype != Token.SKIP))");
      println("{");
      this.tabs += 1;
      println("_token = makeToken(_ttype);");
      println("_token.setText(text.ToString(_begin, text.Length-_begin));");
      this.tabs -= 1;
      println("}");
      println("returnToken_ = _token;");
    }
    if (localRuleBlock.returnAction != null)
      println("return " + extractIdOfAction(localRuleBlock.returnAction, localRuleBlock.getLine(), localRuleBlock.getColumn()) + ";");
    if ((this.grammar.debuggingOutput) || (this.grammar.traceRules))
    {
      this.tabs -= 1;
      println("}");
      println("finally");
      println("{ // debugging");
      this.tabs += 1;
      if (this.grammar.debuggingOutput)
        if ((this.grammar instanceof ParserGrammar))
          println("fireExitRule(" + paramInt + ",0);");
        else if ((this.grammar instanceof LexerGrammar))
          println("fireExitRule(" + paramInt + ",_ttype);");
      if (this.grammar.traceRules)
        if ((this.grammar instanceof TreeWalkerGrammar))
          println("traceOut(\"" + paramRuleSymbol.getId() + "\",_t);");
        else
          println("traceOut(\"" + paramRuleSymbol.getId() + "\");");
      this.tabs -= 1;
      println("}");
    }
    this.tabs -= 1;
    println("}");
    println("");
    this.genAST = bool1;
  }

  private void GenRuleInvocation(RuleRefElement paramRuleRefElement)
  {
    _print(paramRuleRefElement.targetRule + "(");
    if ((this.grammar instanceof LexerGrammar))
    {
      if (paramRuleRefElement.getLabel() != null)
        _print("true");
      else
        _print("false");
      if ((this.commonExtraArgs.length() != 0) || (paramRuleRefElement.args != null))
        _print(",");
    }
    _print(this.commonExtraArgs);
    if ((this.commonExtraArgs.length() != 0) && (paramRuleRefElement.args != null))
      _print(",");
    RuleSymbol localRuleSymbol = (RuleSymbol)this.grammar.getSymbol(paramRuleRefElement.targetRule);
    if (paramRuleRefElement.args != null)
    {
      ActionTransInfo localActionTransInfo = new ActionTransInfo();
      String str = processActionForSpecialSymbols(paramRuleRefElement.args, 0, this.currentRule, localActionTransInfo);
      if ((localActionTransInfo.assignToRoot) || (localActionTransInfo.refRuleRoot != null))
        this.antlrTool.error("Arguments of rule reference '" + paramRuleRefElement.targetRule + "' cannot set or ref #" + this.currentRule.getRuleName(), this.grammar.getFilename(), paramRuleRefElement.getLine(), paramRuleRefElement.getColumn());
      _print(str);
      if (localRuleSymbol.block.argAction == null)
        this.antlrTool.warning("Rule '" + paramRuleRefElement.targetRule + "' accepts no arguments", this.grammar.getFilename(), paramRuleRefElement.getLine(), paramRuleRefElement.getColumn());
    }
    else if (localRuleSymbol.block.argAction != null)
    {
      this.antlrTool.warning("Missing parameters on reference to rule " + paramRuleRefElement.targetRule, this.grammar.getFilename(), paramRuleRefElement.getLine(), paramRuleRefElement.getColumn());
    }
    _println(");");
    if ((this.grammar instanceof TreeWalkerGrammar))
      println("_t = retTree_;");
  }

  protected void genSemPred(String paramString, int paramInt)
  {
    ActionTransInfo localActionTransInfo = new ActionTransInfo();
    paramString = processActionForSpecialSymbols(paramString, paramInt, this.currentRule, localActionTransInfo);
    String str = this.charFormatter.escapeString(paramString);
    if ((this.grammar.debuggingOutput) && (((this.grammar instanceof ParserGrammar)) || ((this.grammar instanceof LexerGrammar))))
      paramString = "fireSemanticPredicateEvaluated(antlr.debug.SemanticPredicateEvent.VALIDATING," + addSemPred(str) + "," + paramString + ")";
    println("if (!(" + paramString + "))");
    println("  throw new SemanticException(\"" + str + "\");");
  }

  protected void genSemPredMap()
  {
    Enumeration localEnumeration = this.semPreds.elements();
    println("private string[] _semPredNames = {");
    this.tabs += 1;
    while (localEnumeration.hasMoreElements())
      println("\"" + localEnumeration.nextElement() + "\",");
    this.tabs -= 1;
    println("};");
  }

  protected void genSynPred(SynPredBlock paramSynPredBlock, String paramString)
  {
    if (this.DEBUG_CODE_GENERATOR)
      System.out.println("gen=>(" + paramSynPredBlock + ")");
    println("bool synPredMatched" + paramSynPredBlock.ID + " = false;");
    if ((this.grammar instanceof TreeWalkerGrammar))
      println("if (_t==null) _t=ASTNULL;");
    println("if (" + paramString + ")");
    println("{");
    this.tabs += 1;
    if ((this.grammar instanceof TreeWalkerGrammar))
      println("AST __t" + paramSynPredBlock.ID + " = _t;");
    else
      println("int _m" + paramSynPredBlock.ID + " = mark();");
    println("synPredMatched" + paramSynPredBlock.ID + " = true;");
    println("inputState.guessing++;");
    if ((this.grammar.debuggingOutput) && (((this.grammar instanceof ParserGrammar)) || ((this.grammar instanceof LexerGrammar))))
      println("fireSyntacticPredicateStarted();");
    this.syntacticPredLevel += 1;
    println("try {");
    this.tabs += 1;
    gen(paramSynPredBlock);
    this.tabs -= 1;
    println("}");
    println("catch (" + this.exceptionThrown + ")");
    println("{");
    this.tabs += 1;
    println("synPredMatched" + paramSynPredBlock.ID + " = false;");
    this.tabs -= 1;
    println("}");
    if ((this.grammar instanceof TreeWalkerGrammar))
      println("_t = __t" + paramSynPredBlock.ID + ";");
    else
      println("rewind(_m" + paramSynPredBlock.ID + ");");
    println("inputState.guessing--;");
    if ((this.grammar.debuggingOutput) && (((this.grammar instanceof ParserGrammar)) || ((this.grammar instanceof LexerGrammar))))
    {
      println("if (synPredMatched" + paramSynPredBlock.ID + ")");
      println("  fireSyntacticPredicateSucceeded();");
      println("else");
      println("  fireSyntacticPredicateFailed();");
    }
    this.syntacticPredLevel -= 1;
    this.tabs -= 1;
    println("}");
    println("if ( synPredMatched" + paramSynPredBlock.ID + " )");
    println("{");
  }

  public void genTokenStrings()
  {
    println("");
    println("public static readonly string[] tokenNames_ = new string[] {");
    this.tabs += 1;
    antlr.collections.impl.Vector localVector = this.grammar.tokenManager.getVocabulary();
    for (int i = 0; i < localVector.size(); i++)
    {
      String str = (String)localVector.elementAt(i);
      if (str == null)
        str = "<" + String.valueOf(i) + ">";
      if ((!str.startsWith("\"")) && (!str.startsWith("<")))
      {
        TokenSymbol localTokenSymbol = this.grammar.tokenManager.getTokenSymbol(str);
        if ((localTokenSymbol != null) && (localTokenSymbol.getParaphrase() != null))
          str = StringUtils.stripFrontBack(localTokenSymbol.getParaphrase(), "\"", "\"");
      }
      else if (str.startsWith("\""))
      {
        str = StringUtils.stripFrontBack(str, "\"", "\"");
      }
      print(this.charFormatter.literalString(str));
      if (i != localVector.size() - 1)
        _print(",");
      _println("");
    }
    this.tabs -= 1;
    println("};");
  }

  protected void genTokenTypes(TokenManager paramTokenManager)
    throws IOException
  {
    setupOutput(paramTokenManager.getName() + TokenTypesFileSuffix);
    this.tabs = 0;
    genHeader();
    println(this.behavior.getHeaderAction(""));
    if (nameSpace != null)
      nameSpace.emitDeclarations(this.currentOutput);
    this.tabs += 1;
    println("public class " + paramTokenManager.getName() + TokenTypesFileSuffix);
    println("{");
    this.tabs += 1;
    genTokenDefinitions(paramTokenManager);
    this.tabs -= 1;
    println("}");
    this.tabs -= 1;
    if (nameSpace != null)
      nameSpace.emitClosures(this.currentOutput);
    this.currentOutput.close();
    this.currentOutput = null;
    exitIfError();
  }

  protected void genTokenDefinitions(TokenManager paramTokenManager)
    throws IOException
  {
    antlr.collections.impl.Vector localVector = paramTokenManager.getVocabulary();
    println("public const int EOF = 1;");
    println("public const int NULL_TREE_LOOKAHEAD = 3;");
    for (int i = 4; i < localVector.size(); i++)
    {
      String str1 = (String)localVector.elementAt(i);
      if (str1 == null)
        continue;
      if (str1.startsWith("\""))
      {
        StringLiteralSymbol localStringLiteralSymbol = (StringLiteralSymbol)paramTokenManager.getTokenSymbol(str1);
        if (localStringLiteralSymbol == null)
        {
          this.antlrTool.panic("String literal " + str1 + " not in symbol table");
        }
        else if (localStringLiteralSymbol.label != null)
        {
          println("public const int " + localStringLiteralSymbol.label + " = " + i + ";");
        }
        else
        {
          String str2 = mangleLiteral(str1);
          if (str2 != null)
          {
            println("public const int " + str2 + " = " + i + ";");
            localStringLiteralSymbol.label = str2;
          }
          else
          {
            println("// " + str1 + " = " + i);
          }
        }
      }
      else
      {
        if (str1.startsWith("<"))
          continue;
        println("public const int " + str1 + " = " + i + ";");
      }
    }
    println("");
  }

  public String processStringForASTConstructor(String paramString)
  {
    if ((this.usingCustomAST) && (((this.grammar instanceof TreeWalkerGrammar)) || ((this.grammar instanceof ParserGrammar))) && (!this.grammar.tokenManager.tokenDefined(paramString)))
      return "(AST)" + paramString;
    return paramString;
  }

  public String getASTCreateString(antlr.collections.impl.Vector paramVector)
  {
    if (paramVector.size() == 0)
      return "";
    StringBuffer localStringBuffer = new StringBuffer();
    localStringBuffer.append("(" + this.labeledElementASTType + ") astFactory.make(");
    localStringBuffer.append(paramVector.elementAt(0));
    for (int i = 1; i < paramVector.size(); i++)
      localStringBuffer.append(", " + paramVector.elementAt(i));
    localStringBuffer.append(")");
    return localStringBuffer.toString();
  }

  public String getASTCreateString(GrammarAtom paramGrammarAtom, String paramString)
  {
    String str = "astFactory.create(" + paramString + ")";
    if (paramGrammarAtom == null)
      return getASTCreateString(paramString);
    if (paramGrammarAtom.getASTNodeType() != null)
    {
      TokenSymbol localTokenSymbol = this.grammar.tokenManager.getTokenSymbol(paramGrammarAtom.getText());
      if ((localTokenSymbol == null) || (localTokenSymbol.getASTNodeType() != paramGrammarAtom.getASTNodeType()))
        str = "(" + paramGrammarAtom.getASTNodeType() + ") astFactory.create(" + paramString + ", \"" + paramGrammarAtom.getASTNodeType() + "\")";
      else if ((localTokenSymbol != null) && (localTokenSymbol.getASTNodeType() != null))
        str = "(" + localTokenSymbol.getASTNodeType() + ") " + str;
    }
    else if (this.usingCustomAST)
    {
      str = "(" + this.labeledElementASTType + ") " + str;
    }
    return str;
  }

  public String getASTCreateString(String paramString)
  {
    if (paramString == null)
      paramString = "";
    String str1 = "astFactory.create(" + paramString + ")";
    String str2 = paramString;
    String str3 = null;
    int j = 0;
    int i = paramString.indexOf(',');
    if (i != -1)
    {
      str2 = paramString.substring(0, i);
      str3 = paramString.substring(i + 1, paramString.length());
      i = str3.indexOf(',');
      if (i != -1)
        j = 1;
    }
    TokenSymbol localTokenSymbol = this.grammar.tokenManager.getTokenSymbol(str2);
    if ((null != localTokenSymbol) && (null != localTokenSymbol.getASTNodeType()))
      str1 = "(" + localTokenSymbol.getASTNodeType() + ") " + str1;
    else if (this.usingCustomAST)
      str1 = "(" + this.labeledElementASTType + ") " + str1;
    return str1;
  }

  protected String getLookaheadTestExpression(Lookahead[] paramArrayOfLookahead, int paramInt)
  {
    StringBuffer localStringBuffer = new StringBuffer(100);
    int i = 1;
    localStringBuffer.append("(");
    for (int j = 1; j <= paramInt; j++)
    {
      BitSet localBitSet = paramArrayOfLookahead[j].fset;
      if (i == 0)
        localStringBuffer.append(") && (");
      i = 0;
      if (paramArrayOfLookahead[j].containsEpsilon())
        localStringBuffer.append("true");
      else
        localStringBuffer.append(getLookaheadTestTerm(j, localBitSet));
    }
    localStringBuffer.append(")");
    return localStringBuffer.toString();
  }

  protected String getLookaheadTestExpression(Alternative paramAlternative, int paramInt)
  {
    int i = paramAlternative.lookaheadDepth;
    if (i == 2147483647)
      i = this.grammar.maxk;
    if (paramInt == 0)
      return "( true )";
    return "(" + getLookaheadTestExpression(paramAlternative.cache, i) + ")";
  }

  protected String getLookaheadTestTerm(int paramInt, BitSet paramBitSet)
  {
    String str1 = lookaheadString(paramInt);
    int[] arrayOfInt = paramBitSet.toArray();
    if (elementsAreRange(arrayOfInt))
      return getRangeExpression(paramInt, arrayOfInt);
    int i = paramBitSet.degree();
    if (i == 0)
      return "true";
    if (i >= this.bitsetTestThreshold)
    {
      j = markBitsetForGen(paramBitSet);
      return getBitsetName(j) + ".member(" + str1 + ")";
    }
    StringBuffer localStringBuffer = new StringBuffer();
    for (int j = 0; j < arrayOfInt.length; j++)
    {
      String str2 = getValueString(arrayOfInt[j]);
      if (j > 0)
        localStringBuffer.append("||");
      localStringBuffer.append(str1);
      localStringBuffer.append("==");
      localStringBuffer.append(str2);
    }
    return localStringBuffer.toString();
  }

  public String getRangeExpression(int paramInt, int[] paramArrayOfInt)
  {
    if (!elementsAreRange(paramArrayOfInt))
      this.antlrTool.panic("getRangeExpression called with non-range");
    int i = paramArrayOfInt[0];
    int j = paramArrayOfInt[(paramArrayOfInt.length - 1)];
    return "(" + lookaheadString(paramInt) + " >= " + getValueString(i) + " && " + lookaheadString(paramInt) + " <= " + getValueString(j) + ")";
  }

  private String getValueString(int paramInt)
  {
    Object localObject;
    if ((this.grammar instanceof LexerGrammar))
    {
      localObject = this.charFormatter.literalChar(paramInt);
    }
    else
    {
      TokenSymbol localTokenSymbol = this.grammar.tokenManager.getTokenSymbolAt(paramInt);
      if (localTokenSymbol == null)
        return "" + paramInt;
      String str1 = localTokenSymbol.getId();
      if ((localTokenSymbol instanceof StringLiteralSymbol))
      {
        StringLiteralSymbol localStringLiteralSymbol = (StringLiteralSymbol)localTokenSymbol;
        String str2 = localStringLiteralSymbol.getLabel();
        if (str2 != null)
        {
          localObject = str2;
        }
        else
        {
          localObject = mangleLiteral(str1);
          if (localObject == null)
            localObject = String.valueOf(paramInt);
        }
      }
      else
      {
        localObject = str1;
      }
    }
    return (String)localObject;
  }

  protected boolean lookaheadIsEmpty(Alternative paramAlternative, int paramInt)
  {
    int i = paramAlternative.lookaheadDepth;
    if (i == 2147483647)
      i = this.grammar.maxk;
    for (int j = 1; (j <= i) && (j <= paramInt); j++)
    {
      BitSet localBitSet = paramAlternative.cache[j].fset;
      if (localBitSet.degree() != 0)
        return false;
    }
    return true;
  }

  private String lookaheadString(int paramInt)
  {
    if ((this.grammar instanceof TreeWalkerGrammar))
      return "_t.Type";
    if ((this.grammar instanceof LexerGrammar))
    {
      if (paramInt == 1)
        return "cached_LA1";
      if (paramInt == 2)
        return "cached_LA2";
    }
    return "LA(" + paramInt + ")";
  }

  private String mangleLiteral(String paramString)
  {
    String str = this.antlrTool.literalsPrefix;
    for (int i = 1; i < paramString.length() - 1; i++)
    {
      if ((!Character.isLetter(paramString.charAt(i))) && (paramString.charAt(i) != '_'))
        return null;
      str = str + paramString.charAt(i);
    }
    if (this.antlrTool.upperCaseMangledLiterals)
      str = str.toUpperCase();
    return str;
  }

  public String mapTreeId(String paramString, ActionTransInfo paramActionTransInfo)
  {
    if (this.currentRule == null)
      return paramString;
    int i = 0;
    String str1 = paramString;
    if ((this.grammar instanceof TreeWalkerGrammar))
      if (!this.grammar.buildAST)
      {
        i = 1;
      }
      else if ((str1.length() > 3) && (str1.lastIndexOf("_in") == str1.length() - 3))
      {
        str1 = str1.substring(0, str1.length() - 3);
        i = 1;
      }
    Object localObject;
    for (int j = 0; j < this.currentRule.labeledElements.size(); j++)
    {
      localObject = (AlternativeElement)this.currentRule.labeledElements.elementAt(j);
      if (((AlternativeElement)localObject).getLabel().equals(str1))
        return str1 + "_AST";
    }
    String str2 = (String)this.treeVariableMap.get(str1);
    if (str2 != null)
    {
      if (str2 == NONUNIQUE)
      {
        this.antlrTool.error("Ambiguous reference to AST element " + str1 + " in rule " + this.currentRule.getRuleName());
        return null;
      }
      if (str2.equals(this.currentRule.getRuleName()))
      {
        this.antlrTool.error("Ambiguous reference to AST element " + str1 + " in rule " + this.currentRule.getRuleName());
        return null;
      }
      return i != 0 ? str2 + "_in" : str2;
    }
    if (str1.equals(this.currentRule.getRuleName()))
    {
      localObject = str1 + "_AST";
      if ((paramActionTransInfo != null) && (i == 0))
        paramActionTransInfo.refRuleRoot = ((String)localObject);
      return localObject;
    }
    return (String)str1;
  }

  private void mapTreeVariable(AlternativeElement paramAlternativeElement, String paramString)
  {
    if ((paramAlternativeElement instanceof TreeElement))
    {
      mapTreeVariable(((TreeElement)paramAlternativeElement).root, paramString);
      return;
    }
    String str = null;
    if (paramAlternativeElement.getLabel() == null)
      if ((paramAlternativeElement instanceof TokenRefElement))
        str = ((TokenRefElement)paramAlternativeElement).atomText;
      else if ((paramAlternativeElement instanceof RuleRefElement))
        str = ((RuleRefElement)paramAlternativeElement).targetRule;
    if (str != null)
      if (this.treeVariableMap.get(str) != null)
      {
        this.treeVariableMap.remove(str);
        this.treeVariableMap.put(str, NONUNIQUE);
      }
      else
      {
        this.treeVariableMap.put(str, paramString);
      }
  }

  protected String processActionForSpecialSymbols(String paramString, int paramInt, RuleBlock paramRuleBlock, ActionTransInfo paramActionTransInfo)
  {
    if ((paramString == null) || (paramString.length() == 0))
      return null;
    if (this.grammar == null)
      return paramString;
    if (((this.grammar.buildAST) && (paramString.indexOf('#') != -1)) || ((this.grammar instanceof TreeWalkerGrammar)) || ((((this.grammar instanceof LexerGrammar)) || ((this.grammar instanceof ParserGrammar))) && (paramString.indexOf('$') != -1)))
    {
      ActionLexer localActionLexer = new ActionLexer(paramString, paramRuleBlock, this, paramActionTransInfo);
      localActionLexer.setLineOffset(paramInt);
      localActionLexer.setFilename(this.grammar.getFilename());
      localActionLexer.setTool(this.antlrTool);
      try
      {
        localActionLexer.mACTION(true);
        paramString = localActionLexer.getTokenObject().getText();
      }
      catch (RecognitionException localRecognitionException)
      {
        localActionLexer.reportError(localRecognitionException);
        return paramString;
      }
      catch (TokenStreamException localTokenStreamException)
      {
        this.antlrTool.panic("Error reading action:" + paramString);
        return paramString;
      }
      catch (CharStreamException localCharStreamException)
      {
        this.antlrTool.panic("Error reading action:" + paramString);
        return paramString;
      }
    }
    return paramString;
  }

  private void setupGrammarParameters(Grammar paramGrammar)
  {
    Token localToken;
    if (((paramGrammar instanceof ParserGrammar)) || ((paramGrammar instanceof LexerGrammar)) || ((paramGrammar instanceof TreeWalkerGrammar)))
    {
      if (this.antlrTool.nameSpace != null)
        nameSpace = new CSharpNameSpace(this.antlrTool.nameSpace.getName());
      if (paramGrammar.hasOption("namespace"))
      {
        localToken = paramGrammar.getOption("namespace");
        if (localToken != null)
          nameSpace = new CSharpNameSpace(localToken.getText());
      }
    }
    String str;
    if ((paramGrammar instanceof ParserGrammar))
    {
      this.labeledElementASTType = "AST";
      if (paramGrammar.hasOption("ASTLabelType"))
      {
        localToken = paramGrammar.getOption("ASTLabelType");
        if (localToken != null)
        {
          str = StringUtils.stripFrontBack(localToken.getText(), "\"", "\"");
          if (str != null)
          {
            this.usingCustomAST = true;
            this.labeledElementASTType = str;
          }
        }
      }
      this.labeledElementType = "IToken ";
      this.labeledElementInit = "null";
      this.commonExtraArgs = "";
      this.commonExtraParams = "";
      this.commonLocalVars = "";
      this.lt1Value = "LT(1)";
      this.exceptionThrown = "RecognitionException";
      this.throwNoViable = "throw new NoViableAltException(LT(1), getFilename());";
    }
    else if ((paramGrammar instanceof LexerGrammar))
    {
      this.labeledElementType = "char ";
      this.labeledElementInit = "'\\0'";
      this.commonExtraArgs = "";
      this.commonExtraParams = "bool _createToken";
      this.commonLocalVars = "int _ttype; IToken _token=null; int _begin=text.Length;";
      this.lt1Value = "cached_LA1";
      this.exceptionThrown = "RecognitionException";
      this.throwNoViable = "throw new NoViableAltForCharException(cached_LA1, getFilename(), getLine(), getColumn());";
    }
    else if ((paramGrammar instanceof TreeWalkerGrammar))
    {
      this.labeledElementASTType = "AST";
      this.labeledElementType = "AST";
      if (paramGrammar.hasOption("ASTLabelType"))
      {
        localToken = paramGrammar.getOption("ASTLabelType");
        if (localToken != null)
        {
          str = StringUtils.stripFrontBack(localToken.getText(), "\"", "\"");
          if (str != null)
          {
            this.usingCustomAST = true;
            this.labeledElementASTType = str;
            this.labeledElementType = str;
          }
        }
      }
      if (!paramGrammar.hasOption("ASTLabelType"))
        paramGrammar.setOption("ASTLabelType", new Token(6, "AST"));
      this.labeledElementInit = "null";
      this.commonExtraArgs = "_t";
      this.commonExtraParams = "AST _t";
      this.commonLocalVars = "";
      if (this.usingCustomAST)
        this.lt1Value = ("(_t==ASTNULL) ? null : (" + this.labeledElementASTType + ")_t");
      else
        this.lt1Value = "_t";
      this.exceptionThrown = "RecognitionException";
      this.throwNoViable = "throw new NoViableAltException(_t);";
    }
    else
    {
      this.antlrTool.panic("Unknown grammar type");
    }
  }

  public void setupOutput(String paramString)
    throws IOException
  {
    this.currentOutput = this.antlrTool.openOutputFile(paramString + ".cs");
  }

  private static String OctalToUnicode(String paramString)
  {
    if ((4 <= paramString.length()) && ('\'' == paramString.charAt(0)) && ('\\' == paramString.charAt(1)) && ('0' <= paramString.charAt(2)) && ('7' >= paramString.charAt(2)) && ('\'' == paramString.charAt(paramString.length() - 1)))
    {
      Integer localInteger = Integer.valueOf(paramString.substring(2, paramString.length() - 1), 8);
      return "'\\x" + Integer.toHexString(localInteger.intValue()) + "'";
    }
    return paramString;
  }

  public String getTokenTypesClassName()
  {
    TokenManager localTokenManager = this.grammar.tokenManager;
    return new String(localTokenManager.getName() + TokenTypesFileSuffix);
  }

  private void declareSaveIndexVariableIfNeeded()
  {
    if (this.saveIndexCreateLevel == 0)
    {
      println("int _saveIndex = 0;");
      this.saveIndexCreateLevel = this.blockNestingLevel;
    }
  }

  public String[] split(String paramString1, String paramString2)
  {
    StringTokenizer localStringTokenizer = new StringTokenizer(paramString1, paramString2);
    int i = localStringTokenizer.countTokens();
    String[] arrayOfString = new String[i];
    for (int j = 0; localStringTokenizer.hasMoreTokens(); j++)
      arrayOfString[j] = localStringTokenizer.nextToken();
    return arrayOfString;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.CSharpCodeGenerator
 * JD-Core Version:    0.6.0
 */