package antlr;

import antlr.collections.AST;
import antlr.collections.ASTEnumeration;
import antlr.collections.impl.ASTEnumerator;
import antlr.collections.impl.Vector;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;

public abstract class BaseAST
  implements AST, Serializable
{
  protected BaseAST down;
  protected BaseAST right;
  private static boolean verboseStringConversion = false;
  private static String[] tokenNames = null;

  public void addChild(AST paramAST)
  {
    if (paramAST == null)
      return;
    BaseAST localBaseAST = this.down;
    if (localBaseAST != null)
    {
      while (localBaseAST.right != null)
        localBaseAST = localBaseAST.right;
      localBaseAST.right = ((BaseAST)paramAST);
    }
    else
    {
      this.down = ((BaseAST)paramAST);
    }
  }

  public int getNumberOfChildren()
  {
    BaseAST localBaseAST = this.down;
    int i = 0;
    if (localBaseAST != null)
    {
      for (i = 1; localBaseAST.right != null; i++)
        localBaseAST = localBaseAST.right;
      return i;
    }
    return i;
  }

  private void doWorkForFindAll(Vector paramVector, AST paramAST, boolean paramBoolean)
  {
    for (Object localObject = this; localObject != null; localObject = ((Serializable)localObject).getNextSibling())
    {
      if (((paramBoolean) && (((Serializable)localObject).equalsTreePartial(paramAST))) || ((!paramBoolean) && (((Serializable)localObject).equalsTree(paramAST))))
        paramVector.appendElement(localObject);
      if (((Serializable)localObject).getFirstChild() == null)
        continue;
      ((BaseAST)((Serializable)localObject).getFirstChild()).doWorkForFindAll(paramVector, paramAST, paramBoolean);
    }
  }

  public boolean equals(AST paramAST)
  {
    if (paramAST == null)
      return false;
    if (((getText() == null) && (paramAST.getText() != null)) || ((getText() != null) && (paramAST.getText() == null)))
      return false;
    if ((getText() == null) && (paramAST.getText() == null))
      return getType() == paramAST.getType();
    return (getText().equals(paramAST.getText())) && (getType() == paramAST.getType());
  }

  public boolean equalsList(AST paramAST)
  {
    if (paramAST == null)
      return false;
    Object localObject = this;
    while ((localObject != null) && (paramAST != null))
    {
      if (!((Serializable)localObject).equals(paramAST))
        return false;
      if (((Serializable)localObject).getFirstChild() != null)
      {
        if (!((Serializable)localObject).getFirstChild().equalsList(paramAST.getFirstChild()))
          return false;
      }
      else if (paramAST.getFirstChild() != null)
        return false;
      localObject = ((Serializable)localObject).getNextSibling();
      paramAST = paramAST.getNextSibling();
    }
    return (localObject == null) && (paramAST == null);
  }

  public boolean equalsListPartial(AST paramAST)
  {
    if (paramAST == null)
      return true;
    Object localObject = this;
    while ((localObject != null) && (paramAST != null))
    {
      if (!((Serializable)localObject).equals(paramAST))
        return false;
      if ((((Serializable)localObject).getFirstChild() != null) && (!((Serializable)localObject).getFirstChild().equalsListPartial(paramAST.getFirstChild())))
        return false;
      localObject = ((Serializable)localObject).getNextSibling();
      paramAST = paramAST.getNextSibling();
    }
    return (localObject != null) || (paramAST == null);
  }

  public boolean equalsTree(AST paramAST)
  {
    if (!equals(paramAST))
      return false;
    if (getFirstChild() != null)
    {
      if (!getFirstChild().equalsList(paramAST.getFirstChild()))
        return false;
    }
    else if (paramAST.getFirstChild() != null)
      return false;
    return true;
  }

  public boolean equalsTreePartial(AST paramAST)
  {
    if (paramAST == null)
      return true;
    if (!equals(paramAST))
      return false;
    return (getFirstChild() == null) || (getFirstChild().equalsListPartial(paramAST.getFirstChild()));
  }

  public ASTEnumeration findAll(AST paramAST)
  {
    Vector localVector = new Vector(10);
    if (paramAST == null)
      return null;
    doWorkForFindAll(localVector, paramAST, false);
    return new ASTEnumerator(localVector);
  }

  public ASTEnumeration findAllPartial(AST paramAST)
  {
    Vector localVector = new Vector(10);
    if (paramAST == null)
      return null;
    doWorkForFindAll(localVector, paramAST, true);
    return new ASTEnumerator(localVector);
  }

  public AST getFirstChild()
  {
    return this.down;
  }

  public AST getNextSibling()
  {
    return this.right;
  }

  public String getText()
  {
    return "";
  }

  public int getType()
  {
    return 0;
  }

  public int getLine()
  {
    return 0;
  }

  public int getColumn()
  {
    return 0;
  }

  public abstract void initialize(int paramInt, String paramString);

  public abstract void initialize(AST paramAST);

  public abstract void initialize(Token paramToken);

  public void removeChildren()
  {
    this.down = null;
  }

  public void setFirstChild(AST paramAST)
  {
    this.down = ((BaseAST)paramAST);
  }

  public void setNextSibling(AST paramAST)
  {
    this.right = ((BaseAST)paramAST);
  }

  public void setText(String paramString)
  {
  }

  public void setType(int paramInt)
  {
  }

  public static void setVerboseStringConversion(boolean paramBoolean, String[] paramArrayOfString)
  {
    verboseStringConversion = paramBoolean;
    tokenNames = paramArrayOfString;
  }

  public static String[] getTokenNames()
  {
    return tokenNames;
  }

  public String toString()
  {
    StringBuffer localStringBuffer = new StringBuffer();
    if ((verboseStringConversion) && (getText() != null) && (!getText().equalsIgnoreCase(tokenNames[getType()])) && (!getText().equalsIgnoreCase(StringUtils.stripFrontBack(tokenNames[getType()], "\"", "\""))))
    {
      localStringBuffer.append('[');
      localStringBuffer.append(getText());
      localStringBuffer.append(",<");
      localStringBuffer.append(tokenNames[getType()]);
      localStringBuffer.append(">]");
      return localStringBuffer.toString();
    }
    return getText();
  }

  public String toStringList()
  {
    BaseAST localBaseAST = this;
    String str = "";
    if (localBaseAST.getFirstChild() != null)
      str = str + " (";
    str = str + " " + toString();
    if (localBaseAST.getFirstChild() != null)
      str = str + ((BaseAST)localBaseAST.getFirstChild()).toStringList();
    if (localBaseAST.getFirstChild() != null)
      str = str + " )";
    if (localBaseAST.getNextSibling() != null)
      str = str + ((BaseAST)localBaseAST.getNextSibling()).toStringList();
    return str;
  }

  public String toStringTree()
  {
    BaseAST localBaseAST = this;
    String str = "";
    if (localBaseAST.getFirstChild() != null)
      str = str + " (";
    str = str + " " + toString();
    if (localBaseAST.getFirstChild() != null)
      str = str + ((BaseAST)localBaseAST.getFirstChild()).toStringList();
    if (localBaseAST.getFirstChild() != null)
      str = str + " )";
    return str;
  }

  public static String decode(String paramString)
  {
    StringBuffer localStringBuffer = new StringBuffer();
    for (int i1 = 0; i1 < paramString.length(); i1++)
    {
      char c = paramString.charAt(i1);
      if (c == '&')
      {
        int i = paramString.charAt(i1 + 1);
        int j = paramString.charAt(i1 + 2);
        int k = paramString.charAt(i1 + 3);
        int m = paramString.charAt(i1 + 4);
        int n = paramString.charAt(i1 + 5);
        if ((i == 97) && (j == 109) && (k == 112) && (m == 59))
        {
          localStringBuffer.append("&");
          i1 += 5;
        }
        else if ((i == 108) && (j == 116) && (k == 59))
        {
          localStringBuffer.append("<");
          i1 += 4;
        }
        else if ((i == 103) && (j == 116) && (k == 59))
        {
          localStringBuffer.append(">");
          i1 += 4;
        }
        else if ((i == 113) && (j == 117) && (k == 111) && (m == 116) && (n == 59))
        {
          localStringBuffer.append("\"");
          i1 += 6;
        }
        else if ((i == 97) && (j == 112) && (k == 111) && (m == 115) && (n == 59))
        {
          localStringBuffer.append("'");
          i1 += 6;
        }
        else
        {
          localStringBuffer.append("&");
        }
      }
      else
      {
        localStringBuffer.append(c);
      }
    }
    return new String(localStringBuffer);
  }

  public static String encode(String paramString)
  {
    StringBuffer localStringBuffer = new StringBuffer();
    for (int i = 0; i < paramString.length(); i++)
    {
      char c = paramString.charAt(i);
      switch (c)
      {
      case '&':
        localStringBuffer.append("&amp;");
        break;
      case '<':
        localStringBuffer.append("&lt;");
        break;
      case '>':
        localStringBuffer.append("&gt;");
        break;
      case '"':
        localStringBuffer.append("&quot;");
        break;
      case '\'':
        localStringBuffer.append("&apos;");
        break;
      default:
        localStringBuffer.append(c);
      }
    }
    return new String(localStringBuffer);
  }

  public void xmlSerializeNode(Writer paramWriter)
    throws IOException
  {
    StringBuffer localStringBuffer = new StringBuffer(100);
    localStringBuffer.append("<");
    localStringBuffer.append(getClass().getName() + " ");
    localStringBuffer.append("text=\"" + encode(getText()) + "\" type=\"" + getType() + "\"/>");
    paramWriter.write(localStringBuffer.toString());
  }

  public void xmlSerializeRootOpen(Writer paramWriter)
    throws IOException
  {
    StringBuffer localStringBuffer = new StringBuffer(100);
    localStringBuffer.append("<");
    localStringBuffer.append(getClass().getName() + " ");
    localStringBuffer.append("text=\"" + encode(getText()) + "\" type=\"" + getType() + "\">\n");
    paramWriter.write(localStringBuffer.toString());
  }

  public void xmlSerializeRootClose(Writer paramWriter)
    throws IOException
  {
    paramWriter.write("</" + getClass().getName() + ">\n");
  }

  public void xmlSerialize(Writer paramWriter)
    throws IOException
  {
    for (Object localObject = this; localObject != null; localObject = ((Serializable)localObject).getNextSibling())
      if (((Serializable)localObject).getFirstChild() == null)
      {
        ((BaseAST)localObject).xmlSerializeNode(paramWriter);
      }
      else
      {
        ((BaseAST)localObject).xmlSerializeRootOpen(paramWriter);
        ((BaseAST)((Serializable)localObject).getFirstChild()).xmlSerialize(paramWriter);
        ((BaseAST)localObject).xmlSerializeRootClose(paramWriter);
      }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     antlr.BaseAST
 * JD-Core Version:    0.6.0
 */