/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ import java.beans.PropertyChangeEvent;
/*     */ import java.beans.PropertyVetoException;
/*     */ import java.beans.VetoableChangeListener;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.util.HashMap;
/*     */ 
/*     */ public class VetoableChangeMulticaster
/*     */   implements Serializable
/*     */ {
/* 119 */   protected transient VetoableChangeListener[] listeners = new VetoableChangeListener[0];
/*     */   protected final Object source;
/*     */   protected HashMap children;
/*     */ 
/*     */   protected synchronized VetoableChangeMulticaster getChild(String propertyName)
/*     */   {
/* 140 */     return this.children == null ? null : 
/* 141 */       (VetoableChangeMulticaster)this.children.get(propertyName);
/*     */   }
/*     */ 
/*     */   public VetoableChangeMulticaster(Object sourceBean)
/*     */   {
/* 153 */     if (sourceBean == null) {
/* 154 */       throw new NullPointerException();
/*     */     }
/*     */ 
/* 157 */     this.source = sourceBean;
/*     */   }
/*     */ 
/*     */   public synchronized void addVetoableChangeListener(VetoableChangeListener listener)
/*     */   {
/* 171 */     if (listener == null) throw new NullPointerException();
/*     */ 
/* 173 */     int len = this.listeners.length;
/* 174 */     VetoableChangeListener[] newArray = new VetoableChangeListener[len + 1];
/* 175 */     if (len > 0)
/* 176 */       System.arraycopy(this.listeners, 0, newArray, 0, len);
/* 177 */     newArray[len] = listener;
/* 178 */     this.listeners = newArray;
/*     */   }
/*     */ 
/*     */   public synchronized void addVetoableChangeListenerIfAbsent(VetoableChangeListener listener)
/*     */   {
/* 194 */     if (listener == null) throw new NullPointerException();
/*     */ 
/* 197 */     int len = this.listeners.length;
/* 198 */     VetoableChangeListener[] newArray = new VetoableChangeListener[len + 1];
/* 199 */     for (int i = 0; i < len; i++) {
/* 200 */       newArray[i] = this.listeners[i];
/* 201 */       if (listener.equals(this.listeners[i]))
/* 202 */         return;
/*     */     }
/* 204 */     newArray[len] = listener;
/* 205 */     this.listeners = newArray;
/*     */   }
/*     */ 
/*     */   public synchronized void removeVetoableChangeListener(VetoableChangeListener listener)
/*     */   {
/* 223 */     int newlen = this.listeners.length - 1;
/* 224 */     if ((newlen < 0) || (listener == null)) return;
/*     */ 
/* 228 */     VetoableChangeListener[] newArray = new VetoableChangeListener[newlen];
/*     */ 
/* 230 */     for (int i = 0; i < newlen; i++) {
/* 231 */       if (listener.equals(this.listeners[i]))
/*     */       {
/* 233 */         for (int k = i + 1; k <= newlen; k++) newArray[(k - 1)] = this.listeners[k];
/* 234 */         this.listeners = newArray;
/* 235 */         return;
/*     */       }
/*     */ 
/* 238 */       newArray[i] = this.listeners[i];
/*     */     }
/*     */ 
/* 242 */     if (listener.equals(this.listeners[newlen]))
/* 243 */       this.listeners = newArray;
/*     */   }
/*     */ 
/*     */   public void addVetoableChangeListener(String propertyName, VetoableChangeListener listener)
/*     */   {
/* 262 */     if (listener == null) throw new NullPointerException();
/*     */ 
/* 264 */     VetoableChangeMulticaster child = null;
/*     */ 
/* 266 */     synchronized (this) {
/* 267 */       if (this.children == null)
/* 268 */         this.children = new HashMap();
/*     */       else {
/* 270 */         child = (VetoableChangeMulticaster)this.children.get(propertyName);
/*     */       }
/* 272 */       if (child == null) {
/* 273 */         child = new VetoableChangeMulticaster(this.source);
/* 274 */         this.children.put(propertyName, child);
/*     */       }
/*     */     }
/*     */ 
/* 278 */     child.addVetoableChangeListener(listener);
/*     */   }
/*     */ 
/*     */   public void addVetoableChangeListenerIfAbsent(String propertyName, VetoableChangeListener listener)
/*     */   {
/* 295 */     if (listener == null) throw new NullPointerException();
/*     */ 
/* 297 */     VetoableChangeMulticaster child = null;
/*     */ 
/* 299 */     synchronized (this) {
/* 300 */       if (this.children == null)
/* 301 */         this.children = new HashMap();
/*     */       else {
/* 303 */         child = (VetoableChangeMulticaster)this.children.get(propertyName);
/*     */       }
/* 305 */       if (child == null) {
/* 306 */         child = new VetoableChangeMulticaster(this.source);
/* 307 */         this.children.put(propertyName, child);
/*     */       }
/*     */     }
/*     */ 
/* 311 */     child.addVetoableChangeListenerIfAbsent(listener);
/*     */   }
/*     */ 
/*     */   public void removeVetoableChangeListener(String propertyName, VetoableChangeListener listener)
/*     */   {
/* 328 */     VetoableChangeMulticaster child = getChild(propertyName);
/* 329 */     if (child != null)
/* 330 */       child.removeVetoableChangeListener(listener);
/*     */   }
/*     */ 
/*     */   protected void multicast(PropertyChangeEvent evt)
/*     */     throws PropertyVetoException
/*     */   {
/* 342 */     VetoableChangeMulticaster child = null;
/*     */ 
/* 344 */     synchronized (this) {
/* 345 */       VetoableChangeListener[] array = this.listeners;
/*     */ 
/* 347 */       if ((this.children != null) && (evt.getPropertyName() != null))
/* 348 */         child = (VetoableChangeMulticaster)this.children.get(evt.getPropertyName());
/*     */     }
/*     */     VetoableChangeListener[] array;
/* 353 */     int i = 0;
/*     */     try
/*     */     {
/* 356 */       for (i = 0; i < array.length; i++) {
/* 357 */         array[i].vetoableChange(evt);
/*     */       }
/* 359 */       if (child != null) {
/* 360 */         child.multicast(evt);
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (PropertyVetoException veto)
/*     */     {
/* 367 */       PropertyChangeEvent revert = 
/* 368 */         new PropertyChangeEvent(evt.getSource(), 
/* 369 */         evt.getPropertyName(), 
/* 370 */         evt.getNewValue(), 
/* 371 */         evt.getOldValue());
/*     */ 
/* 373 */       int lastNotified = i < array.length ? i : array.length - 1;
/*     */ 
/* 375 */       for (int k = 0; k <= lastNotified; k++) {
/*     */         try {
/* 377 */           array[k].vetoableChange(revert);
/*     */         }
/*     */         catch (PropertyVetoException localPropertyVetoException1)
/*     */         {
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 385 */       throw veto;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void fireVetoableChange(String propertyName, Object oldValue, Object newValue)
/*     */     throws PropertyVetoException
/*     */   {
/* 413 */     if ((oldValue == null) || (newValue == null) || (!oldValue.equals(newValue)))
/* 414 */       multicast(
/* 417 */         new PropertyChangeEvent(this.source, 
/* 415 */         propertyName, 
/* 416 */         oldValue, 
/* 417 */         newValue));
/*     */   }
/*     */ 
/*     */   public void fireVetoableChange(String propertyName, int oldValue, int newValue)
/*     */     throws PropertyVetoException
/*     */   {
/* 447 */     if (oldValue != newValue)
/* 448 */       multicast(
/* 451 */         new PropertyChangeEvent(this.source, 
/* 449 */         propertyName, 
/* 450 */         new Integer(oldValue), 
/* 451 */         new Integer(newValue)));
/*     */   }
/*     */ 
/*     */   public void fireVetoableChange(String propertyName, boolean oldValue, boolean newValue)
/*     */     throws PropertyVetoException
/*     */   {
/* 481 */     if (oldValue != newValue)
/* 482 */       multicast(
/* 485 */         new PropertyChangeEvent(this.source, 
/* 483 */         propertyName, 
/* 484 */         new Boolean(oldValue), 
/* 485 */         new Boolean(newValue)));
/*     */   }
/*     */ 
/*     */   public void fireVetoableChange(PropertyChangeEvent evt)
/*     */     throws PropertyVetoException
/*     */   {
/* 508 */     Object oldValue = evt.getOldValue();
/* 509 */     Object newValue = evt.getNewValue();
/* 510 */     if ((oldValue == null) || (newValue == null) || (!oldValue.equals(newValue)))
/* 511 */       multicast(evt);
/*     */   }
/*     */ 
/*     */   public boolean hasListeners(String propertyName)
/*     */   {
/* 526 */     synchronized (this) {
/* 527 */       if (this.listeners.length > 0)
/* 528 */         return true;
/* 529 */       if ((propertyName == null) || (this.children == null)) {
/* 530 */         return false;
/*     */       }
/* 532 */       VetoableChangeMulticaster child = (VetoableChangeMulticaster)this.children.get(propertyName);
/* 533 */       if (child == null)
/* 534 */         return false;
/*     */     }
/*     */     VetoableChangeMulticaster child;
/* 538 */     return child.hasListeners(null);
/*     */   }
/*     */ 
/*     */   private synchronized void writeObject(ObjectOutputStream s)
/*     */     throws IOException
/*     */   {
/* 550 */     s.defaultWriteObject();
/*     */ 
/* 552 */     for (int i = 0; i < this.listeners.length; i++) {
/* 553 */       VetoableChangeListener l = this.listeners[i];
/* 554 */       if ((this.listeners[i] instanceof Serializable)) {
/* 555 */         s.writeObject(this.listeners[i]);
/*     */       }
/*     */     }
/* 558 */     s.writeObject(null);
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException
/*     */   {
/* 563 */     this.listeners = new VetoableChangeListener[0];
/* 564 */     s.defaultReadObject();
/*     */     Object listenerOrNull;
/* 567 */     while ((listenerOrNull = s.readObject()) != null)
/*     */     {
/*     */       Object listenerOrNull;
/* 568 */       addVetoableChangeListener((VetoableChangeListener)listenerOrNull);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.VetoableChangeMulticaster
 * JD-Core Version:    0.6.0
 */