/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ public class SynchronizedByte extends SynchronizedVariable
/*     */   implements Comparable, Cloneable
/*     */ {
/*     */   protected byte value_;
/*     */ 
/*     */   public SynchronizedByte(byte initialValue)
/*     */   {
/*  33 */     this.value_ = initialValue;
/*     */   }
/*     */ 
/*     */   public SynchronizedByte(byte initialValue, Object lock)
/*     */   {
/*  41 */     super(lock);
/*  42 */     this.value_ = initialValue;
/*     */   }
/*     */ 
/*     */   public final byte get()
/*     */   {
/*  48 */     synchronized (this.lock_) { return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public byte set(byte newValue)
/*     */   {
/*  56 */     synchronized (this.lock_) {
/*  57 */       byte old = this.value_;
/*  58 */       this.value_ = newValue;
/*  59 */       return old;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean commit(byte assumedValue, byte newValue)
/*     */   {
/*  68 */     synchronized (this.lock_) {
/*  69 */       boolean success = assumedValue == this.value_;
/*  70 */       if (success) this.value_ = newValue;
/*  71 */       return success;
/*     */     }
/*     */   }
/*     */ 
/*     */   public byte swap(SynchronizedByte other)
/*     */   {
/*  87 */     if (other == this) return get();
/*  88 */     SynchronizedByte fst = this;
/*  89 */     SynchronizedByte snd = other;
/*  90 */     if (System.identityHashCode(fst) > System.identityHashCode(snd)) {
/*  91 */       fst = other;
/*  92 */       snd = this;
/*     */     }
/*  94 */     synchronized (fst.lock_) {
/*  95 */       synchronized (snd.lock_) {
/*  96 */         fst.set(snd.set(fst.get()));
/*  97 */         return get();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public byte increment()
/*     */   {
/* 107 */     synchronized (this.lock_) {
/* 108 */       return this.value_ = (byte)(this.value_ + 1);
/*     */     }
/*     */   }
/*     */ 
/*     */   public byte decrement()
/*     */   {
/* 117 */     synchronized (this.lock_) {
/* 118 */       return this.value_ = (byte)(this.value_ - 1);
/*     */     }
/*     */   }
/*     */ 
/*     */   public byte add(byte amount)
/*     */   {
/* 127 */     synchronized (this.lock_) {
/* 128 */       return this.value_ = (byte)(this.value_ + amount);
/*     */     }
/*     */   }
/*     */ 
/*     */   public byte subtract(byte amount)
/*     */   {
/* 137 */     synchronized (this.lock_) {
/* 138 */       return this.value_ = (byte)(this.value_ - amount);
/*     */     }
/*     */   }
/*     */ 
/*     */   public byte multiply(byte factor)
/*     */   {
/* 147 */     synchronized (this.lock_) {
/* 148 */       return this.value_ = (byte)(this.value_ * factor);
/*     */     }
/*     */   }
/*     */ 
/*     */   public byte divide(byte factor)
/*     */   {
/* 157 */     synchronized (this.lock_) {
/* 158 */       return this.value_ = (byte)(this.value_ / factor);
/*     */     }
/*     */   }
/*     */ 
/*     */   public byte negate()
/*     */   {
/* 167 */     synchronized (this.lock_) {
/* 168 */       this.value_ = (byte)(-this.value_);
/* 169 */       return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public byte complement()
/*     */   {
/* 178 */     synchronized (this.lock_) {
/* 179 */       this.value_ = (byte)(this.value_ ^ 0xFFFFFFFF);
/* 180 */       return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public byte and(byte b)
/*     */   {
/* 189 */     synchronized (this.lock_) {
/* 190 */       this.value_ = (byte)(this.value_ & b);
/* 191 */       return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public byte or(byte b)
/*     */   {
/* 200 */     synchronized (this.lock_) {
/* 201 */       this.value_ = (byte)(this.value_ | b);
/* 202 */       return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public byte xor(byte b)
/*     */   {
/* 212 */     synchronized (this.lock_) {
/* 213 */       this.value_ = (byte)(this.value_ ^ b);
/* 214 */       return this.value_;
/*     */     }
/*     */   }
/*     */ 
/*     */   public int compareTo(byte other) {
/* 219 */     byte val = get();
/* 220 */     return val == other ? 0 : val < other ? -1 : 1;
/*     */   }
/*     */ 
/*     */   public int compareTo(SynchronizedByte other) {
/* 224 */     return compareTo(other.get());
/*     */   }
/*     */ 
/*     */   public int compareTo(Object other) {
/* 228 */     return compareTo((SynchronizedByte)other);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object other) {
/* 232 */     if ((other != null) && 
/* 233 */       ((other instanceof SynchronizedByte))) {
/* 234 */       return get() == ((SynchronizedByte)other).get();
/*     */     }
/* 236 */     return false;
/*     */   }
/*     */ 
/*     */   public int hashCode() {
/* 240 */     return get();
/*     */   }
/*     */   public String toString() {
/* 243 */     return Byte.toString(get());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.SynchronizedByte
 * JD-Core Version:    0.6.0
 */