/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ import java.beans.PropertyChangeEvent;
/*     */ import java.beans.PropertyChangeListener;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.util.HashMap;
/*     */ 
/*     */ public class PropertyChangeMulticaster
/*     */   implements Serializable
/*     */ {
/*  83 */   protected transient PropertyChangeListener[] listeners = new PropertyChangeListener[0];
/*     */   protected final Object source;
/*     */   protected HashMap children;
/*     */ 
/*     */   protected synchronized PropertyChangeMulticaster getChild(String propertyName)
/*     */   {
/* 104 */     return this.children == null ? null : 
/* 105 */       (PropertyChangeMulticaster)this.children.get(propertyName);
/*     */   }
/*     */ 
/*     */   public PropertyChangeMulticaster(Object sourceBean)
/*     */   {
/* 117 */     if (sourceBean == null) {
/* 118 */       throw new NullPointerException();
/*     */     }
/*     */ 
/* 121 */     this.source = sourceBean;
/*     */   }
/*     */ 
/*     */   public synchronized void addPropertyChangeListener(PropertyChangeListener listener)
/*     */   {
/* 136 */     if (listener == null) throw new NullPointerException();
/*     */ 
/* 138 */     int len = this.listeners.length;
/* 139 */     PropertyChangeListener[] newArray = new PropertyChangeListener[len + 1];
/* 140 */     if (len > 0)
/* 141 */       System.arraycopy(this.listeners, 0, newArray, 0, len);
/* 142 */     newArray[len] = listener;
/* 143 */     this.listeners = newArray;
/*     */   }
/*     */ 
/*     */   public synchronized void addPropertyChangeListenerIfAbsent(PropertyChangeListener listener)
/*     */   {
/* 160 */     if (listener == null) throw new NullPointerException();
/*     */ 
/* 163 */     int len = this.listeners.length;
/* 164 */     PropertyChangeListener[] newArray = new PropertyChangeListener[len + 1];
/* 165 */     for (int i = 0; i < len; i++) {
/* 166 */       newArray[i] = this.listeners[i];
/* 167 */       if (listener.equals(this.listeners[i]))
/* 168 */         return;
/*     */     }
/* 170 */     newArray[len] = listener;
/* 171 */     this.listeners = newArray;
/*     */   }
/*     */ 
/*     */   public synchronized void removePropertyChangeListener(PropertyChangeListener listener)
/*     */   {
/* 189 */     int newlen = this.listeners.length - 1;
/* 190 */     if ((newlen < 0) || (listener == null)) return;
/*     */ 
/* 194 */     PropertyChangeListener[] newArray = new PropertyChangeListener[newlen];
/*     */ 
/* 196 */     for (int i = 0; i < newlen; i++) {
/* 197 */       if (listener.equals(this.listeners[i]))
/*     */       {
/* 199 */         for (int k = i + 1; k <= newlen; k++) newArray[(k - 1)] = this.listeners[k];
/* 200 */         this.listeners = newArray;
/* 201 */         return;
/*     */       }
/*     */ 
/* 204 */       newArray[i] = this.listeners[i];
/*     */     }
/*     */ 
/* 208 */     if (listener.equals(this.listeners[newlen]))
/* 209 */       this.listeners = newArray;
/*     */   }
/*     */ 
/*     */   public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener)
/*     */   {
/* 227 */     if (listener == null) throw new NullPointerException();
/*     */ 
/* 229 */     PropertyChangeMulticaster child = null;
/*     */ 
/* 231 */     synchronized (this) {
/* 232 */       if (this.children == null)
/* 233 */         this.children = new HashMap();
/*     */       else {
/* 235 */         child = (PropertyChangeMulticaster)this.children.get(propertyName);
/*     */       }
/* 237 */       if (child == null) {
/* 238 */         child = new PropertyChangeMulticaster(this.source);
/* 239 */         this.children.put(propertyName, child);
/*     */       }
/*     */     }
/*     */ 
/* 243 */     child.addPropertyChangeListener(listener);
/*     */   }
/*     */ 
/*     */   public void addPropertyChangeListenerIfAbsent(String propertyName, PropertyChangeListener listener)
/*     */   {
/* 260 */     if (listener == null) throw new NullPointerException();
/*     */ 
/* 262 */     PropertyChangeMulticaster child = null;
/*     */ 
/* 264 */     synchronized (this) {
/* 265 */       if (this.children == null)
/* 266 */         this.children = new HashMap();
/*     */       else {
/* 268 */         child = (PropertyChangeMulticaster)this.children.get(propertyName);
/*     */       }
/* 270 */       if (child == null) {
/* 271 */         child = new PropertyChangeMulticaster(this.source);
/* 272 */         this.children.put(propertyName, child);
/*     */       }
/*     */     }
/*     */ 
/* 276 */     child.addPropertyChangeListenerIfAbsent(listener);
/*     */   }
/*     */ 
/*     */   public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener)
/*     */   {
/* 292 */     PropertyChangeMulticaster child = getChild(propertyName);
/* 293 */     if (child != null)
/* 294 */       child.removePropertyChangeListener(listener);
/*     */   }
/*     */ 
/*     */   protected void multicast(PropertyChangeEvent evt)
/*     */   {
/* 306 */     PropertyChangeMulticaster child = null;
/*     */ 
/* 308 */     synchronized (this) {
/* 309 */       PropertyChangeListener[] array = this.listeners;
/*     */ 
/* 311 */       if ((this.children != null) && (evt.getPropertyName() != null))
/* 312 */         child = (PropertyChangeMulticaster)this.children.get(evt.getPropertyName());
/*     */     }
/*     */     PropertyChangeListener[] array;
/* 315 */     for (int i = 0; i < array.length; i++) {
/* 316 */       array[i].propertyChange(evt);
/*     */     }
/* 318 */     if (child != null)
/* 319 */       child.multicast(evt);
/*     */   }
/*     */ 
/*     */   public void firePropertyChange(String propertyName, Object oldValue, Object newValue)
/*     */   {
/* 336 */     if ((oldValue == null) || (newValue == null) || (!oldValue.equals(newValue)))
/* 337 */       multicast(
/* 340 */         new PropertyChangeEvent(this.source, 
/* 338 */         propertyName, 
/* 339 */         oldValue, 
/* 340 */         newValue));
/*     */   }
/*     */ 
/*     */   public void firePropertyChange(String propertyName, int oldValue, int newValue)
/*     */   {
/* 359 */     if (oldValue != newValue)
/* 360 */       multicast(
/* 363 */         new PropertyChangeEvent(this.source, 
/* 361 */         propertyName, 
/* 362 */         new Integer(oldValue), 
/* 363 */         new Integer(newValue)));
/*     */   }
/*     */ 
/*     */   public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue)
/*     */   {
/* 382 */     if (oldValue != newValue)
/* 383 */       multicast(
/* 386 */         new PropertyChangeEvent(this.source, 
/* 384 */         propertyName, 
/* 385 */         new Boolean(oldValue), 
/* 386 */         new Boolean(newValue)));
/*     */   }
/*     */ 
/*     */   public void firePropertyChange(PropertyChangeEvent evt)
/*     */   {
/* 397 */     Object oldValue = evt.getOldValue();
/* 398 */     Object newValue = evt.getNewValue();
/* 399 */     if ((oldValue == null) || (newValue == null) || (!oldValue.equals(newValue)))
/* 400 */       multicast(evt);
/*     */   }
/*     */ 
/*     */   public boolean hasListeners(String propertyName)
/*     */   {
/* 415 */     synchronized (this) {
/* 416 */       if (this.listeners.length > 0)
/* 417 */         return true;
/* 418 */       if ((propertyName == null) || (this.children == null)) {
/* 419 */         return false;
/*     */       }
/* 421 */       PropertyChangeMulticaster child = (PropertyChangeMulticaster)this.children.get(propertyName);
/* 422 */       if (child == null)
/* 423 */         return false;
/*     */     }
/*     */     PropertyChangeMulticaster child;
/* 427 */     return child.hasListeners(null);
/*     */   }
/*     */ 
/*     */   private synchronized void writeObject(ObjectOutputStream s)
/*     */     throws IOException
/*     */   {
/* 439 */     s.defaultWriteObject();
/*     */ 
/* 441 */     for (int i = 0; i < this.listeners.length; i++) {
/* 442 */       PropertyChangeListener l = this.listeners[i];
/* 443 */       if ((this.listeners[i] instanceof Serializable)) {
/* 444 */         s.writeObject(this.listeners[i]);
/*     */       }
/*     */     }
/* 447 */     s.writeObject(null);
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException
/*     */   {
/* 452 */     this.listeners = new PropertyChangeListener[0];
/* 453 */     s.defaultReadObject();
/*     */     Object listenerOrNull;
/* 456 */     while ((listenerOrNull = s.readObject()) != null)
/*     */     {
/*     */       Object listenerOrNull;
/* 457 */       addPropertyChangeListener((PropertyChangeListener)listenerOrNull);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.PropertyChangeMulticaster
 * JD-Core Version:    0.6.0
 */