/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ public class FIFOReadWriteLock
/*     */   implements ReadWriteLock
/*     */ {
/*  46 */   protected final FIFOSemaphore entryLock = new FIFOSemaphore(1L);
/*     */   protected volatile int readers;
/*     */   protected int exreaders;
/* 180 */   protected final Sync readerSync = new ReaderSync();
/* 181 */   protected final Sync writerSync = new WriterSync();
/*     */ 
/*     */   protected void acquireRead()
/*     */     throws InterruptedException
/*     */   {
/*  68 */     this.entryLock.acquire();
/*  69 */     this.readers += 1;
/*  70 */     this.entryLock.release();
/*     */   }
/*     */ 
/*     */   protected synchronized void releaseRead()
/*     */   {
/*  86 */     if (++this.exreaders == this.readers)
/*  87 */       notify();
/*     */   }
/*     */ 
/*     */   protected void acquireWrite()
/*     */     throws InterruptedException
/*     */   {
/*  93 */     this.entryLock.acquire();
/*     */ 
/*  97 */     int r = this.readers;
/*     */     try
/*     */     {
/* 100 */       synchronized (this) {
/* 101 */         while (this.exreaders != r)
/* 102 */           wait();
/*     */       }
/*     */     }
/*     */     catch (InterruptedException ie) {
/* 106 */       this.entryLock.release();
/* 107 */       throw ie;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void releaseWrite() {
/* 112 */     this.entryLock.release();
/*     */   }
/*     */ 
/*     */   protected boolean attemptRead(long msecs) throws InterruptedException {
/* 116 */     if (!this.entryLock.attempt(msecs)) {
/* 117 */       return false;
/*     */     }
/* 119 */     this.readers += 1;
/* 120 */     this.entryLock.release();
/* 121 */     return true;
/*     */   }
/*     */ 
/*     */   protected boolean attemptWrite(long msecs) throws InterruptedException {
/* 125 */     long startTime = msecs <= 0L ? 0L : System.currentTimeMillis();
/*     */ 
/* 127 */     if (!this.entryLock.attempt(msecs)) {
/* 128 */       return false;
/*     */     }
/* 130 */     int r = this.readers;
/*     */     try
/*     */     {
/* 133 */       synchronized (this) {
/* 134 */         while (this.exreaders != r) {
/* 135 */           long timeLeft = msecs <= 0L ? 0L : 
/* 136 */             msecs - (System.currentTimeMillis() - startTime);
/*     */ 
/* 138 */           if (timeLeft <= 0L) {
/* 139 */             this.entryLock.release();
/* 140 */             return false;
/*     */           }
/*     */ 
/* 143 */           wait(timeLeft);
/*     */         }
/* 145 */         return true;
/*     */       }
/*     */     }
/*     */     catch (InterruptedException ie) {
/* 149 */       this.entryLock.release();
/* 150 */     }throw ie;
/*     */   }
/*     */ 
/*     */   public Sync writeLock()
/*     */   {
/* 183 */     return this.writerSync; } 
/* 184 */   public Sync readLock() { return this.readerSync;
/*     */   }
/*     */ 
/*     */   protected class ReaderSync
/*     */     implements Sync
/*     */   {
/*     */     protected ReaderSync()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void acquire()
/*     */       throws InterruptedException
/*     */     {
/* 158 */       FIFOReadWriteLock.this.acquireRead();
/*     */     }
/*     */     public void release() {
/* 161 */       FIFOReadWriteLock.this.releaseRead();
/*     */     }
/*     */     public boolean attempt(long msecs) throws InterruptedException {
/* 164 */       return FIFOReadWriteLock.this.attemptRead(msecs);
/*     */     }
/*     */   }
/*     */   protected class WriterSync implements Sync {
/*     */     protected WriterSync() {
/*     */     }
/*     */     public void acquire() throws InterruptedException {
/* 170 */       FIFOReadWriteLock.this.acquireWrite();
/*     */     }
/*     */     public void release() {
/* 173 */       FIFOReadWriteLock.this.releaseWrite();
/*     */     }
/*     */     public boolean attempt(long msecs) throws InterruptedException {
/* 176 */       return FIFOReadWriteLock.this.attemptWrite(msecs);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.FIFOReadWriteLock
 * JD-Core Version:    0.6.0
 */