/*      */ package EDU.oswego.cs.dl.util.concurrent;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.io.ObjectInputStream;
/*      */ import java.io.ObjectOutputStream;
/*      */ import java.io.Serializable;
/*      */ import java.util.AbstractCollection;
/*      */ import java.util.AbstractMap;
/*      */ import java.util.AbstractSet;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Collection;
/*      */ import java.util.Enumeration;
/*      */ import java.util.Iterator;
/*      */ import java.util.Map;
/*      */ import java.util.Map.Entry;
/*      */ import java.util.NoSuchElementException;
/*      */ import java.util.Set;
/*      */ 
/*      */ public class ConcurrentHashMap extends AbstractMap
/*      */   implements Map, Cloneable, Serializable
/*      */ {
/*      */   protected transient Entry[] table;
/*      */   protected static final int CONCURRENCY_LEVEL = 32;
/*      */   protected static final int SEGMENT_MASK = 31;
/*  220 */   protected final Segment[] segments = new Segment[32];
/*      */ 
/*  227 */   public static int DEFAULT_INITIAL_CAPACITY = 32;
/*      */   private static final int MINIMUM_CAPACITY = 32;
/*      */   private static final int MAXIMUM_CAPACITY = 1073741824;
/*      */   public static final float DEFAULT_LOAD_FACTOR = 0.75F;
/*      */   protected final float loadFactor;
/*      */   protected int threshold;
/*      */   protected volatile transient int votesForResize;
/*  847 */   protected transient Set keySet = null;
/*  848 */   protected transient Set entrySet = null;
/*  849 */   protected transient Collection values = null;
/*      */ 
/*      */   protected static int bitcount(int w)
/*      */   {
/*  285 */     w -= ((0xAAAAAAAA & w) >>> 1);
/*  286 */     w = (w & 0x33333333) + (w >>> 2 & 0x33333333);
/*  287 */     w = w + (w >>> 4) & 0xF0F0F0F;
/*  288 */     w += (w >>> 8);
/*  289 */     w += (w >>> 16);
/*  290 */     return w & 0xFF;
/*      */   }
/*      */ 
/*      */   private int p2capacity(int initialCapacity)
/*      */   {
/*  298 */     int cap = initialCapacity;
/*      */     int result;
/*      */     int result;
/*  302 */     if ((cap > 1073741824) || (cap < 0)) {
/*  303 */       result = 1073741824;
/*      */     } else {
/*  305 */       result = 32;
/*  306 */       while (result < cap)
/*  307 */         result <<= 1;
/*      */     }
/*  309 */     return result;
/*      */   }
/*      */ 
/*      */   protected static int hash(Object x)
/*      */   {
/*  318 */     int h = x.hashCode();
/*      */ 
/*  322 */     return (h << 7) - h + (h >>> 9) + (h >>> 17);
/*      */   }
/*      */ 
/*      */   protected boolean eq(Object x, Object y)
/*      */   {
/*  330 */     return (x == y) || (x.equals(y));
/*      */   }
/*      */ 
/*      */   protected Entry[] newTable(int capacity)
/*      */   {
/*  335 */     this.threshold = ((int)(capacity * this.loadFactor / 32.0F) + 1);
/*  336 */     return new Entry[capacity];
/*      */   }
/*      */ 
/*      */   public ConcurrentHashMap(int initialCapacity, float loadFactor)
/*      */   {
/*  358 */     if (loadFactor <= 0.0F)
/*  359 */       throw new IllegalArgumentException("Illegal Load factor: " + 
/*  360 */         loadFactor);
/*  361 */     this.loadFactor = loadFactor;
/*  362 */     for (int i = 0; i < this.segments.length; i++)
/*  363 */       this.segments[i] = new Segment();
/*  364 */     int cap = p2capacity(initialCapacity);
/*  365 */     this.table = newTable(cap);
/*      */   }
/*      */ 
/*      */   public ConcurrentHashMap(int initialCapacity)
/*      */   {
/*  379 */     this(initialCapacity, 0.75F);
/*      */   }
/*      */ 
/*      */   public ConcurrentHashMap()
/*      */   {
/*  387 */     this(DEFAULT_INITIAL_CAPACITY, 0.75F);
/*      */   }
/*      */ 
/*      */   public ConcurrentHashMap(Map t)
/*      */   {
/*  398 */     this(Math.max((int)(t.size() / 0.75F) + 1, 
/*  397 */       32), 
/*  398 */       0.75F);
/*  399 */     putAll(t);
/*      */   }
/*      */ 
/*      */   public int size()
/*      */   {
/*  408 */     int c = 0;
/*  409 */     for (int i = 0; i < this.segments.length; i++)
/*  410 */       c += this.segments[i].getCount();
/*  411 */     return c;
/*      */   }
/*      */ 
/*      */   public boolean isEmpty()
/*      */   {
/*  420 */     for (int i = 0; i < this.segments.length; i++)
/*  421 */       if (this.segments[i].getCount() != 0)
/*  422 */         return false;
/*  423 */     return true;
/*      */   }
/*      */ 
/*      */   public Object get(Object key)
/*      */   {
/*  439 */     int hash = hash(key);
/*      */ 
/*  442 */     Entry[] tab = this.table;
/*  443 */     int index = hash & tab.length - 1;
/*  444 */     Entry first = tab[index];
/*      */ 
/*  447 */     for (Entry e = first; e != null; e = e.next) {
/*  448 */       if ((e.hash == hash) && (eq(key, e.key))) {
/*  449 */         Object value = e.value;
/*  450 */         if (value == null) break;
/*  451 */         return value;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  458 */     Segment seg = this.segments[(hash & 0x1F)];
/*  459 */     synchronized (seg) {
/*  460 */       tab = this.table;
/*  461 */       index = hash & tab.length - 1;
/*  462 */       Entry newFirst = tab[index];
/*  463 */       if ((e != null) || (first != newFirst)) {
/*  464 */         for (e = newFirst; e != null; e = e.next) {
/*  465 */           if ((e.hash == hash) && (eq(key, e.key)))
/*  466 */             return e.value;
/*      */         }
/*      */       }
/*  469 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean containsKey(Object key)
/*      */   {
/*  486 */     return get(key) != null;
/*      */   }
/*      */ 
/*      */   public Object put(Object key, Object value)
/*      */   {
/*  510 */     if (value == null) {
/*  511 */       throw new NullPointerException();
/*      */     }
/*  513 */     int hash = hash(key);
/*  514 */     Segment seg = this.segments[(hash & 0x1F)];
/*      */ 
/*  519 */     synchronized (seg) {
/*  520 */       Entry[] tab = this.table;
/*  521 */       int index = hash & tab.length - 1;
/*  522 */       Entry first = tab[index];
/*      */ 
/*  524 */       for (Entry e = first; e != null; e = e.next) {
/*  525 */         if ((e.hash == hash) && (eq(key, e.key))) {
/*  526 */           Object oldValue = e.value;
/*  527 */           e.value = value;
/*  528 */           return oldValue;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  533 */       Entry newEntry = new Entry(hash, key, value, first);
/*  534 */       tab[index] = newEntry;
/*      */       int segcount;
/*  536 */       if ((segcount = ++seg.count) < this.threshold) {
/*  537 */         return null;
/*      */       }
/*  539 */       int bit = 1 << (hash & 0x1F);
/*  540 */       int votes = this.votesForResize;
/*  541 */       if ((votes & bit) == 0)
/*  542 */         votes = this.votesForResize |= bit;
/*      */     }
/*      */     int votes;
/*      */     Entry[] tab;
/*      */     int segcount;
/*  548 */     if ((bitcount(votes) >= 8) || 
/*  549 */       (segcount > this.threshold * 32)) {
/*  550 */       resize(0, tab);
/*      */     }
/*  552 */     return null;
/*      */   }
/*      */ 
/*      */   protected void resize(int index, Entry[] assumedTab)
/*      */   {
/*  565 */     Segment seg = this.segments[index];
/*  566 */     synchronized (seg) {
/*  567 */       if (assumedTab == this.table) {
/*  568 */         int next = index + 1;
/*  569 */         if (next < this.segments.length)
/*  570 */           resize(next, assumedTab);
/*      */         else
/*  572 */           rehash();
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected void rehash()
/*      */   {
/*  582 */     this.votesForResize = 0;
/*      */ 
/*  584 */     Entry[] oldTable = this.table;
/*  585 */     int oldCapacity = oldTable.length;
/*      */ 
/*  587 */     if (oldCapacity >= 1073741824) {
/*  588 */       this.threshold = 2147483647;
/*  589 */       return;
/*      */     }
/*      */ 
/*  592 */     int newCapacity = oldCapacity << 1;
/*  593 */     Entry[] newTable = newTable(newCapacity);
/*  594 */     int mask = newCapacity - 1;
/*      */ 
/*  610 */     for (int i = 0; i < oldCapacity; i++)
/*      */     {
/*  613 */       Entry e = oldTable[i];
/*      */ 
/*  615 */       if (e != null) {
/*  616 */         int idx = e.hash & mask;
/*  617 */         Entry next = e.next;
/*      */ 
/*  620 */         if (next == null) {
/*  621 */           newTable[idx] = e;
/*      */         }
/*      */         else
/*      */         {
/*  625 */           Entry lastRun = e;
/*  626 */           int lastIdx = idx;
/*  627 */           for (Entry last = next; last != null; last = last.next) {
/*  628 */             int k = last.hash & mask;
/*  629 */             if (k != lastIdx) {
/*  630 */               lastIdx = k;
/*  631 */               lastRun = last;
/*      */             }
/*      */           }
/*  634 */           newTable[lastIdx] = lastRun;
/*      */ 
/*  637 */           for (Entry p = e; p != lastRun; p = p.next) {
/*  638 */             int k = p.hash & mask;
/*  639 */             newTable[k] = 
/*  640 */               new Entry(p.hash, p.key, 
/*  640 */               p.value, newTable[k]);
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  646 */     this.table = newTable;
/*      */   }
/*      */ 
/*      */   public Object remove(Object key)
/*      */   {
/*  661 */     return remove(key, null);
/*      */   }
/*      */ 
/*      */   protected Object remove(Object key, Object value)
/*      */   {
/*  691 */     int hash = hash(key);
/*  692 */     Segment seg = this.segments[(hash & 0x1F)];
/*      */ 
/*  694 */     synchronized (seg) {
/*  695 */       Entry[] tab = this.table;
/*  696 */       int index = hash & tab.length - 1;
/*  697 */       Entry first = tab[index];
/*  698 */       Entry e = first;
/*      */       while (true)
/*      */       {
/*  701 */         if (e == null)
/*  702 */           return null;
/*  703 */         if ((e.hash == hash) && (eq(key, e.key)))
/*      */           break;
/*  705 */         e = e.next;
/*      */       }
/*      */ 
/*  708 */       Object oldValue = e.value;
/*  709 */       if ((value != null) && (!value.equals(oldValue))) {
/*  710 */         return null;
/*      */       }
/*  712 */       e.value = null;
/*      */ 
/*  714 */       Entry head = e.next;
/*  715 */       for (Entry p = first; p != e; p = p.next)
/*  716 */         head = new Entry(p.hash, p.key, p.value, head);
/*  717 */       tab[index] = head;
/*  718 */       seg.count -= 1;
/*  719 */       return oldValue;
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean containsValue(Object value)
/*      */   {
/*  737 */     if (value == null) throw new NullPointerException();
/*      */ 
/*  739 */     for (int s = 0; s < this.segments.length; s++) {
/*  740 */       Segment seg = this.segments[s];
/*      */       Entry[] tab;
/*  742 */       synchronized (seg) { tab = this.table;
/*      */       }
/*      */       Entry[] tab;
/*  743 */       for (int i = s; i < tab.length; i += this.segments.length) {
/*  744 */         for (Entry e = tab[i]; e != null; e = e.next)
/*  745 */           if (value.equals(e.value))
/*  746 */             return true;
/*      */       }
/*      */     }
/*  749 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean contains(Object value)
/*      */   {
/*  772 */     return containsValue(value);
/*      */   }
/*      */ 
/*      */   public void putAll(Map t)
/*      */   {
/*  785 */     int n = t.size();
/*  786 */     if (n == 0)
/*  787 */       return;
/*      */     while (true)
/*      */     {
/*      */       int max;
/*  795 */       synchronized (this.segments[0]) {
/*  796 */         Entry[] tab = this.table;
/*  797 */         max = this.threshold * 32;
/*      */       }
/*      */       int max;
/*      */       Entry[] tab;
/*  799 */       if (n < max)
/*      */         break;
/*  801 */       resize(0, tab);
/*      */     }
/*      */ 
/*  804 */     for (Iterator it = t.entrySet().iterator(); it.hasNext(); ) {
/*  805 */       Map.Entry entry = (Map.Entry)it.next();
/*  806 */       put(entry.getKey(), entry.getValue());
/*      */     }
/*      */   }
/*      */ 
/*      */   public void clear()
/*      */   {
/*  817 */     for (int s = 0; s < this.segments.length; s++) {
/*  818 */       Segment seg = this.segments[s];
/*  819 */       synchronized (seg) {
/*  820 */         Entry[] tab = this.table;
/*  821 */         for (int i = s; i < tab.length; i += this.segments.length) {
/*  822 */           for (Entry e = tab[i]; e != null; e = e.next)
/*  823 */             e.value = null;
/*  824 */           tab[i] = null;
/*  825 */           seg.count = 0;
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public Object clone()
/*      */   {
/*  842 */     return new ConcurrentHashMap(this);
/*      */   }
/*      */ 
/*      */   public Set keySet()
/*      */   {
/*  864 */     Set ks = this.keySet;
/*  865 */     return this.keySet = new KeySet(null);
/*      */   }
/*      */ 
/*      */   public Collection values()
/*      */   {
/*  925 */     Collection vs = this.values;
/*  926 */     return this.values = new Values(null);
/*      */   }
/*      */ 
/*      */   public Set entrySet()
/*      */   {
/*  984 */     Set es = this.entrySet;
/*  985 */     return this.entrySet = new EntrySet(null);
/*      */   }
/*      */ 
/*      */   public Enumeration keys()
/*      */   {
/* 1049 */     return new KeyIterator();
/*      */   }
/*      */ 
/*      */   public Enumeration elements()
/*      */   {
/* 1065 */     return new ValueIterator();
/*      */   }
/*      */ 
/*      */   private void writeObject(ObjectOutputStream s)
/*      */     throws IOException
/*      */   {
/* 1252 */     s.defaultWriteObject();
/*      */     int cap;
/* 1259 */     synchronized (this.segments[0]) { cap = this.table.length;
/*      */     }
/*      */     int cap;
/* 1260 */     s.writeInt(cap);
/*      */ 
/* 1263 */     for (int k = 0; k < this.segments.length; k++) {
/* 1264 */       Segment seg = this.segments[k];
/*      */       Entry[] tab;
/* 1266 */       synchronized (seg) { tab = this.table;
/*      */       }
/*      */       Entry[] tab;
/* 1267 */       for (int i = k; i < tab.length; i += this.segments.length) {
/* 1268 */         for (Entry e = tab[i]; e != null; e = e.next) {
/* 1269 */           s.writeObject(e.key);
/* 1270 */           s.writeObject(e.value);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1275 */     s.writeObject(null);
/* 1276 */     s.writeObject(null);
/*      */   }
/*      */ 
/*      */   private void readObject(ObjectInputStream s)
/*      */     throws IOException, ClassNotFoundException
/*      */   {
/* 1287 */     s.defaultReadObject();
/*      */ 
/* 1289 */     int cap = s.readInt();
/* 1290 */     this.table = newTable(cap);
/* 1291 */     for (int i = 0; i < this.segments.length; i++) {
/* 1292 */       this.segments[i] = new Segment();
/*      */     }
/*      */ 
/*      */     while (true)
/*      */     {
/* 1297 */       Object key = s.readObject();
/* 1298 */       Object value = s.readObject();
/* 1299 */       if (key == null)
/*      */         break;
/* 1301 */       put(key, value);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected static class Entry
/*      */     implements Map.Entry
/*      */   {
/*      */     protected final Object key;
/*      */     protected volatile Object value;
/*      */     protected final int hash;
/*      */     protected final Entry next;
/*      */ 
/*      */     Entry(int hash, Object key, Object value, Entry next)
/*      */     {
/* 1086 */       this.value = value;
/* 1087 */       this.hash = hash;
/* 1088 */       this.key = key;
/* 1089 */       this.next = next;
/*      */     }
/*      */ 
/*      */     public Object getKey()
/*      */     {
/* 1095 */       return this.key;
/*      */     }
/*      */ 
/*      */     public Object getValue()
/*      */     {
/* 1110 */       return this.value;
/*      */     }
/*      */ 
/*      */     public Object setValue(Object value)
/*      */     {
/* 1134 */       if (value == null)
/* 1135 */         throw new NullPointerException();
/* 1136 */       Object oldValue = this.value;
/* 1137 */       this.value = value;
/* 1138 */       return oldValue;
/*      */     }
/*      */ 
/*      */     public boolean equals(Object o) {
/* 1142 */       if (!(o instanceof Map.Entry))
/* 1143 */         return false;
/* 1144 */       Map.Entry e = (Map.Entry)o;
/* 1145 */       return (this.key.equals(e.getKey())) && (this.value.equals(e.getValue()));
/*      */     }
/*      */ 
/*      */     public int hashCode() {
/* 1149 */       return this.key.hashCode() ^ this.value.hashCode();
/*      */     }
/*      */ 
/*      */     public String toString() {
/* 1153 */       return this.key + "=" + this.value;
/*      */     }
/*      */   }
/*      */ 
/*      */   private class EntrySet extends AbstractSet
/*      */   {
/*      */     private EntrySet()
/*      */     {
/*      */     }
/*      */ 
/*      */     public Iterator iterator()
/*      */     {
/*  990 */       return new ConcurrentHashMap.HashIterator(ConcurrentHashMap.this);
/*      */     }
/*      */     public boolean contains(Object o) {
/*  993 */       if (!(o instanceof Map.Entry))
/*  994 */         return false;
/*  995 */       Map.Entry entry = (Map.Entry)o;
/*  996 */       Object v = ConcurrentHashMap.this.get(entry.getKey());
/*  997 */       return (v != null) && (v.equals(entry.getValue()));
/*      */     }
/*      */     public boolean remove(Object o) {
/* 1000 */       if (!(o instanceof Map.Entry))
/* 1001 */         return false;
/* 1002 */       Map.Entry e = (Map.Entry)o;
/* 1003 */       return ConcurrentHashMap.this.remove(e.getKey(), e.getValue()) != null;
/*      */     }
/*      */     public int size() {
/* 1006 */       return ConcurrentHashMap.this.size();
/*      */     }
/*      */     public void clear() {
/* 1009 */       ConcurrentHashMap.this.clear();
/*      */     }
/*      */     public Object[] toArray() {
/* 1012 */       Collection c = new ArrayList();
/* 1013 */       Object o = null;
/* 1014 */       for (Iterator i = iterator(); i.hasNext(); )
/*      */       {
/* 1016 */         o = i.next();
/* 1017 */         if (o == null)
/*      */           continue;
/* 1019 */         c.add(o);
/*      */       }
/*      */ 
/* 1022 */       return c.toArray();
/*      */     }
/*      */     public Object[] toArray(Object[] a) {
/* 1025 */       Collection c = new ArrayList();
/* 1026 */       Object o = null;
/* 1027 */       for (Iterator i = iterator(); i.hasNext(); )
/*      */       {
/* 1029 */         o = i.next();
/* 1030 */         if (o == null)
/*      */           continue;
/* 1032 */         c.add(o);
/*      */       }
/*      */ 
/* 1035 */       return c.toArray(a);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected class HashIterator
/*      */     implements Iterator, Enumeration
/*      */   {
/*      */     protected final ConcurrentHashMap.Entry[] tab;
/*      */     protected int index;
/* 1161 */     protected ConcurrentHashMap.Entry entry = null;
/*      */     protected Object currentKey;
/*      */     protected Object currentValue;
/* 1164 */     protected ConcurrentHashMap.Entry lastReturned = null;
/*      */ 
/*      */     protected HashIterator()
/*      */     {
/* 1168 */       synchronized (ConcurrentHashMap.this.segments[0]) { this.tab = ConcurrentHashMap.this.table; }
/* 1169 */       for (int i = 1; i < ConcurrentHashMap.this.segments.length; i++) ConcurrentHashMap.this.segments[i].synch();
/* 1170 */       this.index = (this.tab.length - 1);
/*      */     }
/*      */     public boolean hasMoreElements() {
/* 1173 */       return hasNext(); } 
/* 1174 */     public Object nextElement() { return next();
/*      */     }
/*      */ 
/*      */     public boolean hasNext()
/*      */     {
/*      */       do
/*      */       {
/* 1186 */         if (this.entry != null) {
/* 1187 */           Object v = this.entry.value;
/* 1188 */           if (v != null) {
/* 1189 */             this.currentKey = this.entry.key;
/* 1190 */             this.currentValue = v;
/* 1191 */             return true;
/*      */           }
/*      */ 
/* 1194 */           this.entry = this.entry.next;
/*      */         }
/*      */ 
/* 1197 */         while ((this.entry == null) && (this.index >= 0))
/* 1198 */           this.entry = this.tab[(this.index--)];
/*      */       }
/* 1200 */       while (this.entry != null);
/* 1201 */       this.currentKey = (this.currentValue = null);
/* 1202 */       return false;
/*      */     }
/*      */ 
/*      */     protected Object returnValueOfNext()
/*      */     {
/* 1207 */       return this.entry;
/*      */     }
/*      */     public Object next() {
/* 1210 */       if ((this.currentKey == null) && (!hasNext())) {
/* 1211 */         throw new NoSuchElementException();
/*      */       }
/* 1213 */       Object result = returnValueOfNext();
/* 1214 */       this.lastReturned = this.entry;
/* 1215 */       this.currentKey = (this.currentValue = null);
/* 1216 */       this.entry = this.entry.next;
/* 1217 */       return result;
/*      */     }
/*      */ 
/*      */     public void remove() {
/* 1221 */       if (this.lastReturned == null)
/* 1222 */         throw new IllegalStateException();
/* 1223 */       ConcurrentHashMap.this.remove(this.lastReturned.key);
/* 1224 */       this.lastReturned = null;
/*      */     }
/*      */   }
/*      */ 
/*      */   protected class KeyIterator extends ConcurrentHashMap.HashIterator {
/*      */     protected KeyIterator() {
/* 1229 */       super(); } 
/* 1230 */     protected Object returnValueOfNext() { return this.currentKey;
/*      */     }
/*      */   }
/*      */ 
/*      */   private class KeySet extends AbstractSet
/*      */   {
/*      */     private KeySet()
/*      */     {
/*      */     }
/*      */ 
/*      */     public Iterator iterator()
/*      */     {
/*  870 */       return new ConcurrentHashMap.KeyIterator(ConcurrentHashMap.this);
/*      */     }
/*      */     public int size() {
/*  873 */       return ConcurrentHashMap.this.size();
/*      */     }
/*      */     public boolean contains(Object o) {
/*  876 */       return ConcurrentHashMap.this.containsKey(o);
/*      */     }
/*      */     public boolean remove(Object o) {
/*  879 */       return ConcurrentHashMap.this.remove(o) != null;
/*      */     }
/*      */     public void clear() {
/*  882 */       ConcurrentHashMap.this.clear();
/*      */     }
/*      */     public Object[] toArray() {
/*  885 */       Collection c = new ArrayList();
/*  886 */       Object o = null;
/*  887 */       for (Iterator i = iterator(); i.hasNext(); )
/*      */       {
/*  889 */         o = i.next();
/*  890 */         if (o == null)
/*      */           continue;
/*  892 */         c.add(o);
/*      */       }
/*      */ 
/*  895 */       return c.toArray();
/*      */     }
/*      */     public Object[] toArray(Object[] a) {
/*  898 */       Collection c = new ArrayList();
/*  899 */       Object o = null;
/*  900 */       for (Iterator i = iterator(); i.hasNext(); )
/*      */       {
/*  902 */         o = i.next();
/*  903 */         if (o == null)
/*      */           continue;
/*  905 */         c.add(o);
/*      */       }
/*      */ 
/*  908 */       return c.toArray(a);
/*      */     }
/*      */   }
/*      */ 
/*      */   protected static final class Segment
/*      */     implements Serializable
/*      */   {
/*      */     protected int count;
/*      */ 
/*      */     protected synchronized int getCount()
/*      */     {
/*  208 */       return this.count;
/*      */     }
/*      */ 
/*      */     protected synchronized void synch()
/*      */     {
/*      */     }
/*      */   }
/*      */ 
/*      */   protected class ValueIterator extends ConcurrentHashMap.HashIterator
/*      */   {
/*      */     protected ValueIterator()
/*      */     {
/* 1233 */       super(); } 
/* 1234 */     protected Object returnValueOfNext() { return this.currentValue;
/*      */     }
/*      */   }
/*      */ 
/*      */   private class Values extends AbstractCollection
/*      */   {
/*      */     private Values()
/*      */     {
/*      */     }
/*      */ 
/*      */     public Iterator iterator()
/*      */     {
/*  931 */       return new ConcurrentHashMap.ValueIterator(ConcurrentHashMap.this);
/*      */     }
/*      */     public int size() {
/*  934 */       return ConcurrentHashMap.this.size();
/*      */     }
/*      */     public boolean contains(Object o) {
/*  937 */       return ConcurrentHashMap.this.containsValue(o);
/*      */     }
/*      */     public void clear() {
/*  940 */       ConcurrentHashMap.this.clear();
/*      */     }
/*      */     public Object[] toArray() {
/*  943 */       Collection c = new ArrayList();
/*  944 */       Object o = null;
/*  945 */       for (Iterator i = iterator(); i.hasNext(); )
/*      */       {
/*  947 */         o = i.next();
/*  948 */         if (o == null)
/*      */           continue;
/*  950 */         c.add(o);
/*      */       }
/*      */ 
/*  953 */       return c.toArray();
/*      */     }
/*      */     public Object[] toArray(Object[] a) {
/*  956 */       Collection c = new ArrayList();
/*  957 */       Object o = null;
/*  958 */       for (Iterator i = iterator(); i.hasNext(); )
/*      */       {
/*  960 */         o = i.next();
/*  961 */         if (o == null)
/*      */           continue;
/*  963 */         c.add(o);
/*      */       }
/*      */ 
/*  966 */       return c.toArray(a);
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap
 * JD-Core Version:    0.6.0
 */