/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.impl.jbc;

import org.jboss.cache.Fqn;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.LocalDistributableSessionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheListenerBase {
    private static final int JSESSION_FQN_INDEX = 0;
    private static final int WEBAPP_FQN_INDEX = 1;
    protected static final int SESSION_ID_FQN_INDEX = 2;
    private static final int SESSION_FQN_SIZE = 3;
    private static final int BUDDY_BACKUP_ROOT_OWNER_INDEX = BuddyManager.BUDDY_BACKUP_SUBTREE_FQN.size();
    protected static final int BUDDY_BACKUP_ROOT_OWNER_SIZE = BUDDY_BACKUP_ROOT_OWNER_INDEX + 1;
    protected LocalDistributableSessionManager manager_;
    private String contextHostPath_;

    CacheListenerBase(LocalDistributableSessionManager manager, String contextHostPath) {
        this.manager_ = manager;
        this.contextHostPath_ = contextHostPath;
    }

    protected boolean isFqnForOurWebapp(Fqn<String> fqn, boolean isBuddy) {
        try {
            if (this.contextHostPath_.equals(fqn.get(isBuddy ? BUDDY_BACKUP_ROOT_OWNER_SIZE + 1 : 1)) && "JSESSION".equals(fqn.get(isBuddy ? BUDDY_BACKUP_ROOT_OWNER_SIZE + 0 : 0))) {
                return true;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isFqnSessionRootSized(Fqn<String> fqn, boolean isBuddy) {
        return fqn.size() == (isBuddy ? BUDDY_BACKUP_ROOT_OWNER_SIZE + 3 : 3);
    }

    public static String getIdFromFqn(Fqn<String> fqn, boolean isBuddy) {
        return (String)fqn.get(isBuddy ? BUDDY_BACKUP_ROOT_OWNER_SIZE + 2 : 2);
    }

    public static boolean isBuddyFqn(Fqn<String> fqn) {
        try {
            return "_BUDDY_BACKUP_".equals(fqn.get(0));
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    public static String getBuddyOwner(Fqn<String> fqn) {
        return (String)fqn.get(BUDDY_BACKUP_ROOT_OWNER_INDEX);
    }
}

