/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.util.List;
import org.jboss.as.osgi.OSGiLogger;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.server.Services;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jboss.osgi.framework.ModuleLoaderProvider;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.resolver.XModuleIdentity;
import org.jboss.osgi.spi.NotImplementedException;

final class ModuleLoaderIntegration
extends ModuleLoader
implements ModuleLoaderProvider {
    private final InjectedValue<ServiceModuleLoader> injectedModuleLoader = new InjectedValue();
    private ServiceContainer serviceContainer;
    private ServiceTarget serviceTarget;

    static ServiceController<?> addService(ServiceTarget target) {
        ModuleLoaderIntegration service = new ModuleLoaderIntegration();
        ServiceBuilder builder = target.addService(org.jboss.osgi.framework.Services.MODULE_LOADER_PROVIDER, (Service)service);
        builder.addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ServiceModuleLoader.class, service.injectedModuleLoader);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        return builder.install();
    }

    private ModuleLoaderIntegration() {
    }

    public void start(StartContext context) throws StartException {
        ServiceController controller = context.getController();
        OSGiLogger.ROOT_LOGGER.debugf("Starting: %s in mode %s", controller.getName(), controller.getMode());
        this.serviceContainer = context.getController().getServiceContainer();
        this.serviceTarget = context.getChildTarget();
    }

    public void stop(StopContext context) {
        ServiceController controller = context.getController();
        OSGiLogger.ROOT_LOGGER.debugf("Stopping: %s in mode %s", controller.getName(), controller.getMode());
    }

    public ModuleLoaderProvider getValue() throws IllegalStateException {
        return this;
    }

    public ModuleLoader getModuleLoader() {
        return this;
    }

    public void addModule(ModuleSpec moduleSpec) {
        ModuleIdentifier identifier = moduleSpec.getModuleIdentifier();
        OSGiLogger.ROOT_LOGGER.debugf("Add module spec to loader: %s", identifier);
        ServiceName moduleSpecName = ServiceModuleLoader.moduleSpecServiceName((ModuleIdentifier)identifier);
        this.serviceTarget.addService(moduleSpecName, (Service)new ValueService((Value)new ImmediateValue((Object)moduleSpec))).install();
    }

    public void addModule(Module module) {
        ServiceName moduleServiceName = this.getModuleServiceName(module.getIdentifier());
        if (this.serviceContainer.getService(moduleServiceName) == null) {
            OSGiLogger.ROOT_LOGGER.debugf("Add module to loader: %s", module.getIdentifier());
            this.serviceTarget.addService(moduleServiceName, (Service)new ValueService((Value)new ImmediateValue((Object)module))).install();
        }
    }

    public void removeModule(ModuleIdentifier identifier) {
        ServiceName serviceName = this.getModuleSpecServiceName(identifier);
        ServiceController controller = this.serviceContainer.getService(serviceName);
        if (controller != null) {
            OSGiLogger.ROOT_LOGGER.debugf("Remove module spec fom loader: %s", serviceName);
            controller.setMode(ServiceController.Mode.REMOVE);
        }
        if ((controller = this.serviceContainer.getService(serviceName = this.getModuleServiceName(identifier))) != null) {
            OSGiLogger.ROOT_LOGGER.debugf("Remove module fom loader: %s", serviceName);
            controller.setMode(ServiceController.Mode.REMOVE);
        }
    }

    public ModuleIdentifier getModuleIdentifier(XModule resModule) {
        if (resModule == null) {
            throw OSGiMessages.MESSAGES.nullVar("resModule");
        }
        XModuleIdentity moduleId = resModule.getModuleId();
        String slot = moduleId.getVersion().toString();
        int revision = moduleId.getRevision();
        if (revision > 0) {
            slot = slot + "-rev" + revision;
        }
        String name = "deployment." + moduleId.getName();
        ModuleIdentifier identifier = ModuleIdentifier.create((String)name, (String)slot);
        resModule.addAttachment(ModuleIdentifier.class, (Object)identifier);
        return identifier;
    }

    protected ModuleSpec findModule(ModuleIdentifier identifier) throws ModuleLoadException {
        ModuleSpec moduleSpec = ((ServiceModuleLoader)this.injectedModuleLoader.getValue()).findModule(identifier);
        if (moduleSpec == null) {
            OSGiLogger.ROOT_LOGGER.debugf("Cannot obtain module spec for: %s", identifier);
        }
        return moduleSpec;
    }

    protected Module preloadModule(ModuleIdentifier identifier) throws ModuleLoadException {
        Module module = ModuleLoader.preloadModule((ModuleIdentifier)identifier, (ModuleLoader)((ModuleLoader)this.injectedModuleLoader.getValue()));
        if (module == null) {
            OSGiLogger.ROOT_LOGGER.debugf("Cannot obtain module for: %s", identifier);
        }
        return module;
    }

    public void setAndRelinkDependencies(Module module, List<DependencySpec> dependencies) throws ModuleLoadException {
        throw new NotImplementedException();
    }

    private ServiceName getModuleSpecServiceName(ModuleIdentifier identifier) {
        return ServiceModuleLoader.MODULE_SPEC_SERVICE_PREFIX.append(new String[]{identifier.getName()}).append(new String[]{identifier.getSlot()});
    }

    private ServiceName getModuleServiceName(ModuleIdentifier identifier) {
        return ServiceModuleLoader.MODULE_SERVICE_PREFIX.append(new String[]{identifier.getName()}).append(new String[]{identifier.getSlot()});
    }

    public String toString() {
        return ModuleLoaderIntegration.class.getSimpleName();
    }
}

