/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.Collections;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.osgi.parser.OSGiBundleResource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class OSGiRuntimeResource
implements Resource {
    private final Resource delegate;
    private SystemBundleControllerHolder systemBundleControllerHolder;

    public OSGiRuntimeResource() {
        this(Resource.Factory.create(), new SystemBundleControllerHolder());
    }

    public OSGiRuntimeResource(Resource delegate, SystemBundleControllerHolder holder) {
        this.delegate = delegate;
        this.systemBundleControllerHolder = holder;
    }

    public void setBundleContextServiceController(ServiceController<Bundle> serviceController) {
        this.systemBundleControllerHolder.systemBundleController = serviceController;
    }

    public ModelNode getModel() {
        return this.delegate.getModel();
    }

    public void writeModel(ModelNode newModel) {
        this.delegate.writeModel(newModel);
    }

    public boolean isModelDefined() {
        return this.delegate.isModelDefined();
    }

    public boolean hasChild(PathElement element) {
        if ("bundle".equals(element.getKey())) {
            return this.hasBundle(element);
        }
        return this.delegate.hasChild(element);
    }

    public Resource getChild(PathElement element) {
        if ("bundle".equals(element.getKey())) {
            return this.hasBundle(element) ? OSGiBundleResource.INSTANCE : null;
        }
        return this.delegate.getChild(element);
    }

    public Resource requireChild(PathElement element) {
        if ("bundle".equals(element.getKey())) {
            if (this.hasBundle(element)) {
                return OSGiBundleResource.INSTANCE;
            }
            throw new NoSuchElementException(element.toString());
        }
        return this.delegate.requireChild(element);
    }

    public boolean hasChildren(String childType) {
        if ("bundle".equals(childType)) {
            return this.getChildrenNames("bundle").size() > 0;
        }
        return this.delegate.hasChildren(childType);
    }

    public Resource navigate(PathAddress address) {
        if (address.size() > 0 && "bundle".equals(address.getElement(0).getKey())) {
            if (address.size() > 1) {
                throw new NoSuchElementException(address.subAddress(1).toString());
            }
            return OSGiBundleResource.INSTANCE;
        }
        return this.delegate.navigate(address);
    }

    public Set<String> getChildTypes() {
        HashSet<String> result = new HashSet<String>(this.delegate.getChildTypes());
        result.add("bundle");
        return result;
    }

    public Set<String> getChildrenNames(String childType) {
        if ("bundle".equals(childType)) {
            return this.getBundleIDs();
        }
        return this.delegate.getChildrenNames(childType);
    }

    public Set<Resource.ResourceEntry> getChildren(String childType) {
        if ("bundle".equals(childType)) {
            HashSet<Resource.ResourceEntry> result = new HashSet<Resource.ResourceEntry>();
            for (String id : this.getBundleIDs()) {
                result.add(new OSGiBundleResource.OSGiBundleResourceEntry(id));
            }
            return result;
        }
        return this.delegate.getChildren(childType);
    }

    public void registerChild(PathElement address, Resource resource) {
        if ("bundle".equals(address.getKey())) {
            throw new UnsupportedOperationException();
        }
        this.delegate.registerChild(address, resource);
    }

    public Resource removeChild(PathElement address) {
        if ("bundle".equals(address.getKey())) {
            throw new UnsupportedOperationException();
        }
        return this.delegate.removeChild(address);
    }

    public boolean isRuntime() {
        return false;
    }

    public boolean isProxy() {
        return false;
    }

    public Resource clone() {
        return new OSGiRuntimeResource(this.delegate.clone(), this.systemBundleControllerHolder);
    }

    private boolean hasBundle(PathElement element) {
        BundleContext ctx = this.getBundleContext();
        if (ctx == null) {
            return false;
        }
        try {
            long id = Long.parseLong(element.getValue());
            return ctx.getBundle(id) != null;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private Set<String> getBundleIDs() {
        BundleContext ctx = this.getBundleContext();
        if (ctx == null) {
            return Collections.emptySet();
        }
        TreeSet<String> result = new TreeSet<String>();
        for (Bundle b : ctx.getBundles()) {
            result.add(Long.toString(b.getBundleId()));
        }
        return result;
    }

    private BundleContext getBundleContext() {
        if (this.systemBundleControllerHolder.systemBundleController == null || this.systemBundleControllerHolder.systemBundleController.getState() != ServiceController.State.UP) {
            return null;
        }
        return ((Bundle)this.systemBundleControllerHolder.systemBundleController.getValue()).getBundleContext();
    }

    private static class SystemBundleControllerHolder {
        ServiceController<Bundle> systemBundleController;

        private SystemBundleControllerHolder() {
        }
    }
}

