/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.jmx.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class JMXSubsystemProviders {
    static final String RESOURCE_NAME = JMXSubsystemProviders.class.getPackage().getName() + ".LocalDescriptions";
    static final DescriptionProvider SUBSYSTEM = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = JMXSubsystemProviders.getResourceBundle(locale);
            ModelNode subsystem = new ModelNode();
            subsystem.get("description").set(bundle2.getString("jmx"));
            subsystem.get("head-comment-allowed").set(true);
            subsystem.get("tail-comment-allowed").set(true);
            subsystem.get("namespace").set(Namespace.JMX_1_0.getUriString());
            subsystem.get(new String[]{"attributes", "show-model", "description"}).set(bundle2.getString("show.model"));
            subsystem.get(new String[]{"attributes", "show-model", "type"}).set(ModelType.BOOLEAN);
            subsystem.get(new String[]{"attributes", "show-model", "required"}).set(false);
            subsystem.get(new String[]{"attributes", "show-model", "default"}).set(false);
            subsystem.get(new String[]{"attributes", "registry-binding", "description"}).set(bundle2.getString("registry.binding"));
            subsystem.get(new String[]{"attributes", "registry-binding", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "registry-binding", "required"}).set(true);
            subsystem.get(new String[]{"attributes", "server-binding", "description"}).set(bundle2.getString("server.binding"));
            subsystem.get(new String[]{"attributes", "server-binding", "type"}).set(ModelType.STRING);
            subsystem.get(new String[]{"attributes", "server-binding", "required"}).set(true);
            return subsystem;
        }
    };
    static final DescriptionProvider SUBSYTEM_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = JMXSubsystemProviders.getResourceBundle(locale);
            ModelNode subsystem = new ModelNode();
            subsystem.get("operation-name").set("add");
            subsystem.get("description").set(bundle2.getString("jmx.add"));
            subsystem.get(new String[]{"request-properties", "show-model", "description"}).set(bundle2.getString("show.model"));
            subsystem.get(new String[]{"request-properties", "show-model", "type"}).set(ModelType.BOOLEAN);
            subsystem.get(new String[]{"request-properties", "show-model", "required"}).set(false);
            subsystem.get(new String[]{"request-properties", "show-model", "default"}).set(false);
            return subsystem;
        }
    };
    static final DescriptionProvider JMX_CONNECTOR_ADD = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = JMXSubsystemProviders.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("operation-name").set("add-connector");
            op.get("description").set(bundle2.getString("jmx.connector.add"));
            op.get(new String[]{"request-properties", "registry-binding", "description"}).set(bundle2.getString("registry.binding"));
            op.get(new String[]{"request-properties", "registry-binding", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "registry-binding", "required"}).set(true);
            op.get(new String[]{"request-properties", "server-binding", "description"}).set(bundle2.getString("server.binding"));
            op.get(new String[]{"request-properties", "server-binding", "type"}).set(ModelType.STRING);
            op.get(new String[]{"request-properties", "server-binding", "required"}).set(true);
            op.get("reply-properties").setEmptyObject();
            return op;
        }
    };
    static final DescriptionProvider INVOKE_MBEAN_RAW = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = JMXSubsystemProviders.getResourceBundle(locale);
            ModelNode subsystem = new ModelNode();
            subsystem.get("operation-name").set("invoke-mbean-raw");
            subsystem.get("description").set("This is an internal method not fit for public consumption. It will be removed shortly. Therefore its use is not documented");
            return subsystem;
        }
    };
    static final DescriptionProvider GET_MBEAN_INFO_RAW = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = JMXSubsystemProviders.getResourceBundle(locale);
            ModelNode subsystem = new ModelNode();
            subsystem.get("operation-name").set("get-mbean-info-raw");
            subsystem.get("description").set("This is an internal method not fit for public consumption. It will be removed shortly. Therefore its use is not documented");
            return subsystem;
        }
    };
    static final DescriptionProvider JMX_CONNECTOR_REMOVE = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle2 = JMXSubsystemProviders.getResourceBundle(locale);
            ModelNode op = new ModelNode();
            op.get("operation-name").set("remove-connector");
            op.get("description").set(bundle2.getString("jmx.connector.remove"));
            op.get("request-properties").setEmptyObject();
            op.get("reply-properties").setEmptyObject();
            return op;
        }
    };

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

