/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.vault;

import java.util.StringTokenizer;
import org.jboss.security.vault.SecurityVault;
import org.jboss.security.vault.SecurityVaultException;
import org.jboss.security.vault.SecurityVaultFactory;

public class SecurityVaultUtil {
    public static final String VAULT_PREFIX = "VAULT";

    public static boolean isVaultFormat(char[] chars) {
        if (chars == null) {
            return false;
        }
        String str = new String(chars);
        return str.startsWith(VAULT_PREFIX);
    }

    public static boolean isVaultFormat(String str) {
        return str != null && str.startsWith(VAULT_PREFIX);
    }

    public static char[] getValue(String vaultString) throws SecurityVaultException {
        if (!SecurityVaultUtil.isVaultFormat(vaultString)) {
            throw new IllegalArgumentException("vaultString is of the wrong format:" + vaultString);
        }
        String[] tokens = SecurityVaultUtil.tokens(vaultString);
        SecurityVault vault = SecurityVaultFactory.get();
        if (!vault.isInitialized()) {
            throw new SecurityVaultException("Vault is not initialized");
        }
        return vault.retrieve(tokens[1], tokens[2], tokens[3].getBytes());
    }

    public static String getValueAsString(String vaultString) throws SecurityVaultException {
        char[] val = SecurityVaultUtil.getValue(vaultString);
        if (val != null) {
            return new String(val);
        }
        return null;
    }

    public static char[] getValue(char[] chars) throws SecurityVaultException {
        if (chars == null) {
            return null;
        }
        String vaultString = new String(chars);
        return SecurityVaultUtil.getValue(vaultString);
    }

    private static String[] tokens(String vaultString) {
        StringTokenizer tokenizer = new StringTokenizer(vaultString, "::");
        int length = tokenizer.countTokens();
        String[] tokens = new String[length];
        int index = 0;
        while (tokenizer != null && tokenizer.hasMoreTokens()) {
            tokens[index++] = tokenizer.nextToken();
        }
        return tokens;
    }
}

