/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.security;

import javax.security.jacc.PolicyConfiguration;
import org.jboss.as.ejb3.deployment.EjbSecurityDeployer;
import org.jboss.as.security.service.JaccService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public class JaccEjbDeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EjbSecurityDeployer deployer = null;
        deployer = new EjbSecurityDeployer();
        JaccService service = deployer.deploy(deploymentUnit);
        if (service != null) {
            DeploymentUnit parentDU = deploymentUnit.getParent();
            ServiceName jaccServiceName = this.getJaccServiceName(deploymentUnit);
            ServiceTarget serviceTarget = phaseContext.getServiceTarget();
            ServiceBuilder builder = serviceTarget.addService(jaccServiceName, (Service)service);
            if (parentDU != null) {
                builder.addDependency(JaccService.SERVICE_NAME.append(new String[]{parentDU.getName()}), PolicyConfiguration.class, service.getParentPolicyInjector());
            }
            builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        ServiceController serviceController;
        EjbSecurityDeployer deployer = null;
        deployer = new EjbSecurityDeployer();
        deployer.undeploy(deploymentUnit);
        ServiceName jaccServiceName = this.getJaccServiceName(deploymentUnit);
        ServiceRegistry registry = deploymentUnit.getServiceRegistry();
        if (registry != null && (serviceController = registry.getService(jaccServiceName)) != null) {
            serviceController.setMode(ServiceController.Mode.REMOVE);
        }
    }

    private ServiceName getJaccServiceName(DeploymentUnit deploymentUnit) {
        String name = deploymentUnit.getName();
        DeploymentUnit parentDU = deploymentUnit.getParent();
        ServiceName jaccServiceName = JaccService.SERVICE_NAME.append(new String[]{name}).append(new String[]{"ejb"});
        if (parentDU != null) {
            jaccServiceName = jaccServiceName.append(new String[]{parentDU.getName()});
        }
        return jaccServiceName;
    }
}

