/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers;

import java.util.List;
import java.util.logging.Handler;
import org.jboss.as.controller.AbstractModelUpdateHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.util.LogServices;
import org.jboss.as.logging.util.ModelParser;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

public class HandlerLevelChange
extends AbstractModelUpdateHandler {
    public static final String OPERATION_NAME = "change-log-level";
    public static final HandlerLevelChange INSTANCE = new HandlerLevelChange();

    protected void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        CommonAttributes.LEVEL.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String name = address.getLastElement().getValue();
        ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
        ServiceController controller = serviceRegistry.getService(LogServices.handlerName(name));
        ModelNode level = CommonAttributes.LEVEL.resolveModelAttribute(context, model);
        if (controller != null && level.isDefined()) {
            ((Handler)controller.getValue()).setLevel(ModelParser.parseLevel(level));
        }
    }
}

