/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.services.bootstrap;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import javax.ejb.EJB;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.EEApplicationDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.weld.WeldMessages;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.vfs.VirtualFile;
import org.jboss.weld.injection.spi.EjbInjectionServices;

public class WeldEjbInjectionServices
implements EjbInjectionServices {
    private final ServiceRegistry serviceRegistry;
    private final EEModuleDescription moduleDescription;
    private final EEApplicationDescription applicationDescription;
    private final VirtualFile deploymentRoot;

    public WeldEjbInjectionServices(ServiceRegistry serviceRegistry, EEModuleDescription moduleDescription, EEApplicationDescription applicationDescription, VirtualFile deploymentRoot) {
        if (serviceRegistry == null) {
            throw WeldMessages.MESSAGES.parameterCannotBeNull("serviceRegistry");
        }
        if (moduleDescription == null) {
            throw WeldMessages.MESSAGES.parameterCannotBeNull("moduleDescription");
        }
        if (applicationDescription == null) {
            throw WeldMessages.MESSAGES.parameterCannotBeNull("applicationDescription");
        }
        if (deploymentRoot == null) {
            throw WeldMessages.MESSAGES.parameterCannotBeNull("deploymentRoot");
        }
        this.serviceRegistry = serviceRegistry;
        this.moduleDescription = moduleDescription;
        this.applicationDescription = applicationDescription;
        this.deploymentRoot = deploymentRoot;
    }

    public Object resolveEjb(InjectionPoint injectionPoint) {
        EJB ejb = (EJB)injectionPoint.getAnnotated().getAnnotation(EJB.class);
        if (ejb == null) {
            throw WeldMessages.MESSAGES.annotationNotFound(EJB.class, injectionPoint.getMember());
        }
        if (injectionPoint.getMember() instanceof Method && ((Method)injectionPoint.getMember()).getParameterTypes().length != 1) {
            throw WeldMessages.MESSAGES.injectionPointNotAJavabean((Method)injectionPoint.getMember());
        }
        if (!ejb.lookup().equals("")) {
            ContextNames.BindInfo ejbBindInfo = ContextNames.bindInfoFor((String)this.moduleDescription.getApplicationName(), (String)this.moduleDescription.getModuleName(), (String)this.moduleDescription.getModuleName(), (String)ejb.lookup());
            ServiceController controller = this.serviceRegistry.getRequiredService(ejbBindInfo.getBinderServiceName());
            ManagedReferenceFactory factory = (ManagedReferenceFactory)controller.getValue();
            return factory.getReference().getInstance();
        }
        Set viewService = ejb.beanName().isEmpty() ? (ejb.beanInterface() != Object.class ? this.applicationDescription.getComponentsForViewName(ejb.beanInterface().getName(), this.deploymentRoot) : this.applicationDescription.getComponentsForViewName(WeldEjbInjectionServices.getType(injectionPoint.getType()).getName(), this.deploymentRoot)) : (ejb.beanInterface() != Object.class ? this.applicationDescription.getComponents(ejb.beanName(), ejb.beanInterface().getName(), this.deploymentRoot) : this.applicationDescription.getComponents(ejb.beanName(), WeldEjbInjectionServices.getType(injectionPoint.getType()).getName(), this.deploymentRoot));
        if (viewService.isEmpty()) {
            throw WeldMessages.MESSAGES.ejbNotResolved(ejb, injectionPoint.getMember());
        }
        if (viewService.size() > 1) {
            throw WeldMessages.MESSAGES.moreThanOneEjbResolved(ejb, injectionPoint.getMember(), viewService);
        }
        ViewDescription viewDescription = (ViewDescription)viewService.iterator().next();
        ServiceController controller = this.serviceRegistry.getRequiredService(viewDescription.getServiceName());
        ComponentView view = (ComponentView)controller.getValue();
        try {
            return view.createInstance().getInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void cleanup() {
    }

    private static Class<?> getType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return WeldEjbInjectionServices.getType(((ParameterizedType)type).getRawType());
        }
        throw WeldMessages.MESSAGES.couldNotDetermineUnderlyingType(type);
    }
}

