/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.service;

import java.util.List;
import javax.inject.Inject;
import org.jboss.as.arquillian.service.ArquillianConfig;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceBuilder;

public class FrameworkActivationProcessor {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.arquillian");
    private static final AttachmentKey<Boolean> ADD_FRAMEWORK_DEP = AttachmentKey.create(Boolean.class);

    static void processDependencies(ServiceBuilder<ArquillianConfig> builder, ArquillianConfig arqConfig) {
        DeploymentUnit deploymentUnit = arqConfig.getDeploymentUnit();
        Boolean addAttachment = (Boolean)deploymentUnit.getAttachment(ADD_FRAMEWORK_DEP);
        if (addAttachment != null && addAttachment.booleanValue()) {
            arqConfig.addFrameworkDependency(builder);
        }
    }

    static void handleParseAnnotations(DeploymentUnit depUnit) {
        CompositeIndex compositeIndex = (CompositeIndex)depUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (compositeIndex == null) {
            log.warnf("Cannot find composite annotation index in: %s", (Object)depUnit);
            return;
        }
        DotName dotName = DotName.createSimple((String)Inject.class.getName());
        List annotationList = compositeIndex.getAnnotations(dotName);
        if (annotationList.isEmpty()) {
            return;
        }
        for (AnnotationInstance instance : annotationList) {
            FieldInfo fieldInfo;
            String typeName;
            AnnotationTarget target = instance.target();
            if (!(target instanceof FieldInfo) || !(typeName = (fieldInfo = (FieldInfo)target).type().toString()).startsWith("org.osgi.framework")) continue;
            log.debugf("OSGi injection point of type '%s' detected: %s", (Object)typeName, (Object)fieldInfo.declaringClass());
            depUnit.putAttachment(ADD_FRAMEWORK_DEP, (Object)true);
            break;
        }
    }
}

