/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.as.arquillian.container.ArchiveDeployer;
import org.jboss.as.arquillian.container.Authentication;
import org.jboss.as.arquillian.container.CommonContainerConfiguration;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.util.NotImplementedException;

public abstract class CommonDeployableContainer<T extends CommonContainerConfiguration>
implements DeployableContainer<T> {
    private final Logger log = Logger.getLogger(CommonDeployableContainer.class.getName());
    private T containerConfig;
    private ManagementClient managementClient;
    @Inject
    @ContainerScoped
    private InstanceProducer<ArchiveDeployer> archiveDeployerInst;

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("jmx-as7");
    }

    public void setup(T config) {
        this.containerConfig = config;
    }

    public final void start() throws LifecycleException {
        ModelControllerClient modelControllerClient = ModelControllerClient.Factory.create((InetAddress)((CommonContainerConfiguration)this.containerConfig).getManagementAddress(), (int)((CommonContainerConfiguration)this.containerConfig).getManagementPort(), (CallbackHandler)Authentication.getCallbackHandler());
        this.managementClient = new ManagementClient(modelControllerClient, ((CommonContainerConfiguration)this.containerConfig).getManagementAddress().getHostAddress());
        this.archiveDeployerInst.set((Object)new ArchiveDeployer(ServerDeploymentManager.Factory.create((ModelControllerClient)modelControllerClient)));
        try {
            this.startInternal();
        }
        catch (LifecycleException e) {
            this.safeCloseClient();
            throw e;
        }
    }

    protected abstract void startInternal() throws LifecycleException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() throws LifecycleException {
        try {
            this.stopInternal();
        }
        finally {
            this.safeCloseClient();
        }
    }

    protected abstract void stopInternal() throws LifecycleException;

    protected T getContainerConfiguration() {
        return this.containerConfig;
    }

    protected ManagementClient getManagementClient() {
        return this.managementClient;
    }

    protected ModelControllerClient getModelControllerClient() {
        return this.managementClient.getControllerClient();
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        ArchiveDeployer archiveDeployer = (ArchiveDeployer)this.archiveDeployerInst.get();
        String runtimeName = archiveDeployer.deploy(archive);
        return this.managementClient.getDeploymentMetaData(runtimeName);
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        ArchiveDeployer archiveDeployer = (ArchiveDeployer)this.archiveDeployerInst.get();
        archiveDeployer.undeploy(archive.getName());
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new NotImplementedException();
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new NotImplementedException();
    }

    private void safeCloseClient() {
        try {
            this.managementClient.close();
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Caught exception closing ModelControllerClient", e);
        }
    }
}

