/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support.rule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.jasig.services.persondir.IPersonAttributes;
import org.jasig.services.persondir.support.AbstractDefaultAttributePersonAttributeDao;
import org.jasig.services.persondir.support.SimpleUsernameAttributeProvider;
import org.jasig.services.persondir.support.rule.AttributeRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeclaredRulePersonAttributeDao
extends AbstractDefaultAttributePersonAttributeDao {
    private List<AttributeRule> rules;

    public DeclaredRulePersonAttributeDao(String attributeName, List<AttributeRule> rules) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating DeclaredRulePersonAttributeDao with attributeName='" + attributeName + "' and rules='" + rules + "'"));
        }
        SimpleUsernameAttributeProvider usernameAttributeProvider = new SimpleUsernameAttributeProvider(attributeName);
        this.setUsernameAttributeProvider(usernameAttributeProvider);
        this.setRules(rules);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Created DeclaredRulePersonAttributeDao with attributeName='" + attributeName + "' and rules='" + rules + "'"));
        }
    }

    public List<AttributeRule> getRules() {
        return this.rules;
    }

    public void setRules(List<AttributeRule> rules) {
        Validate.notEmpty(rules, (String)"Argument 'rules' cannot be null or empty.");
        this.rules = Collections.unmodifiableList(new ArrayList<AttributeRule>(rules));
    }

    public Set<IPersonAttributes> getPeopleWithMultivaluedAttributes(Map<String, List<Object>> seed) {
        Validate.notNull(seed, (String)"Argument 'seed' cannot be null.");
        for (AttributeRule rule : this.rules) {
            if (!rule.appliesTo(seed)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Evaluating rule='" + rule + "' from the rules List"));
            }
            return rule.evaluate(seed);
        }
        return null;
    }

    public Set<String> getPossibleUserAttributeNames() {
        LinkedHashSet<String> rslt = new LinkedHashSet<String>();
        for (AttributeRule rule : this.rules) {
            Set<String> possibleUserAttributeNames = rule.getPossibleUserAttributeNames();
            rslt.addAll(possibleUserAttributeNames);
        }
        return rslt;
    }

    public Set<String> getAvailableQueryAttributes() {
        LinkedHashSet<String> rslt = new LinkedHashSet<String>();
        for (AttributeRule rule : this.rules) {
            Set<String> possibleUserAttributeNames = rule.getAvailableQueryAttributes();
            rslt.addAll(possibleUserAttributeNames);
        }
        return rslt;
    }
}

