/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.util.Arrays;
import org.infinispan.server.hotrod.Encoder2x;
import org.infinispan.server.hotrod.Encoder4x;
import org.infinispan.server.hotrod.VersionedEncoder;

public enum HotRodVersion {
    UNKNOWN(0, 0),
    HOTROD_20(2, 0),
    HOTROD_21(2, 1),
    HOTROD_22(2, 2),
    HOTROD_23(2, 3),
    HOTROD_24(2, 4),
    HOTROD_25(2, 5),
    HOTROD_26(2, 6),
    HOTROD_27(2, 7),
    HOTROD_28(2, 8),
    HOTROD_29(2, 9),
    HOTROD_30(3, 0),
    HOTROD_31(3, 1),
    HOTROD_40(4, 0);

    private final int major;
    private final int minor;
    private final byte version;
    private final String text;
    public static final HotRodVersion LATEST;
    private static final HotRodVersion[] VERSIONS;

    private HotRodVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
        this.version = (byte)(major * 10 + minor);
        this.text = this.version > 0 ? String.format("HOTROD/%d.%d", major, minor) : "UNKNOWN";
    }

    public byte getVersion() {
        return this.version;
    }

    public boolean isOlder(byte version) {
        return this.version > version;
    }

    public boolean isAtLeast(byte version) {
        return this.version <= version;
    }

    public String toString() {
        return this.text;
    }

    public static HotRodVersion forVersion(byte version) {
        return VERSIONS[version];
    }

    public static VersionedEncoder getEncoder(byte version) {
        if (HOTROD_40.isAtLeast(version)) {
            return Encoder4x.instance();
        }
        return Encoder2x.instance();
    }

    static {
        VERSIONS = new HotRodVersion[256];
        LATEST = HotRodVersion.values()[HotRodVersion.values().length - 1];
        Arrays.fill((Object[])VERSIONS, (Object)UNKNOWN);
        HotRodVersion[] hotRodVersionArray = HotRodVersion.values();
        int n = hotRodVersionArray.length;
        for (int i = 0; i < n; ++i) {
            HotRodVersion version;
            HotRodVersion.VERSIONS[version.version] = version = hotRodVersionArray[i];
        }
    }
}

